/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.LogbackLevel;
import io.bootique.logback.LoggerFactory;
import io.bootique.logback.appender.AppenderFactory;
import io.bootique.logback.appender.ConsoleAppenderFactory;
import io.bootique.shutdown.ShutdownManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@BQConfig
public class LogbackContextFactory {
    private LogbackLevel level = LogbackLevel.info;
    private Map<String, LoggerFactory> loggers = Collections.emptyMap();
    private Collection<AppenderFactory> appenders = Collections.emptyList();
    private boolean useLogbackConfig = false;
    private boolean debugLogback;

    public Logger createRootLogger(ShutdownManager shutdownManager, Map<String, java.util.logging.Level> defaultLevels) {
        LoggerContext context = this.createLogbackContext();
        shutdownManager.addShutdownHook(() -> context.stop());
        this.rerouteJUL();
        Logger root = context.getLogger("ROOT");
        if (!this.useLogbackConfig) {
            Map<String, LoggerFactory> loggers = this.mergeLevels(defaultLevels);
            this.configLogbackContext(context, root, loggers);
        }
        return root;
    }

    protected void configLogbackContext(LoggerContext context, Logger root, Map<String, LoggerFactory> loggers) {
        context.reset();
        if (this.debugLogback) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)context, (OnConsoleStatusListener)new OnConsoleStatusListener());
        }
        LevelChangePropagator propagator = new LevelChangePropagator();
        propagator.setContext((Context)context);
        propagator.setResetJUL(true);
        context.addListener((LoggerContextListener)propagator);
        root.setLevel(Level.toLevel((String)this.level.name(), (Level)Level.INFO));
        loggers.forEach((name, lf) -> lf.configLogger((String)name, context));
        if (this.appenders.isEmpty()) {
            this.setAppenders(Collections.singletonList(new ConsoleAppenderFactory()));
        }
        this.appenders.forEach(a -> root.addAppender(a.createAppender(context)));
    }

    protected Map<String, LoggerFactory> mergeLevels(Map<String, java.util.logging.Level> levels) {
        if (levels.isEmpty()) {
            return this.loggers;
        }
        HashMap<String, LoggerFactory> merged = new HashMap<String, LoggerFactory>(this.loggers);
        levels.forEach((name, level) -> {
            LoggerFactory factory = this.loggers.get(name);
            if (factory == null) {
                factory = new LoggerFactory();
                factory.setLevel(this.mapJULLevel((java.util.logging.Level)level));
                merged.put((String)name, factory);
            }
        });
        return merged;
    }

    protected LogbackLevel mapJULLevel(java.util.logging.Level level) {
        return JulLevel.valueOf(level.getName()).getLevel();
    }

    protected LoggerContext createLogbackContext() {
        long startTime = System.nanoTime();
        ILoggerFactory iLoggerFactory;
        while (!((iLoggerFactory = org.slf4j.LoggerFactory.getILoggerFactory()) instanceof LoggerContext)) {
            if (System.nanoTime() - startTime > 10000000L) {
                throw new IllegalStateException("Unable to acquire the logger context");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return (LoggerContext)iLoggerFactory;
    }

    void rerouteJUL() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public LogbackLevel getLevel() {
        return this.level;
    }

    @BQConfigProperty(value="Root log level. Can be overridden by individual loggers. The default is 'info'.")
    public void setLevel(LogbackLevel level) {
        this.level = level;
    }

    public Map<String, LoggerFactory> getLoggers() {
        return this.loggers;
    }

    @BQConfigProperty(value="Per-package or per-class loggers. Keys in the map are logger names.")
    public void setLoggers(Map<String, LoggerFactory> loggers) {
        this.loggers = loggers;
    }

    public Collection<AppenderFactory> getAppenders() {
        return this.appenders;
    }

    @BQConfigProperty(value="One or more appenders that will render the logs to console, file, etc. If the list is empty, console appender is used with default settings.")
    public void setAppenders(Collection<AppenderFactory> appenders) {
        this.appenders = appenders;
    }

    @BQConfigProperty(value="If true, all Bootique logback settings are ignored and the user is expected to provide its own config file per Logback documentation. This is only needed for a few advanced options not directly available via Bootique config. So the value should stay false (which is the default).")
    public void setUseLogbackConfig(boolean useLogbackConfig) {
        this.useLogbackConfig = useLogbackConfig;
    }

    @BQConfigProperty(value="If true, Logback configuration debugging information will be printed to console. Helps to deal with Logback configuration issues.")
    public void setDebugLogback(boolean debugLogback) {
        this.debugLogback = debugLogback;
    }

    private static enum JulLevel {
        ALL(LogbackLevel.all),
        CONFIG(LogbackLevel.debug),
        FINE(LogbackLevel.debug),
        FINER(LogbackLevel.debug),
        FINEST(LogbackLevel.trace),
        INFO(LogbackLevel.info),
        OFF(LogbackLevel.off),
        SEVERE(LogbackLevel.error),
        WARNING(LogbackLevel.warn);

        private LogbackLevel level;

        private JulLevel(LogbackLevel level) {
            this.level = level;
        }

        public LogbackLevel getLevel() {
            return this.level;
        }
    }
}

