/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import io.continual.util.data.TypeConvertor;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class OneWayHasher {
    private OneWayHasher() {
    }

    public static String digest(String input) {
        return OneWayHasher.pbkdf2HashToString(input, "(non-empty salt)");
    }

    public static String hash(String input, String salt) {
        return OneWayHasher.pbkdf2HashToString(input, salt);
    }

    public static String pbkdf2HashToString(String input, String salt) {
        byte[] bytes = OneWayHasher.pbkdf2Hash(input, salt);
        return TypeConvertor.bytesToHexString(bytes);
    }

    public static byte[] pbkdf2Hash(String input, String salt) {
        try {
            String algorithm = "PBKDF2WithHmacSHA1";
            int derivedKeyLength = 160;
            int iterations = 20000;
            PBEKeySpec spec = new PBEKeySpec(input.toCharArray(), salt.getBytes(), 20000, 160);
            SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            return f.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

