/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import com.github.f4b6a3.ulid.Ulid;
import io.continual.util.data.OneWayHasher;
import io.continual.util.data.TypeConvertor;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UniqueStringGenerator {
    private static final String kLicenseKeyAlphabet = "123456789BCDFGHJKLMNPQRTVWXYZ";
    private static final String kUrlKeyAlphabet = "0123456789ABCDFGHJKLMNPQRTVWXYZabcdefhigjklmnopqrstuvwxyz";

    public static String createUlid() {
        return Ulid.fast().toString();
    }

    public static String create(String nonsense) {
        byte[] val = UniqueStringGenerator.createValue(nonsense);
        return TypeConvertor.bytesToHexString(val);
    }

    public static String createKeyUsingAlphabet(String nonsense, String alphabet) {
        int alphabetLength = alphabet.length();
        byte[] bytes = UniqueStringGenerator.createValue(nonsense);
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            int letterIndex = Math.abs(b) % alphabetLength;
            char letter = alphabet.charAt(letterIndex);
            sb.append(letter);
        }
        return sb.toString();
    }

    public static String createKeyUsingAlphabet(String nonsense, String alphabet, int length) {
        Object result = UniqueStringGenerator.createKeyUsingAlphabet(nonsense, alphabet);
        while (((String)result).length() < length) {
            result = (String)result + UniqueStringGenerator.createKeyUsingAlphabet(nonsense, alphabet);
        }
        return ((String)result).substring(0, length);
    }

    public static String createUrlKey(String nonsense) {
        return UniqueStringGenerator.createKeyUsingAlphabet(nonsense, kUrlKeyAlphabet);
    }

    public static String createMsStyleKeyString(String nonsense) {
        String original = UniqueStringGenerator.createKeyUsingAlphabet(nonsense, kLicenseKeyAlphabet);
        StringBuffer sb = new StringBuffer();
        int position = -1;
        for (int i = 0; i < original.length(); ++i) {
            char letter = original.charAt(i);
            if (++position > 0 && position % 5 == 0) {
                sb.append(" ");
            }
            sb.append(letter);
        }
        return sb.toString();
    }

    public static String createEncodedUuid() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        byte[] uuidArray = bb.array();
        String encoded = TypeConvertor.base64Encode(uuidArray);
        if (encoded.endsWith("==")) {
            encoded = encoded.substring(0, encoded.length() - 2);
        } else if (encoded.endsWith("=")) {
            encoded = encoded.substring(0, encoded.length() - 1);
        }
        return encoded;
    }

    private UniqueStringGenerator() {
    }

    private static byte[] createValue(String nonsense) {
        StringBuffer sb = new StringBuffer();
        sb.append(UUID.randomUUID().toString());
        if (nonsense != null) {
            sb.append(nonsense);
        }
        sb.append(System.currentTimeMillis());
        return OneWayHasher.pbkdf2Hash(UUID.randomUUID().toString(), sb.toString());
    }
}

