/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.nv.impl;

import io.continual.util.nv.NvReadable;
import io.continual.util.nv.impl.nvBaseReadable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;

public class nvReadableStack
extends nvBaseReadable {
    private final LinkedList<NvReadable> fStack = new LinkedList();

    public nvReadableStack push(NvReadable p) {
        this.fStack.addFirst(p);
        return this;
    }

    public nvReadableStack pushBelow(NvReadable below, NvReadable above) {
        int i = this.fStack.indexOf(above);
        if (i < 0) {
            this.push(below);
        } else {
            this.fStack.add(i + 1, below);
        }
        return this;
    }

    @Override
    public String getString(String key) throws NvReadable.MissingReqdSettingException {
        String result = null;
        boolean found = false;
        for (NvReadable p : this.fStack) {
            if (!p.hasValueFor(key)) continue;
            result = p.getString(key);
            found = true;
            break;
        }
        if (!found) {
            throw new NvReadable.MissingReqdSettingException(key);
        }
        return this.eval(result);
    }

    @Override
    public String[] getStrings(String key) throws NvReadable.MissingReqdSettingException {
        String[] result = null;
        boolean found = false;
        for (NvReadable p : this.fStack) {
            if (!p.hasValueFor(key)) continue;
            result = p.getStrings(key);
            found = true;
            break;
        }
        if (!found) {
            throw new NvReadable.MissingReqdSettingException(key);
        }
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.eval(result[i]);
            }
        }
        return result;
    }

    @Override
    public boolean hasValueFor(String key) {
        NvReadable p;
        boolean result = false;
        Iterator iterator = this.fStack.iterator();
        while (iterator.hasNext() && !(result = (p = (NvReadable)iterator.next()).hasValueFor(key))) {
        }
        return result;
    }

    @Override
    public void rescan() throws NvReadable.LoadException {
        for (NvReadable p : this.fStack) {
            p.rescan();
        }
    }

    @Override
    public int size() {
        return this.getAllKeys().size();
    }

    @Override
    public Collection<String> getAllKeys() {
        TreeSet<String> set = new TreeSet<String>();
        for (NvReadable r : this.fStack) {
            set.addAll(r.getAllKeys());
        }
        return set;
    }

    @Override
    public Map<String, String> getCopyAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.getAllKeys()) {
            String val = this.getString(key, null);
            if (val == null) continue;
            map.put(key, val);
        }
        return map;
    }
}

