/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.KeyboardFriendlyDecimalFormatSymbols;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

final class NumberParser {
    private final NumberFormat numberFormat;

    NumberParser(Locale locale) {
        this.numberFormat = DecimalFormat.getNumberInstance(locale);
        if (this.numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)this.numberFormat;
            decimalFormat.setParseBigDecimal(true);
            DecimalFormatSymbols symbols = KeyboardFriendlyDecimalFormatSymbols.getInstance(locale);
            decimalFormat.setDecimalFormatSymbols(symbols);
        }
    }

    double parseDouble(String s) {
        return this.parse(s).doubleValue();
    }

    float parseFloat(String s) {
        return this.parse(s).floatValue();
    }

    BigDecimal parseBigDecimal(String s) {
        if (this.numberFormat instanceof DecimalFormat) {
            return (BigDecimal)this.parse(s);
        }
        return new BigDecimal(s);
    }

    private Number parse(String s) {
        try {
            return this.numberFormat.parse(s);
        }
        catch (ParseException e) {
            throw new CucumberExpressionException("Failed to parse number", e);
        }
    }
}

