/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Pattern;

public class AmbiguousParameterTypeException
extends CucumberExpressionException {
    private final Pattern regexp;
    private final String parameterTypeRegexp;
    private final SortedSet<ParameterType<?>> parameterTypes;
    private final List<GeneratedExpression> generatedExpressions;

    public AmbiguousParameterTypeException(String parameterTypeRegexp, Pattern expressionRegexp, SortedSet<ParameterType<?>> parameterTypes, List<GeneratedExpression> generatedExpressions) {
        super(String.format("Your Regular Expression /%s/\nmatches multiple parameter types with regexp /%s/:\n   %s\n\nI couldn't decide which one to use. You have two options:\n\n1) Use a Cucumber Expression instead of a Regular Expression. Try one of these:\n   %s\n\n2) Make one of the parameter types preferential and continue to use a Regular Expression.\n\n", expressionRegexp.pattern(), parameterTypeRegexp, AmbiguousParameterTypeException.parameterTypeNames(parameterTypes), AmbiguousParameterTypeException.expressions(generatedExpressions)));
        this.regexp = expressionRegexp;
        this.parameterTypeRegexp = parameterTypeRegexp;
        this.parameterTypes = parameterTypes;
        this.generatedExpressions = generatedExpressions;
    }

    private static String parameterTypeNames(SortedSet<ParameterType<?>> parameterTypes) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterType parameterType : parameterTypes) {
            String s = "{" + parameterType.getName() + "}";
            parameterNames.add(s);
        }
        return AmbiguousParameterTypeException.join(parameterNames);
    }

    private static String expressions(List<GeneratedExpression> generatedExpressions) {
        ArrayList<String> sources = new ArrayList<String>();
        for (GeneratedExpression generatedExpression : generatedExpressions) {
            String source = generatedExpression.getSource();
            sources.add(source);
        }
        return AmbiguousParameterTypeException.join(sources);
    }

    private static String join(List<String> strings) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String element : strings) {
            if (first) {
                first = false;
            } else {
                builder.append("\n   ");
            }
            builder.append(element);
        }
        return builder.toString();
    }

    public Pattern getRegexp() {
        return this.regexp;
    }

    public String getParameterTypeRegexp() {
        return this.parameterTypeRegexp;
    }

    public SortedSet<ParameterType<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    public List<GeneratedExpression> getGeneratedExpressions() {
        return this.generatedExpressions;
    }
}

