/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin.utils.pretty;

import io.cucumber.gherkin.utils.GherkinDocumentHandlers;
import io.cucumber.gherkin.utils.pretty.Result;
import io.cucumber.gherkin.utils.pretty.Syntax;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Comment;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class PrettyHandlers
implements GherkinDocumentHandlers<Result> {
    private final List<Comment> comments;
    private final Syntax syntax;
    private int scenarioLevel = 1;

    public PrettyHandlers(List<Comment> comments, Syntax syntax) {
        this.comments = comments;
        this.syntax = syntax;
    }

    @Override
    public Result handleFeature(Feature feature, Result result) {
        result.append(PrettyHandlers.prettyLanguageHeader(feature.getLanguage()));
        return this.appendFeature(result, feature, this.syntax, 0);
    }

    @Override
    public Result handleBackground(Background background, Result result) {
        return this.appendBackground(result, background, this.syntax, this.scenarioLevel);
    }

    @Override
    public Result handleDataTable(DataTable dataTable, Result result) {
        int level = this.syntax == Syntax.markdown ? 1 : this.scenarioLevel + 2;
        return this.appendTableRows(result, dataTable.getRows(), this.syntax, level);
    }

    @Override
    public Result handleComment(Comment comment, Result result) {
        this.appendComment(0, result, comment);
        return result;
    }

    @Override
    public Result handleDocString(DocString docString, Result result) {
        String delimiter = this.makeDocStringDelimiter(this.syntax, docString);
        int level = this.syntax == Syntax.markdown ? 1 : this.scenarioLevel + 2;
        String indent = this.repeatString(level, "  ");
        String docStringContent = docString.getContent().replace("^", indent);
        if (this.syntax == Syntax.gherkin) {
            docStringContent = "\"\"\"".equals(docString.getDelimiter()) ? docStringContent.replace("\"", "\\\"\\\"\\\"") : docStringContent.replace("```", "\\`\\`\\`");
        }
        return result.append(indent).append(delimiter).append(docString.getMediaType().orElse("")).append("\n").append(docStringContent).append("\n").append(indent).append(delimiter).append("\n");
    }

    @Override
    public Result handleExamples(Examples examples, Result result) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        if (examples.getTableHeader().isPresent()) {
            tableRows.add((TableRow)examples.getTableHeader().get());
            tableRows.addAll(examples.getTableBody());
        }
        result = this.appendExamples(result, examples, this.syntax, this.scenarioLevel + 1);
        return this.appendTableRows(result, tableRows, this.syntax, this.scenarioLevel + 2);
    }

    @Override
    public Result handleRule(Rule rule, Result result) {
        this.scenarioLevel = 2;
        return this.appendRule(result, rule, this.syntax, 1);
    }

    @Override
    public Result handleScenario(Scenario scenario, Result result) {
        return this.appendScenario(result, scenario, this.syntax, this.scenarioLevel);
    }

    @Override
    public Result handleStep(Step step, Result result) {
        this.appendComments(step.getLocation(), result, this.comments, this.scenarioLevel + 1);
        return result.append(this.stepPrefix(this.scenarioLevel + 1, this.syntax)).append(step.getKeyword()).append(step.getText()).append("\n");
    }

    @Override
    public Result handleTableCell(TableCell tableCell, Result result) {
        return result;
    }

    @Override
    public Result handleTableRow(TableRow tableRow, Result result) {
        return result;
    }

    @Override
    public Result handleTag(Tag tag, Result result) {
        return result;
    }

    private static String prettyLanguageHeader(String language) {
        return "en".equals(language) ? "" : String.format("# language: %s\n", language);
    }

    private Result appendScenario(Result result, Scenario stepContainer, Syntax syntax, int level) {
        List tags = stepContainer.getTags() != null ? stepContainer.getTags() : Collections.emptyList();
        int stepCount = stepContainer.getSteps() != null ? stepContainer.getSteps().size() : 0;
        String description = this.prettyDescription(stepContainer.getDescription(), syntax);
        result.append(level == 0 ? "" : "\n");
        this.appendComments(stepContainer.getLocation(), result, this.comments, level);
        this.appendTags(result, tags, syntax, level, this.comments);
        return result.append(this.keywordPrefix(level, syntax)).append(stepContainer.getKeyword()).append(": ").append(stepContainer.getName()).append("\n").append(description).append(!"".equals(description.trim()) && stepCount > 0 ? "\n" : "");
    }

    private Result appendFeature(Result result, Feature stepContainer, Syntax syntax, int level) {
        List tags = stepContainer.getTags() != null ? stepContainer.getTags() : Collections.emptyList();
        this.appendComments(stepContainer.getLocation(), result, this.comments, level);
        this.appendTags(result, tags, syntax, level, this.comments);
        return result.append(level == 0 ? "" : "\n").append(this.keywordPrefix(level, syntax)).append(stepContainer.getKeyword()).append(": ").append(stepContainer.getName()).append("\n").append(this.prettyDescription(stepContainer.getDescription(), syntax));
    }

    private Result appendRule(Result result, Rule stepContainer, Syntax syntax, int level) {
        List tags = stepContainer.getTags() != null ? stepContainer.getTags() : Collections.emptyList();
        String description = this.prettyDescription(stepContainer.getDescription(), syntax);
        this.appendComments(stepContainer.getLocation(), result, this.comments, level);
        result.append(level == 0 ? "" : "\n");
        this.appendTags(result, tags, syntax, level, this.comments);
        return result.append(this.keywordPrefix(level, syntax)).append(stepContainer.getKeyword()).append(": ").append(stepContainer.getName()).append("\n").append(description);
    }

    private Result appendExamples(Result result, Examples stepContainer, Syntax syntax, int level) {
        List tags = stepContainer.getTags() != null ? stepContainer.getTags() : Collections.emptyList();
        String description = this.prettyDescription(stepContainer.getDescription(), syntax);
        result.append(level == 0 ? "" : "\n");
        this.appendComments(stepContainer.getLocation(), result, this.comments, level);
        this.appendTags(result, tags, syntax, level, this.comments);
        return result.append(this.keywordPrefix(level, syntax)).append(stepContainer.getKeyword()).append(stepContainer.getName() != null && !stepContainer.getName().isEmpty() ? ": " : ":").append(stepContainer.getName()).append("\n").append(description);
    }

    private Result appendBackground(Result result, Background stepContainer, Syntax syntax, int level) {
        int stepCount = stepContainer.getSteps() != null ? stepContainer.getSteps().size() : 0;
        String description = this.prettyDescription(stepContainer.getDescription(), syntax);
        this.appendComments(stepContainer.getLocation(), result, this.comments, level);
        return result.append(level == 0 ? "" : "\n").append(this.keywordPrefix(level, syntax)).append(stepContainer.getKeyword()).append(": ").append(stepContainer.getName()).append("\n").append(description).append(!"".equals(description.trim()) && stepCount > 0 ? "\n" : "");
    }

    private String prettyDescription(String description, Syntax syntax) {
        if (description == null || "".equals(description.trim())) {
            return "";
        }
        if (syntax == Syntax.gherkin) {
            return description + "\n";
        }
        return description.trim() + "\n";
    }

    private Result appendTags(Result result, List<Tag> tags, Syntax syntax, int level, List<Comment> comments) {
        if (tags.isEmpty()) {
            return result;
        }
        String prefix = syntax == Syntax.gherkin ? this.repeatString(level, "  ") : "";
        String tagQuote = syntax == Syntax.gherkin ? "" : "`";
        this.appendComments(tags.get(0).getLocation(), result, comments, level);
        return result.append(prefix).append(tags.stream().map(tag -> tagQuote + tag.getName() + tagQuote).collect(Collectors.joining(" "))).append("\n");
    }

    private String keywordPrefix(int level, Syntax syntax) {
        if (syntax == Syntax.markdown) {
            return this.repeatString(level + 1, "#") + " ";
        }
        return this.repeatString(level, "  ");
    }

    private String stepPrefix(int level, Syntax syntax) {
        if (syntax == Syntax.markdown) {
            return "* ";
        }
        return this.repeatString(level, "  ");
    }

    private String repeatString(int numRepeats, String stringToRepeat) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < numRepeats; ++i) {
            res.append(stringToRepeat);
        }
        return res.toString();
    }

    private String makeDocStringDelimiter(Syntax syntax, DocString docString) {
        Matcher match;
        if (syntax == Syntax.gherkin) {
            return docString.getDelimiter().substring(0, 3);
        }
        Pattern threeOrMoreBackticksPattern = Pattern.compile("```+");
        int maxContentBackTickCount = 2;
        do {
            if (!(match = threeOrMoreBackticksPattern.matcher(docString.getContent())).matches()) continue;
            maxContentBackTickCount = Math.max(maxContentBackTickCount, match.group(1).length());
        } while (match.matches());
        return this.repeatString(maxContentBackTickCount + 1, "`");
    }

    private Result appendTableRows(Result result, List<TableRow> tableRows, Syntax syntax, int level) {
        if (tableRows.isEmpty()) {
            return result;
        }
        int[] maxWidths = new int[tableRows.get(0).getCells().size()];
        Arrays.fill(maxWidths, 0);
        for (TableRow tableRow : tableRows) {
            for (int j = 0; j < tableRow.getCells().size(); ++j) {
                TableCell tableCell = (TableCell)tableRow.getCells().get(j);
                maxWidths[j] = Math.max(maxWidths[j], this.escapeCell(tableCell.getValue()).length());
            }
        }
        int n = 0;
        for (TableRow row : tableRows) {
            this.appendTableRow(result, row, level, maxWidths, syntax, this.comments);
            if (n == 0 && syntax == Syntax.markdown) {
                ArrayList<TableCell> mappedCells = new ArrayList<TableCell>();
                for (int j = 0; j < row.getCells().size(); ++j) {
                    mappedCells.add(new TableCell(((TableCell)row.getCells().get(j)).getLocation(), this.repeatString(maxWidths[j], "-")));
                }
                TableRow separatorRow = new TableRow(row.getLocation(), mappedCells, row.getId() + "-separator");
                this.appendTableRow(result, separatorRow, level, maxWidths, syntax, this.comments);
            }
            ++n;
        }
        return result;
    }

    private List<Comment> popComments(Location currentLocation, List<Comment> comments) {
        ArrayList<Comment> res = new ArrayList<Comment>();
        Iterator<Comment> iter = comments.iterator();
        while (iter.hasNext()) {
            Comment comment = iter.next();
            if (currentLocation.getLine() <= comment.getLocation().getLine()) continue;
            res.add(comment);
            iter.remove();
        }
        return res;
    }

    private Result appendTableRow(Result result, TableRow row, int level, int[] maxWidths, Syntax syntax, List<Comment> comments) {
        int actualLevel = syntax == Syntax.markdown ? 1 : level;
        this.appendComments(row.getLocation(), result, comments, actualLevel);
        result.append(this.repeatString(actualLevel, "  ")).append("| ");
        for (int j = 0; j < row.getCells().size(); ++j) {
            if (j > 0) {
                result.append(" | ");
            }
            TableCell tableCell = (TableCell)row.getCells().get(j);
            String escapedCellValue = this.escapeCell(tableCell.getValue());
            int spaceCount = maxWidths[j] - escapedCellValue.length();
            String spaces = this.repeatString(spaceCount, " ");
            result.append(escapedCellValue + spaces);
        }
        return result.append(" |\n");
    }

    private void appendComments(Location location, Result result, List<Comment> comments, int actualLevel) {
        for (Comment nextComment : this.popComments(location, comments)) {
            this.appendComment(actualLevel, result, nextComment);
        }
    }

    private void appendComment(int actualLevel, Result result, Comment nextComment) {
        if (nextComment.getText() == null || nextComment.getText().trim().isEmpty()) {
            return;
        }
        String comment = nextComment.getText().trim();
        if (!comment.isEmpty()) {
            result.append(this.repeatString(actualLevel, "  ")).append("# " + comment.substring(1).trim()).append("\n");
        }
    }

    private String escapeCell(String s) {
        StringBuilder e = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    e.append("\\\\");
                    continue block5;
                }
                case '\n': {
                    e.append("\\n");
                    continue block5;
                }
                case '|': {
                    e.append("\\|");
                    continue block5;
                }
                default: {
                    e.append(c);
                }
            }
        }
        return e.toString();
    }
}

