//      This code was generated by Berp (http://https://github.com/gasparnagy/berp/).
//
//      Changes to this file may cause incorrect behavior and will be lost if
//      the code is regenerated.


package io.cucumber.gherkin;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

import static java.util.Arrays.asList;

class Parser<T> {
    enum TokenType {
        None,
        EOF,
        Empty,
        Comment,
        TagLine,
        FeatureLine,
        RuleLine,
        BackgroundLine,
        ScenarioLine,
        ExamplesLine,
        StepLine,
        DocStringSeparator,
        TableRow,
        Language,
        Other,
        ;
    }

    enum RuleType {
        None,
        _EOF, // #EOF
        _Empty, // #Empty
        _Comment, // #Comment
        _TagLine, // #TagLine
        _FeatureLine, // #FeatureLine
        _RuleLine, // #RuleLine
        _BackgroundLine, // #BackgroundLine
        _ScenarioLine, // #ScenarioLine
        _ExamplesLine, // #ExamplesLine
        _StepLine, // #StepLine
        _DocStringSeparator, // #DocStringSeparator
        _TableRow, // #TableRow
        _Language, // #Language
        _Other, // #Other
        GherkinDocument, // GherkinDocument! := Feature?
        Feature, // Feature! := FeatureHeader Background? ScenarioDefinition* Rule*
        FeatureHeader, // FeatureHeader! := #Language? Tags? #FeatureLine DescriptionHelper
        Rule, // Rule! := RuleHeader Background? ScenarioDefinition*
        RuleHeader, // RuleHeader! := Tags? #RuleLine DescriptionHelper
        Background, // Background! := #BackgroundLine DescriptionHelper Step*
        ScenarioDefinition, // ScenarioDefinition! [#Empty|#Comment|#TagLine->#ScenarioLine] := Tags? Scenario
        Scenario, // Scenario! := #ScenarioLine DescriptionHelper Step* ExamplesDefinition*
        ExamplesDefinition, // ExamplesDefinition! [#Empty|#Comment|#TagLine->#ExamplesLine] := Tags? Examples
        Examples, // Examples! := #ExamplesLine DescriptionHelper ExamplesTable?
        ExamplesTable, // ExamplesTable! := #TableRow #TableRow*
        Step, // Step! := #StepLine StepArg?
        StepArg, // StepArg := (DataTable | DocString)
        DataTable, // DataTable! := #TableRow+
        DocString, // DocString! := #DocStringSeparator #Other* #DocStringSeparator
        Tags, // Tags! := #TagLine+
        DescriptionHelper, // DescriptionHelper := #Empty* Description?
        Description, // Description! := (#Other | #Comment)+
        ;

        static RuleType cast(TokenType tokenType) {
            return RuleType.values()[tokenType.ordinal()];
        }
    }

    private final Builder<T> builder;

    static class ParserContext {
        final ITokenScanner tokenScanner;
        final ITokenMatcher tokenMatcher;
        final Queue<Token> tokenQueue;
        final List<ParserException> errors;

        ParserContext(ITokenScanner tokenScanner, ITokenMatcher tokenMatcher, Queue<Token> tokenQueue, List<ParserException> errors) {
            this.tokenScanner = tokenScanner;
            this.tokenMatcher = tokenMatcher;
            this.tokenQueue = tokenQueue;
            this.errors = errors;
        }
    }

    Parser(Builder<T> builder) {
        this.builder = builder;
    }

    T parse(String source, String uri) {
        return parse(new StringReader(source), uri);
    }

    T parse(Reader source, String uri) {
        return parse(new TokenScanner(source), uri);
    }

    T parse(ITokenScanner tokenScanner, String uri) {
        return parse(tokenScanner, new TokenMatcher(), uri);
    }

    T parse(String source, ITokenMatcher tokenMatcher, String uri) {
        return parse(new StringReader(source), tokenMatcher, uri);
    }

    T parse(Reader source, ITokenMatcher tokenMatcher, String uri) {
        return parse(new TokenScanner(source), tokenMatcher, uri);
    }

    T parse(ITokenScanner tokenScanner, ITokenMatcher tokenMatcher, String uri) {
        builder.reset(uri);
        tokenMatcher.reset();

        ParserContext context = new ParserContext(
                tokenScanner,
                tokenMatcher,
                new LinkedList<>(),
                new ArrayList<>()
        );

        startRule(context, RuleType.GherkinDocument);
        int state = 0;
        Token token;
        do {
            token = readToken(context);
            state = matchToken(state, token, context);
        } while (!token.isEOF());

        endRule(context, RuleType.GherkinDocument);

        if (context.errors.size() > 0) {
            throw new ParserException.CompositeParserException(context.errors);
        }

        return builder.getResult();
    }

    private void addError(ParserContext context, ParserException error) {
        String newErrorMessage = error.getMessage();
        for (ParserException e : context.errors) {
            if (e.getMessage().equals(newErrorMessage)) {
                return;
            }
        }
        context.errors.add(error);
        if (context.errors.size() > 10)
            throw new ParserException.CompositeParserException(context.errors);
    }

    private <V> V handleAstError(ParserContext context, final Func<V> action) {
        return handleExternalError(context, action, null);
    }

    private <V> V handleExternalError(ParserContext context, Func<V> action, V defaultValue) {
        try {
            return action.call();
        } catch (ParserException.CompositeParserException compositeParserException) {
            for (ParserException error : compositeParserException.errors) {
                addError(context, error);
            }
        } catch (ParserException error) {
            addError(context, error);
        }
        return defaultValue;
    }

    private void build(final ParserContext context, final Token token) {
        handleAstError(context, new Func<Void>() {
            public Void call() {
                builder.build(token);
                return null;
            }
        });
    }

    private void startRule(final ParserContext context, final RuleType ruleType) {
        handleAstError(context, new Func<Void>() {
            public Void call() {
                builder.startRule(ruleType);
                return null;
            }
        });
    }

    private void endRule(final ParserContext context, final RuleType ruleType) {
        handleAstError(context, new Func<Void>() {
            public Void call() {
                builder.endRule(ruleType);
                return null;
            }
        });
    }

    private Token readToken(ParserContext context) {
        return context.tokenQueue.size() > 0 ? context.tokenQueue.remove() : context.tokenScanner.read();
    }


    private boolean match_EOF(final ParserContext context, final Token token) {
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_EOF(token);
            }
        }, false);
    }
    private boolean match_Empty(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_Empty(token);
            }
        }, false);
    }
    private boolean match_Comment(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_Comment(token);
            }
        }, false);
    }
    private boolean match_TagLine(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_TagLine(token);
            }
        }, false);
    }
    private boolean match_FeatureLine(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_FeatureLine(token);
            }
        }, false);
    }
    private boolean match_RuleLine(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_RuleLine(token);
            }
        }, false);
    }
    private boolean match_BackgroundLine(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_BackgroundLine(token);
            }
        }, false);
    }
    private boolean match_ScenarioLine(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_ScenarioLine(token);
            }
        }, false);
    }
    private boolean match_ExamplesLine(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_ExamplesLine(token);
            }
        }, false);
    }
    private boolean match_StepLine(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_StepLine(token);
            }
        }, false);
    }
    private boolean match_DocStringSeparator(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_DocStringSeparator(token);
            }
        }, false);
    }
    private boolean match_TableRow(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_TableRow(token);
            }
        }, false);
    }
    private boolean match_Language(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_Language(token);
            }
        }, false);
    }
    private boolean match_Other(final ParserContext context, final Token token) {
        if (token.isEOF()) return false;
        return handleExternalError(context, new Func<Boolean>() {
            public Boolean call() {
                return context.tokenMatcher.match_Other(token);
            }
        }, false);
    }
    private int matchToken(int state, Token token, ParserContext context) {
        int newState;
        switch (state) {
            case 0:
                newState = matchTokenAt_0(token, context);
                break;
            case 1:
                newState = matchTokenAt_1(token, context);
                break;
            case 2:
                newState = matchTokenAt_2(token, context);
                break;
            case 3:
                newState = matchTokenAt_3(token, context);
                break;
            case 4:
                newState = matchTokenAt_4(token, context);
                break;
            case 5:
                newState = matchTokenAt_5(token, context);
                break;
            case 6:
                newState = matchTokenAt_6(token, context);
                break;
            case 7:
                newState = matchTokenAt_7(token, context);
                break;
            case 8:
                newState = matchTokenAt_8(token, context);
                break;
            case 9:
                newState = matchTokenAt_9(token, context);
                break;
            case 10:
                newState = matchTokenAt_10(token, context);
                break;
            case 11:
                newState = matchTokenAt_11(token, context);
                break;
            case 12:
                newState = matchTokenAt_12(token, context);
                break;
            case 13:
                newState = matchTokenAt_13(token, context);
                break;
            case 14:
                newState = matchTokenAt_14(token, context);
                break;
            case 15:
                newState = matchTokenAt_15(token, context);
                break;
            case 16:
                newState = matchTokenAt_16(token, context);
                break;
            case 17:
                newState = matchTokenAt_17(token, context);
                break;
            case 18:
                newState = matchTokenAt_18(token, context);
                break;
            case 19:
                newState = matchTokenAt_19(token, context);
                break;
            case 20:
                newState = matchTokenAt_20(token, context);
                break;
            case 21:
                newState = matchTokenAt_21(token, context);
                break;
            case 22:
                newState = matchTokenAt_22(token, context);
                break;
            case 23:
                newState = matchTokenAt_23(token, context);
                break;
            case 24:
                newState = matchTokenAt_24(token, context);
                break;
            case 25:
                newState = matchTokenAt_25(token, context);
                break;
            case 26:
                newState = matchTokenAt_26(token, context);
                break;
            case 27:
                newState = matchTokenAt_27(token, context);
                break;
            case 28:
                newState = matchTokenAt_28(token, context);
                break;
            case 29:
                newState = matchTokenAt_29(token, context);
                break;
            case 30:
                newState = matchTokenAt_30(token, context);
                break;
            case 31:
                newState = matchTokenAt_31(token, context);
                break;
            case 32:
                newState = matchTokenAt_32(token, context);
                break;
            case 33:
                newState = matchTokenAt_33(token, context);
                break;
            case 35:
                newState = matchTokenAt_35(token, context);
                break;
            case 36:
                newState = matchTokenAt_36(token, context);
                break;
            case 37:
                newState = matchTokenAt_37(token, context);
                break;
            case 38:
                newState = matchTokenAt_38(token, context);
                break;
            case 39:
                newState = matchTokenAt_39(token, context);
                break;
            case 40:
                newState = matchTokenAt_40(token, context);
                break;
            case 41:
                newState = matchTokenAt_41(token, context);
                break;
            case 42:
                newState = matchTokenAt_42(token, context);
                break;
            default:
                throw new IllegalStateException("Unknown state: " + state);
        }
        return newState;
    }


    // Start
    private int matchTokenAt_0(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                build(context, token);
            return 34;
        }
        if (match_Language(context, token))
        {
                startRule(context, RuleType.Feature);
                startRule(context, RuleType.FeatureHeader);
                build(context, token);
            return 1;
        }
        if (match_TagLine(context, token))
        {
                startRule(context, RuleType.Feature);
                startRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 2;
        }
        if (match_FeatureLine(context, token))
        {
                startRule(context, RuleType.Feature);
                startRule(context, RuleType.FeatureHeader);
                build(context, token);
            return 3;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 0;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 0;
        }

        final String stateComment = "State: 0 - Start";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Language", "#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 0;
    }

    // GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0
    private int matchTokenAt_1(Token token, ParserContext context) {
        if (match_TagLine(context, token))
        {
                startRule(context, RuleType.Tags);
                build(context, token);
            return 2;
        }
        if (match_FeatureLine(context, token))
        {
                build(context, token);
            return 3;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 1;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 1;
        }

        final String stateComment = "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0";
        token.detach();
        List<String> expectedTokens = asList("#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 1;
    }

    // GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0
    private int matchTokenAt_2(Token token, ParserContext context) {
        if (match_TagLine(context, token))
        {
                build(context, token);
            return 2;
        }
        if (match_FeatureLine(context, token))
        {
                endRule(context, RuleType.Tags);
                build(context, token);
            return 3;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 2;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 2;
        }

        final String stateComment = "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = asList("#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 2;
    }

    // GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0
    private int matchTokenAt_3(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.FeatureHeader);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 3;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 4;
        }
        if (match_BackgroundLine(context, token))
        {
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.Background);
                build(context, token);
            return 5;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 4;
        }

        final String stateComment = "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 3;
    }

    // GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_4(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.FeatureHeader);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 4;
        }
        if (match_BackgroundLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.Background);
                build(context, token);
            return 5;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.FeatureHeader);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 4;
        }

        final String stateComment = "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 4;
    }

    // GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0
    private int matchTokenAt_5(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 5;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 6;
        }
        if (match_StepLine(context, token))
        {
                startRule(context, RuleType.Step);
                build(context, token);
            return 7;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 6;
        }

        final String stateComment = "State: 5 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 5;
    }

    // GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_6(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 6;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.Step);
                build(context, token);
            return 7;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 6;
        }

        final String stateComment = "State: 6 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 6;
    }

    // GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0
    private int matchTokenAt_7(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                startRule(context, RuleType.DataTable);
                build(context, token);
            return 8;
        }
        if (match_DocStringSeparator(context, token))
        {
                startRule(context, RuleType.DocString);
                build(context, token);
            return 41;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 7;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 7;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 7;
        }

        final String stateComment = "State: 7 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 7;
    }

    // GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0
    private int matchTokenAt_8(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                build(context, token);
            return 8;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 7;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 8;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 8;
        }

        final String stateComment = "State: 8 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 8;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0
    private int matchTokenAt_9(Token token, ParserContext context) {
        if (match_TagLine(context, token))
        {
                build(context, token);
            return 9;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Tags);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 9;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 9;
        }

        final String stateComment = "State: 9 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = asList("#TagLine", "#ScenarioLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 9;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0
    private int matchTokenAt_10(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 10;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 11;
        }
        if (match_StepLine(context, token))
        {
                startRule(context, RuleType.Step);
                build(context, token);
            return 12;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 11;
        }

        final String stateComment = "State: 10 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 10;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_11(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 11;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.Step);
                build(context, token);
            return 12;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 11;
        }

        final String stateComment = "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 11;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0
    private int matchTokenAt_12(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                startRule(context, RuleType.DataTable);
                build(context, token);
            return 13;
        }
        if (match_DocStringSeparator(context, token))
        {
                startRule(context, RuleType.DocString);
                build(context, token);
            return 39;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 12;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 12;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 12;
        }

        final String stateComment = "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 12;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0
    private int matchTokenAt_13(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                build(context, token);
            return 13;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 12;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 13;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 13;
        }

        final String stateComment = "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 13;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0
    private int matchTokenAt_14(Token token, ParserContext context) {
        if (match_TagLine(context, token))
        {
                build(context, token);
            return 14;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Tags);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 14;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 14;
        }

        final String stateComment = "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = asList("#TagLine", "#ExamplesLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 14;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0
    private int matchTokenAt_15(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 15;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 16;
        }
        if (match_TableRow(context, token))
        {
                startRule(context, RuleType.ExamplesTable);
                build(context, token);
            return 17;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 16;
        }

        final String stateComment = "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 15;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_16(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 16;
        }
        if (match_TableRow(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.ExamplesTable);
                build(context, token);
            return 17;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 16;
        }

        final String stateComment = "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 16;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0
    private int matchTokenAt_17(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                build(context, token);
            return 17;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 17;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 17;
        }

        final String stateComment = "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 17;
    }

    // GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0
    private int matchTokenAt_18(Token token, ParserContext context) {
        if (match_TagLine(context, token))
        {
                build(context, token);
            return 18;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Tags);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 18;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 18;
        }

        final String stateComment = "State: 18 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = asList("#TagLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 18;
    }

    // GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0
    private int matchTokenAt_19(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.RuleHeader);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 20;
        }
        if (match_BackgroundLine(context, token))
        {
                endRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Background);
                build(context, token);
            return 21;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.RuleHeader);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.RuleHeader);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 20;
        }

        final String stateComment = "State: 19 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 19;
    }

    // GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_20(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.RuleHeader);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 20;
        }
        if (match_BackgroundLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Background);
                build(context, token);
            return 21;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.RuleHeader);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.RuleHeader);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 20;
        }

        final String stateComment = "State: 20 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 20;
    }

    // GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0
    private int matchTokenAt_21(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 21;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 22;
        }
        if (match_StepLine(context, token))
        {
                startRule(context, RuleType.Step);
                build(context, token);
            return 23;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 22;
        }

        final String stateComment = "State: 21 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 21;
    }

    // GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_22(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 22;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.Step);
                build(context, token);
            return 23;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 22;
        }

        final String stateComment = "State: 22 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 22;
    }

    // GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0
    private int matchTokenAt_23(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                startRule(context, RuleType.DataTable);
                build(context, token);
            return 24;
        }
        if (match_DocStringSeparator(context, token))
        {
                startRule(context, RuleType.DocString);
                build(context, token);
            return 37;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 23;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 23;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 23;
        }

        final String stateComment = "State: 23 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 23;
    }

    // GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0
    private int matchTokenAt_24(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                build(context, token);
            return 24;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 23;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 24;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 24;
        }

        final String stateComment = "State: 24 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 24;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0
    private int matchTokenAt_25(Token token, ParserContext context) {
        if (match_TagLine(context, token))
        {
                build(context, token);
            return 25;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Tags);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 25;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 25;
        }

        final String stateComment = "State: 25 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = asList("#TagLine", "#ScenarioLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 25;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0
    private int matchTokenAt_26(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 26;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 27;
        }
        if (match_StepLine(context, token))
        {
                startRule(context, RuleType.Step);
                build(context, token);
            return 28;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 27;
        }

        final String stateComment = "State: 26 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 26;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_27(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 27;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.Step);
                build(context, token);
            return 28;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 27;
        }

        final String stateComment = "State: 27 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 27;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0
    private int matchTokenAt_28(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                startRule(context, RuleType.DataTable);
                build(context, token);
            return 29;
        }
        if (match_DocStringSeparator(context, token))
        {
                startRule(context, RuleType.DocString);
                build(context, token);
            return 35;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 28;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 28;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 28;
        }

        final String stateComment = "State: 28 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 28;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0
    private int matchTokenAt_29(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                build(context, token);
            return 29;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 28;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DataTable);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 29;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 29;
        }

        final String stateComment = "State: 29 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 29;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0
    private int matchTokenAt_30(Token token, ParserContext context) {
        if (match_TagLine(context, token))
        {
                build(context, token);
            return 30;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Tags);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 30;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 30;
        }

        final String stateComment = "State: 30 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = asList("#TagLine", "#ExamplesLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 30;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0
    private int matchTokenAt_31(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 31;
        }
        if (match_Comment(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 32;
        }
        if (match_TableRow(context, token))
        {
                startRule(context, RuleType.ExamplesTable);
                build(context, token);
            return 33;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                startRule(context, RuleType.Description);
                build(context, token);
            return 32;
        }

        final String stateComment = "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 31;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0
    private int matchTokenAt_32(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 32;
        }
        if (match_TableRow(context, token))
        {
                endRule(context, RuleType.Description);
                startRule(context, RuleType.ExamplesTable);
                build(context, token);
            return 33;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.Description);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 32;
        }

        final String stateComment = "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>__alt1:0>#Other:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 32;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0
    private int matchTokenAt_33(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_TableRow(context, token))
        {
                build(context, token);
            return 33;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.ExamplesTable);
                endRule(context, RuleType.Examples);
                endRule(context, RuleType.ExamplesDefinition);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 33;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 33;
        }

        final String stateComment = "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 33;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0
    private int matchTokenAt_35(Token token, ParserContext context) {
        if (match_DocStringSeparator(context, token))
        {
                build(context, token);
            return 36;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 35;
        }

        final String stateComment = "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 35;
    }

    // GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0
    private int matchTokenAt_36(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 28;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 30;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 31;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 36;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 36;
        }

        final String stateComment = "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 36;
    }

    // GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0
    private int matchTokenAt_37(Token token, ParserContext context) {
        if (match_DocStringSeparator(context, token))
        {
                build(context, token);
            return 38;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 37;
        }

        final String stateComment = "State: 37 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 37;
    }

    // GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0
    private int matchTokenAt_38(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 23;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 25;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 26;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Rule);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 38;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 38;
        }

        final String stateComment = "State: 38 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 38;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0
    private int matchTokenAt_39(Token token, ParserContext context) {
        if (match_DocStringSeparator(context, token))
        {
                build(context, token);
            return 40;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 39;
        }

        final String stateComment = "State: 39 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 39;
    }

    // GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0
    private int matchTokenAt_40(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 12;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_1(context, token))
            {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 14;
            }
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ExamplesLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.ExamplesDefinition);
                startRule(context, RuleType.Examples);
                build(context, token);
            return 15;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Scenario);
                endRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 40;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 40;
        }

        final String stateComment = "State: 40 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 40;
    }

    // GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0
    private int matchTokenAt_41(Token token, ParserContext context) {
        if (match_DocStringSeparator(context, token))
        {
                build(context, token);
            return 42;
        }
        if (match_Other(context, token))
        {
                build(context, token);
            return 41;
        }

        final String stateComment = "State: 41 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 41;
    }

    // GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0
    private int matchTokenAt_42(Token token, ParserContext context) {
        if (match_EOF(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                endRule(context, RuleType.Feature);
                build(context, token);
            return 34;
        }
        if (match_StepLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                startRule(context, RuleType.Step);
                build(context, token);
            return 7;
        }
        if (match_TagLine(context, token))
        {
            if (lookahead_0(context, token))
            {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 9;
            }
        }
        if (match_TagLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                startRule(context, RuleType.Tags);
                build(context, token);
            return 18;
        }
        if (match_ScenarioLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.ScenarioDefinition);
                startRule(context, RuleType.Scenario);
                build(context, token);
            return 10;
        }
        if (match_RuleLine(context, token))
        {
                endRule(context, RuleType.DocString);
                endRule(context, RuleType.Step);
                endRule(context, RuleType.Background);
                startRule(context, RuleType.Rule);
                startRule(context, RuleType.RuleHeader);
                build(context, token);
            return 19;
        }
        if (match_Comment(context, token))
        {
                build(context, token);
            return 42;
        }
        if (match_Empty(context, token))
        {
                build(context, token);
            return 42;
        }

        final String stateComment = "State: 42 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = asList("#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF()
                ? new ParserException.UnexpectedEOFException(token, expectedTokens, stateComment)
                : new ParserException.UnexpectedTokenException(token, expectedTokens, stateComment);

        addError(context, error);
        return 42;
    }


    private boolean lookahead_0(ParserContext context, Token currentToken) {
        currentToken.detach();
        Token token;
        Queue<Token> queue = new ArrayDeque<Token>();
        boolean match = false;
        do
        {
            token = readToken(context);
            token.detach();
            queue.add(token);

            if (false
                || match_ScenarioLine(context, token)
)
            {
                match = true;
                break;
            }
        } while (false
            || match_Empty(context, token)
            || match_Comment(context, token)
            || match_TagLine(context, token)
);

        context.tokenQueue.addAll(queue);

        return match;
    }

    private boolean lookahead_1(ParserContext context, Token currentToken) {
        currentToken.detach();
        Token token;
        Queue<Token> queue = new ArrayDeque<Token>();
        boolean match = false;
        do
        {
            token = readToken(context);
            token.detach();
            queue.add(token);

            if (false
                || match_ExamplesLine(context, token)
)
            {
                match = true;
                break;
            }
        } while (false
            || match_Empty(context, token)
            || match_Comment(context, token)
            || match_TagLine(context, token)
);

        context.tokenQueue.addAll(queue);

        return match;
    }

    interface Builder<T> {
        void build(Token token);
        void startRule(RuleType ruleType);
        void endRule(RuleType ruleType);
        T getResult();
        void reset(String uri);
    }

    interface ITokenScanner {
        Token read();
    }

    interface ITokenMatcher {
        boolean match_EOF(Token token);
        boolean match_Empty(Token token);
        boolean match_Comment(Token token);
        boolean match_TagLine(Token token);
        boolean match_FeatureLine(Token token);
        boolean match_RuleLine(Token token);
        boolean match_BackgroundLine(Token token);
        boolean match_ScenarioLine(Token token);
        boolean match_ExamplesLine(Token token);
        boolean match_StepLine(Token token);
        boolean match_DocStringSeparator(Token token);
        boolean match_TableRow(Token token);
        boolean match_Language(Token token);
        boolean match_Other(Token token);
        void reset();
    }
}
