/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.decorator.AbstractAddProbeDecorator;
import io.fabric8.kubernetes.api.model.ContainerFluent;

@Description(value="Add a liveness probe to all containers.")
public class AddLivenessProbeDecorator
extends AbstractAddProbeDecorator {
    private final Logger LOGGER = LoggerFactory.getLogger();

    public AddLivenessProbeDecorator(String containerName, Probe probe) {
        super(containerName, probe);
    }

    public AddLivenessProbeDecorator(String deploymentName, String containerName, Probe probe) {
        super(deploymentName, containerName, probe);
    }

    @Override
    protected void doCreateProbe(ContainerFluent<?> container, AbstractAddProbeDecorator.Actions actions) {
        if (this.probe.getSuccessThreshold() != null && this.probe.getSuccessThreshold() != 1) {
            this.LOGGER.warning("Invalid success threshold value for liveness probe. It must be 1, found: " + this.probe.getSuccessThreshold() + "! The correct value of 1 will be forced!");
        }
        ((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)((ContainerFluent.LivenessProbeNested)container.withNewLivenessProbe().withExec(actions.execAction)).withHttpGet(actions.httpGetAction)).withTcpSocket(actions.tcpSocketAction)).withGrpc(actions.grpcAction)).withInitialDelaySeconds(this.probe.getInitialDelaySeconds())).withPeriodSeconds(this.probe.getPeriodSeconds())).withTimeoutSeconds(this.probe.getTimeoutSeconds())).withSuccessThreshold(Integer.valueOf(1))).withFailureThreshold(this.probe.getFailureThreshold())).endLivenessProbe();
    }

    @Override
    protected String getProbeName() {
        return "livenessProbe";
    }
}

