/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.server.ServerRuntimeInfo;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableServerRuntimeInfo
implements ServerRuntimeInfo {
    private final ImmutableList<ServerRuntimeInfo.Address> localAddresses;
    private final ImmutableList<ServerRuntimeInfo.Address> localAdminAddresses;

    private ImmutableServerRuntimeInfo(ImmutableList<ServerRuntimeInfo.Address> localAddresses, ImmutableList<ServerRuntimeInfo.Address> localAdminAddresses) {
        this.localAddresses = localAddresses;
        this.localAdminAddresses = localAdminAddresses;
    }

    @JsonProperty(value="local_addresses")
    public ImmutableList<ServerRuntimeInfo.Address> localAddresses() {
        return this.localAddresses;
    }

    @JsonProperty(value="local_admin_addresses")
    public ImmutableList<ServerRuntimeInfo.Address> localAdminAddresses() {
        return this.localAdminAddresses;
    }

    public final ImmutableServerRuntimeInfo withLocalAddresses(ServerRuntimeInfo.Address ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableServerRuntimeInfo((ImmutableList<ServerRuntimeInfo.Address>)newValue, this.localAdminAddresses);
    }

    public final ImmutableServerRuntimeInfo withLocalAddresses(Iterable<? extends ServerRuntimeInfo.Address> elements) {
        if (this.localAddresses == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableServerRuntimeInfo((ImmutableList<ServerRuntimeInfo.Address>)newValue, this.localAdminAddresses);
    }

    public final ImmutableServerRuntimeInfo withLocalAdminAddresses(ServerRuntimeInfo.Address ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableServerRuntimeInfo(this.localAddresses, (ImmutableList<ServerRuntimeInfo.Address>)newValue);
    }

    public final ImmutableServerRuntimeInfo withLocalAdminAddresses(Iterable<? extends ServerRuntimeInfo.Address> elements) {
        if (this.localAdminAddresses == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableServerRuntimeInfo(this.localAddresses, (ImmutableList<ServerRuntimeInfo.Address>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerRuntimeInfo && this.equalTo((ImmutableServerRuntimeInfo)another);
    }

    private boolean equalTo(ImmutableServerRuntimeInfo another) {
        return this.localAddresses.equals(another.localAddresses) && this.localAdminAddresses.equals(another.localAdminAddresses);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.localAddresses.hashCode();
        h = h * 17 + this.localAdminAddresses.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerRuntimeInfo").omitNullValues().add("localAddresses", this.localAddresses).add("localAdminAddresses", this.localAdminAddresses).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServerRuntimeInfo fromJson(Json json) {
        Builder builder = ImmutableServerRuntimeInfo.builder();
        if (json.localAddresses != null) {
            builder.addAllLocalAddresses(json.localAddresses);
        }
        if (json.localAdminAddresses != null) {
            builder.addAllLocalAdminAddresses(json.localAdminAddresses);
        }
        return builder.build();
    }

    public static ImmutableServerRuntimeInfo copyOf(ServerRuntimeInfo instance) {
        if (instance instanceof ImmutableServerRuntimeInfo) {
            return (ImmutableServerRuntimeInfo)instance;
        }
        return ImmutableServerRuntimeInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<ServerRuntimeInfo.Address> localAddresses = ImmutableList.builder();
        private ImmutableList.Builder<ServerRuntimeInfo.Address> localAdminAddresses = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerRuntimeInfo instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllLocalAddresses(instance.localAddresses());
            this.addAllLocalAdminAddresses(instance.localAdminAddresses());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocalAddresses(ServerRuntimeInfo.Address element) {
            this.localAddresses.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocalAddresses(ServerRuntimeInfo.Address ... elements) {
            this.localAddresses.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="local_addresses")
        @CanIgnoreReturnValue
        public final Builder localAddresses(Iterable<? extends ServerRuntimeInfo.Address> elements) {
            this.localAddresses = ImmutableList.builder();
            return this.addAllLocalAddresses(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLocalAddresses(Iterable<? extends ServerRuntimeInfo.Address> elements) {
            this.localAddresses.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocalAdminAddresses(ServerRuntimeInfo.Address element) {
            this.localAdminAddresses.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocalAdminAddresses(ServerRuntimeInfo.Address ... elements) {
            this.localAdminAddresses.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="local_admin_addresses")
        @CanIgnoreReturnValue
        public final Builder localAdminAddresses(Iterable<? extends ServerRuntimeInfo.Address> elements) {
            this.localAdminAddresses = ImmutableList.builder();
            return this.addAllLocalAdminAddresses(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLocalAdminAddresses(Iterable<? extends ServerRuntimeInfo.Address> elements) {
            this.localAdminAddresses.addAll(elements);
            return this;
        }

        public ImmutableServerRuntimeInfo build() {
            return new ImmutableServerRuntimeInfo(this.localAddresses.build(), this.localAdminAddresses.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ServerRuntimeInfo {
        List<ServerRuntimeInfo.Address> localAddresses = ImmutableList.of();
        List<ServerRuntimeInfo.Address> localAdminAddresses = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="local_addresses")
        public void setLocalAddresses(List<ServerRuntimeInfo.Address> localAddresses) {
            this.localAddresses = localAddresses;
        }

        @JsonProperty(value="local_admin_addresses")
        public void setLocalAdminAddresses(List<ServerRuntimeInfo.Address> localAdminAddresses) {
            this.localAdminAddresses = localAdminAddresses;
        }

        @Override
        public List<ServerRuntimeInfo.Address> localAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ServerRuntimeInfo.Address> localAdminAddresses() {
            throw new UnsupportedOperationException();
        }
    }
}

