/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics;

import com.google.common.base.Optional;
import io.digdag.spi.metrics.DigdagMetrics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface MonitorSystemConfig {
    public boolean getMonitorSystemEnable();

    public boolean getCategoryDefaultEnable();

    public boolean getCategoryAgentEnable();

    public boolean getCategoryApiEnable();

    public boolean getCategoryDbEnable();

    public boolean getCategoryExecutorEnable();

    default public boolean enable(DigdagMetrics.Category category) {
        return this.getMonitorSystemEnable() && this.getCategoryEnable(category);
    }

    default public boolean getCategoryEnable(DigdagMetrics.Category category) {
        switch (category) {
            case DEFAULT: {
                return this.getCategoryDefaultEnable();
            }
            case AGENT: {
                return this.getCategoryAgentEnable();
            }
            case API: {
                return this.getCategoryApiEnable();
            }
            case DB: {
                return this.getCategoryDbEnable();
            }
            case EXECUTOR: {
                return this.getCategoryExecutorEnable();
            }
        }
        return false;
    }

    public static Map<DigdagMetrics.Category, Boolean> getEnabledCategories(Optional<String> config) {
        List<DigdagMetrics.Category> ALL = Arrays.asList(DigdagMetrics.Category.class.getEnumConstants());
        HashMap<DigdagMetrics.Category, Boolean> map = new HashMap<DigdagMetrics.Category, Boolean>();
        for (DigdagMetrics.Category c : ALL) {
            map.put(c, false);
        }
        List enables = (List)config.transform(s -> Arrays.asList(s.split(",")).stream().map(x -> x.trim()).flatMap(x -> {
            List<DigdagMetrics.Category> ret = x.compareToIgnoreCase("all") == 0 ? ALL : Arrays.asList(DigdagMetrics.Category.fromString((String)x));
            return ret.stream();
        }).distinct().collect(Collectors.toList())).or(ALL);
        for (DigdagMetrics.Category c : enables) {
            map.put(c, true);
        }
        return map;
    }
}

