/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics.fluency;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.server.metrics.MonitorSystemConfig;
import io.digdag.server.metrics.fluency.ImmutableFluencyMonitorSystemConfig;
import io.digdag.spi.metrics.DigdagMetrics;
import java.util.Map;
import org.immutables.value.Value;
import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.fluentd.FluencyBuilderForFluentd;

@JsonDeserialize(as=ImmutableFluencyMonitorSystemConfig.class)
@Value.Immutable
public interface FluencyMonitorSystemConfig
extends MonitorSystemConfig {
    @Override
    @Value.Default
    default public boolean getMonitorSystemEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryDefaultEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryAgentEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryApiEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryDbEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryExecutorEnable() {
        return true;
    }

    @Value.Default
    default public String getType() {
        return "fluentd";
    }

    @Value.Default
    default public String getTag() {
        return "digdag";
    }

    @Value.Default
    default public String getHost() {
        return "localhost:24224";
    }

    @Value.Default
    default public long getStep() {
        return 60L;
    }

    @Value.Default
    default public Optional<String> getBackupDir() {
        return Optional.absent();
    }

    public static FluencyMonitorSystemConfig load(Config config) {
        Map<DigdagMetrics.Category, Boolean> categories = MonitorSystemConfig.getEnabledCategories((Optional<String>)config.getOptional("metrics.fluency.categories", String.class));
        return ImmutableFluencyMonitorSystemConfig.builder().monitorSystemEnable(true).categoryAgentEnable(categories.get(DigdagMetrics.Category.AGENT)).categoryApiEnable(categories.get(DigdagMetrics.Category.API)).categoryDbEnable(categories.get(DigdagMetrics.Category.DB)).categoryExecutorEnable(categories.get(DigdagMetrics.Category.EXECUTOR)).categoryDefaultEnable(categories.get(DigdagMetrics.Category.DEFAULT)).type((String)config.getOptional("metrics.fluency.type", String.class).or((Object)"fluentd")).tag((String)config.getOptional("metrics.fluency.tag", String.class).or((Object)"digdag")).host((String)config.getOptional("metrics.fluency.host", String.class).or((Object)"localhost:24224")).backupDir((Optional<String>)config.getOptional("metrics.fluency.host", String.class)).step((Long)config.getOptional("metrics.fluency.step", Long.class).or((Object)60L)).build();
    }

    public static Fluency createFluency(FluencyMonitorSystemConfig config) {
        try {
            if (!config.getType().equalsIgnoreCase("fluentd")) {
                throw new ConfigException("No supported type in FluencyMeterRegistry:" + config.getType());
            }
            String[] hostAndPort = config.getHost().split(":", 2);
            int port = hostAndPort.length == 1 ? 2424 : Integer.parseInt(hostAndPort[1]);
            return new FluencyBuilderForFluentd().build(hostAndPort[0], port);
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigException("Invalid configuration in FluencyMeterRegistry:" + e.toString());
        }
    }

    public static FluencyMonitorSystemConfig disabled() {
        return ImmutableFluencyMonitorSystemConfig.builder().monitorSystemEnable(false).build();
    }
}

