/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.server.rs.AdminRestricted;
import io.digdag.server.rs.AuthenticatedResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(value="Admin")
@AdminRestricted
@Path(value="/")
@Produces(value={"application/json"})
public class AdminResource
extends AuthenticatedResource {
    private final ProjectStoreManager pm;
    private final SessionStoreManager sm;
    private final TransactionManager tm;

    @Inject
    public AdminResource(ProjectStoreManager pm, SessionStoreManager sm, TransactionManager tm) {
        this.pm = pm;
        this.sm = sm;
        this.tm = tm;
    }

    @Deprecated
    @GET
    @Path(value="/api/admin/attempts/{id}/userinfo")
    @ApiOperation(value="(deprecated)")
    public Config getUserInfo(@PathParam(value="id") long id) throws ResourceNotFoundException {
        return (Config)this.tm.begin(() -> {
            StoredSessionAttemptWithSession session = this.sm.getAttemptWithSessionById(id);
            if (!session.getWorkflowDefinitionId().isPresent()) {
                throw new NotFoundException();
            }
            StoredRevision revision = this.pm.getRevisionOfWorkflowDefinition(((Long)session.getWorkflowDefinitionId().get()).longValue());
            return revision.getUserInfo();
        }, ResourceNotFoundException.class);
    }
}

