/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.client.api.RestLogFileHandleCollection;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.log.LogServerManager;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.metrics.DigdagTimed;
import io.digdag.server.rs.AuthenticatedResource;
import io.digdag.server.rs.RestModels;
import io.digdag.spi.LogFilePrefix;
import io.digdag.spi.LogServer;
import io.digdag.spi.StorageFileNotFoundException;
import io.digdag.spi.ac.AccessControlException;
import io.digdag.spi.ac.AccessController;
import io.digdag.spi.ac.WorkflowTarget;
import io.digdag.spi.metrics.DigdagMetrics;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="Log")
@Path(value="/")
@Produces(value={"application/json"})
public class LogResource
extends AuthenticatedResource {
    private final ProjectStoreManager rm;
    private final SessionStoreManager sm;
    private final TransactionManager tm;
    private final AccessController ac;
    private final LogServer logServer;
    private final DigdagMetrics metrics;

    @Inject
    public LogResource(ProjectStoreManager rm, SessionStoreManager sm, TransactionManager tm, AccessController ac, LogServerManager lm, DigdagMetrics metrics) {
        this.rm = rm;
        this.sm = sm;
        this.tm = tm;
        this.ac = ac;
        this.logServer = lm.getLogServer();
        this.metrics = metrics;
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @Path(value="/api/logs/{attempt_id}/files")
    @ApiOperation(value="List log files of an attempt with filters")
    public RestLogFileHandleCollection getFileHandles(@ApiParam(value="attempt id", required=true) @PathParam(value="attempt_id") long attemptId, @ApiParam(value="partial prefix match filter on task name", required=false) @QueryParam(value="task") String taskName, @ApiParam(value="enable returning direct download handle", required=false) @QueryParam(value="direct_download") Boolean directDownloadAllowed) throws ResourceNotFoundException, AccessControlException {
        boolean enableDirectDownload = directDownloadAllowed == null || directDownloadAllowed != false;
        return (RestLogFileHandleCollection)this.tm.begin(() -> {
            LogFilePrefix prefix = this.getPrefix(attemptId, (p, a) -> this.ac.checkGetLogFiles(WorkflowTarget.of((int)this.getSiteId(), (String)a.getSession().getWorkflowName(), (String)p.getName()), this.getAuthenticatedUser()));
            List handles = this.logServer.getFileHandles(prefix, Optional.fromNullable((Object)taskName), enableDirectDownload);
            return RestModels.logFileHandleCollection(handles);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @Produces(value={"application/gzip"})
    @Path(value="/api/logs/{attempt_id}/files/{file_name}")
    @ApiOperation(value="Download a log file")
    public byte[] getFile(@ApiParam(value="attempt id", required=true) @PathParam(value="attempt_id") long attemptId, @ApiParam(value="log file name", required=true) @PathParam(value="file_name") String fileName) throws ResourceNotFoundException, IOException, StorageFileNotFoundException, AccessControlException {
        return (byte[])this.tm.begin(() -> {
            LogFilePrefix prefix = this.getPrefix(attemptId, (p, a) -> this.ac.checkGetLogFiles(WorkflowTarget.of((int)this.getSiteId(), (String)a.getSession().getWorkflowName(), (String)p.getName()), this.getAuthenticatedUser()));
            return this.logServer.getFile(prefix, fileName);
        }, ResourceNotFoundException.class, IOException.class, StorageFileNotFoundException.class, AccessControlException.class);
    }

    private LogFilePrefix getPrefix(long attemptId, AccessControlAction acAction) throws ResourceNotFoundException, AccessControlException {
        StoredSessionAttemptWithSession attempt = this.sm.getSessionStore(this.getSiteId()).getAttemptById(attemptId);
        StoredProject project = this.rm.getProjectStore(this.getSiteId()).getProjectById(attempt.getSession().getProjectId());
        acAction.call(project, attempt);
        return LogServerManager.logFilePrefixFromSessionAttempt((StoredSessionAttemptWithSession)attempt);
    }

    private static interface AccessControlAction {
        public void call(StoredProject var1, StoredSessionAttemptWithSession var2) throws AccessControlException;
    }
}

