/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.server.ServerRuntimeInfo;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableAddress
implements ServerRuntimeInfo.Address {
    private final String host;
    private final int port;

    private ImmutableAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    @JsonProperty(value="host")
    public String host() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    public final ImmutableAddress withHost(String value) {
        if (this.host.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"host");
        return new ImmutableAddress(newValue, this.port);
    }

    public final ImmutableAddress withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableAddress(this.host, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAddress && this.equalTo((ImmutableAddress)another);
    }

    private boolean equalTo(ImmutableAddress another) {
        return this.host.equals(another.host) && this.port == another.port;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.host.hashCode();
        h = h * 17 + this.port;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Address").omitNullValues().add("host", (Object)this.host).add("port", this.port).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAddress fromJson(Json json) {
        Builder builder = ImmutableAddress.builder();
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.portIsSet) {
            builder.port(json.port);
        }
        return builder.build();
    }

    public static ImmutableAddress copyOf(ServerRuntimeInfo.Address instance) {
        if (instance instanceof ImmutableAddress) {
            return (ImmutableAddress)instance;
        }
        return ImmutableAddress.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private long initBits = 3L;
        @Nullable
        private String host;
        private int port;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerRuntimeInfo.Address instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.host(instance.host());
            this.port(instance.port());
            return this;
        }

        @JsonProperty(value="host")
        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="port")
        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAddress build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAddress(this.host, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build Address, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ServerRuntimeInfo.Address {
        @Nullable
        String host;
        int port;
        boolean portIsSet;

        Json() {
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @Override
        public String host() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int port() {
            throw new UnsupportedOperationException();
        }
    }
}

