/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import io.digdag.client.DigdagClient;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.client.config.ConfigFactory;
import io.digdag.guice.rs.server.undertow.UndertowListenAddress;
import io.digdag.guice.rs.server.undertow.UndertowServerConfig;
import io.digdag.server.ImmutableServerConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableServerConfig.class)
@Value.Immutable
public interface ServerConfig
extends UndertowServerConfig {
    public static final int DEFAULT_PORT = 65432;
    public static final String DEFAULT_BIND = "127.0.0.1";
    public static final String DEFAULT_ACCESS_LOG_PATTERN = "json";
    public static final String API_ADDRESS = "api";
    public static final String ADMIN_ADDRESS = "admin";

    public Optional<String> getServerRuntimeInfoPath();

    public int getPort();

    public String getBind();

    public Optional<Integer> getAdminPort();

    public Optional<String> getAdminBind();

    public boolean getExecutorEnabled();

    public boolean getEnableSwagger();

    public Map<String, String> getHeaders();

    public ConfigElement getSystemConfig();

    public Map<String, String> getEnvironment();

    public static ImmutableServerConfig.Builder defaultBuilder() {
        return ImmutableServerConfig.builder().port(65432).bind(DEFAULT_BIND).accessLogPattern(DEFAULT_ACCESS_LOG_PATTERN).executorEnabled(true);
    }

    public static ServerConfig defaultConfig() {
        return ServerConfig.defaultBuilder().build();
    }

    public static ServerConfig convertFrom(Config config) {
        Function<String, Map> readPrefixed = prefix -> config.getKeys().stream().filter(key -> key.startsWith((String)prefix)).collect(Collectors.toMap(key -> key.substring(prefix.length()), key -> (String)config.get(key, String.class)));
        return ServerConfig.defaultBuilder().port((Integer)config.get("server.port", Integer.TYPE, (Object)65432)).bind((String)config.get("server.bind", String.class, (Object)DEFAULT_BIND)).adminPort((Optional<Integer>)config.getOptional("server.admin.port", Integer.TYPE)).adminBind((Optional<String>)config.getOptional("server.admin.bind", String.class)).serverRuntimeInfoPath((Optional<String>)config.getOptional("server.runtime-info.path", String.class)).accessLogPath((Optional<String>)config.getOptional("server.access-log.path", String.class)).accessLogPattern((String)config.get("server.access-log.pattern", String.class, (Object)DEFAULT_ACCESS_LOG_PATTERN)).httpIoThreads((Optional<Integer>)config.getOptional("server.http.io-threads", Integer.class)).httpWorkerThreads((Optional<Integer>)config.getOptional("server.http.worker-threads", Integer.class)).httpNoRequestTimeout((Optional<Integer>)config.getOptional("server.http.no-request-timeout", Integer.class)).httpRequestParseTimeout((Optional<Integer>)config.getOptional("server.http.request-parse-timeout", Integer.class)).httpIoIdleTimeout((Optional<Integer>)config.getOptional("server.http.io-idle-timeout", Integer.class)).jmxPort((Optional<Integer>)config.getOptional("server.jmx.port", Integer.class)).enableHttp2((Boolean)config.get("server.http.enable-http2", Boolean.TYPE, (Object)false)).executorEnabled((Boolean)config.get("server.executor.enabled", Boolean.TYPE, (Object)true)).enableSwagger((Boolean)config.get("server.enable-swagger", Boolean.TYPE, (Object)false)).headers(readPrefixed.apply("server.http.headers.")).systemConfig(ConfigElement.copyOf((Config)config)).environment(readPrefixed.apply("server.environment.")).build();
    }

    public static ServerConfig convertFrom(ConfigElement configElement) {
        ConfigFactory cf = new ConfigFactory(new ObjectMapper().registerModule((Module)new GuavaModule()));
        return ServerConfig.convertFrom(configElement.toConfig(cf));
    }

    public static ConfigFactory configFactory() {
        return new ConfigFactory(DigdagClient.objectMapper());
    }

    public Set<Integer> getAdminSites();

    default public List<UndertowServerConfig.ListenAddress> getListenAddresses() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)UndertowListenAddress.builder().bind(this.getBind()).port(this.getPort()).name(API_ADDRESS).build());
        if (this.getAdminPort().isPresent()) {
            builder.add((Object)UndertowListenAddress.builder().bind((String)this.getAdminBind().or((Object)this.getBind())).port(((Integer)this.getAdminPort().get()).intValue()).name(ADMIN_ADDRESS).build());
        }
        return builder.build();
    }
}

