/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.digdag.client.Version;
import io.digdag.client.api.RestVersionCheckResult;
import io.digdag.server.ClientVersionChecker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="Version")
@Path(value="/")
@Produces(value={"application/json"})
public class VersionResource {
    private final Version version;
    private final ClientVersionChecker clientVersionChecker;

    @Inject
    public VersionResource(Version version, ClientVersionChecker clientVersionChecker) {
        this.version = version;
        this.clientVersionChecker = clientVersionChecker;
    }

    @GET
    @Path(value="/api/version")
    @ApiOperation(value="Get server version")
    public Map<String, Object> getVersion() {
        return ImmutableMap.of((Object)"version", (Object)this.version.toString());
    }

    @GET
    @Path(value="/api/version/check")
    @ApiOperation(value="Check client version compatibility")
    public RestVersionCheckResult checkClientVersion(@ApiParam(value="client version", required=true) @QueryParam(value="client") String clientVersionString) {
        Version clientVersion = Version.parse((String)clientVersionString);
        return RestVersionCheckResult.builder().serverVersion(this.version.toString()).upgradeRecommended(this.clientVersionChecker.isUpgradeRecommended(clientVersion)).apiCompatible(this.clientVersionChecker.isApiCompatible(clientVersion)).build();
    }
}

