/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.google.common.base.Optional;
import io.digdag.client.Version;
import io.digdag.client.config.Config;

public class ClientVersionChecker {
    private final Optional<Version> upgradeRecommendedUntil;
    private final Optional<Version> apiIncompatibleUntil;

    public static ClientVersionChecker fromSystemConfig(Config systemConfig) {
        return new ClientVersionChecker((Optional<Version>)systemConfig.getOptional("server.client-version-check.upgrade-recommended-if-older", String.class).transform(Version::parse), (Optional<Version>)systemConfig.getOptional("server.client-version-check.api-incompatible-if-older", String.class).transform(Version::parse));
    }

    private ClientVersionChecker(Optional<Version> upgradeRecommendedUntil, Optional<Version> apiIncompatibleUntil) {
        this.upgradeRecommendedUntil = upgradeRecommendedUntil;
        this.apiIncompatibleUntil = apiIncompatibleUntil;
    }

    public boolean isUpgradeRecommended(Version clientVersion) {
        if (!this.upgradeRecommendedUntil.isPresent()) {
            return false;
        }
        return clientVersion.isOlder((Version)this.upgradeRecommendedUntil.get());
    }

    public boolean isApiCompatible(Version clientVersion) {
        if (!this.apiIncompatibleUntil.isPresent()) {
            return true;
        }
        boolean incompatible = clientVersion.isOlder((Version)this.apiIncompatibleUntil.get());
        return !incompatible;
    }
}

