/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.digdag.client.DigdagClient;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public abstract class GenericJsonExceptionHandler<T extends Throwable>
implements ExceptionMapper<T> {
    private static final ObjectMapper messageMapper = DigdagClient.objectMapper();
    private final int statusCode;

    public static Response toResponse(Response.Status status, String message) {
        return GenericJsonExceptionHandler.toResponse(status.getStatusCode(), message);
    }

    public static Response toResponse(int statusCode, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", message);
        map.put("status", statusCode);
        try {
            return Response.status((int)statusCode).type("application/json").entity((Object)messageMapper.writeValueAsString(map)).build();
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public GenericJsonExceptionHandler(int statusCode) {
        this.statusCode = statusCode;
    }

    public GenericJsonExceptionHandler(Response.Status status) {
        this(status.getStatusCode());
    }

    public Response toResponse(T exception) {
        return GenericJsonExceptionHandler.toResponse(this.statusCode, ((Throwable)exception).getMessage());
    }

    public Response toResponse(String message) {
        return GenericJsonExceptionHandler.toResponse(this.statusCode, message);
    }
}

