/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.auth;

import io.digdag.client.config.ConfigFactory;
import io.digdag.spi.AuthenticatedUser;
import io.digdag.spi.Authenticator;
import io.digdag.spi.ImmutableAuthenticatedUser;
import javax.ws.rs.container.ContainerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(NoAuthenticator.class);
    private final ConfigFactory cf;

    public NoAuthenticator(ConfigFactory cf) {
        logger.debug("No authentication is configured. No authentication is required to call REST API.");
        this.cf = cf;
    }

    public Authenticator.Result authenticate(ContainerRequestContext requestContext) {
        ImmutableAuthenticatedUser user = AuthenticatedUser.builder().siteId(0).userInfo(this.cf.create()).userContext(this.cf.create()).build();
        return Authenticator.Result.accept((AuthenticatedUser)user);
    }
}

