/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics;

import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.server.metrics.MonitorSystemConfig;
import io.digdag.server.metrics.fluency.FluencyMonitorSystemConfig;
import io.digdag.server.metrics.jmx.JmxMonitorSystemConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigdagMetricsConfig {
    private static Logger logger = LoggerFactory.getLogger(DigdagMetricsConfig.class);
    private Map<String, MonitorSystemConfig> monitorSystems = new HashMap<String, MonitorSystemConfig>();

    public Optional<MonitorSystemConfig> getMonitorSystemConfig(String key) {
        return this.monitorSystems.containsKey(key) ? Optional.of((Object)this.monitorSystems.get(key)) : Optional.absent();
    }

    public DigdagMetricsConfig(Config config) {
        List keys = (List)config.getOptional("metrics.enable", String.class).transform(s -> Arrays.asList(s.split(",")).stream().map(x -> x.trim()).distinct().collect(Collectors.toList())).or(Arrays.asList(new String[0]));
        keys.stream().forEach(k -> this.monitorSystems.put((String)k, this.loadMonitorSystemConfig((String)k, config)));
    }

    protected MonitorSystemConfig loadMonitorSystemConfig(String key, Config config) {
        switch (key) {
            case "jmx": {
                return this.getJmxMonitorSystemConfig(config);
            }
            case "fluency": {
                return this.getFluencyMonitorSystemConfig(config);
            }
        }
        throw new ConfigException("Unsupported digdag-metrics monitor system:" + key);
    }

    JmxMonitorSystemConfig getJmxMonitorSystemConfig(Config config) {
        return JmxMonitorSystemConfig.load(config);
    }

    FluencyMonitorSystemConfig getFluencyMonitorSystemConfig(Config config) {
        return FluencyMonitorSystemConfig.load(config);
    }
}

