/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics.fluency;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.server.metrics.MonitorSystemConfig;
import io.digdag.server.metrics.fluency.FluencyMonitorSystemConfig;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableFluencyMonitorSystemConfig
implements FluencyMonitorSystemConfig {
    private final boolean monitorSystemEnable;
    private final boolean categoryDefaultEnable;
    private final boolean categoryAgentEnable;
    private final boolean categoryApiEnable;
    private final boolean categoryDbEnable;
    private final boolean categoryExecutorEnable;
    private final String type;
    private final String tag;
    private final String host;
    private final long step;
    private final Optional<String> backupDir;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFluencyMonitorSystemConfig(Builder builder) {
        if (builder.monitorSystemEnableIsSet()) {
            this.initShim.monitorSystemEnable(builder.monitorSystemEnable);
        }
        if (builder.categoryDefaultEnableIsSet()) {
            this.initShim.categoryDefaultEnable(builder.categoryDefaultEnable);
        }
        if (builder.categoryAgentEnableIsSet()) {
            this.initShim.categoryAgentEnable(builder.categoryAgentEnable);
        }
        if (builder.categoryApiEnableIsSet()) {
            this.initShim.categoryApiEnable(builder.categoryApiEnable);
        }
        if (builder.categoryDbEnableIsSet()) {
            this.initShim.categoryDbEnable(builder.categoryDbEnable);
        }
        if (builder.categoryExecutorEnableIsSet()) {
            this.initShim.categoryExecutorEnable(builder.categoryExecutorEnable);
        }
        if (builder.type != null) {
            this.initShim.type(builder.type);
        }
        if (builder.tag != null) {
            this.initShim.tag(builder.tag);
        }
        if (builder.host != null) {
            this.initShim.host(builder.host);
        }
        if (builder.stepIsSet()) {
            this.initShim.step(builder.step);
        }
        if (builder.backupDir != null) {
            this.initShim.backupDir((Optional<String>)builder.backupDir);
        }
        this.monitorSystemEnable = this.initShim.getMonitorSystemEnable();
        this.categoryDefaultEnable = this.initShim.getCategoryDefaultEnable();
        this.categoryAgentEnable = this.initShim.getCategoryAgentEnable();
        this.categoryApiEnable = this.initShim.getCategoryApiEnable();
        this.categoryDbEnable = this.initShim.getCategoryDbEnable();
        this.categoryExecutorEnable = this.initShim.getCategoryExecutorEnable();
        this.type = this.initShim.getType();
        this.tag = this.initShim.getTag();
        this.host = this.initShim.getHost();
        this.step = this.initShim.getStep();
        this.backupDir = this.initShim.getBackupDir();
        this.initShim = null;
    }

    private ImmutableFluencyMonitorSystemConfig(boolean monitorSystemEnable, boolean categoryDefaultEnable, boolean categoryAgentEnable, boolean categoryApiEnable, boolean categoryDbEnable, boolean categoryExecutorEnable, String type, String tag, String host, long step, Optional<String> backupDir) {
        this.monitorSystemEnable = monitorSystemEnable;
        this.categoryDefaultEnable = categoryDefaultEnable;
        this.categoryAgentEnable = categoryAgentEnable;
        this.categoryApiEnable = categoryApiEnable;
        this.categoryDbEnable = categoryDbEnable;
        this.categoryExecutorEnable = categoryExecutorEnable;
        this.type = type;
        this.tag = tag;
        this.host = host;
        this.step = step;
        this.backupDir = backupDir;
        this.initShim = null;
    }

    private boolean getMonitorSystemEnableInitialize() {
        return FluencyMonitorSystemConfig.super.getMonitorSystemEnable();
    }

    private boolean getCategoryDefaultEnableInitialize() {
        return FluencyMonitorSystemConfig.super.getCategoryDefaultEnable();
    }

    private boolean getCategoryAgentEnableInitialize() {
        return FluencyMonitorSystemConfig.super.getCategoryAgentEnable();
    }

    private boolean getCategoryApiEnableInitialize() {
        return FluencyMonitorSystemConfig.super.getCategoryApiEnable();
    }

    private boolean getCategoryDbEnableInitialize() {
        return FluencyMonitorSystemConfig.super.getCategoryDbEnable();
    }

    private boolean getCategoryExecutorEnableInitialize() {
        return FluencyMonitorSystemConfig.super.getCategoryExecutorEnable();
    }

    private String getTypeInitialize() {
        return FluencyMonitorSystemConfig.super.getType();
    }

    private String getTagInitialize() {
        return FluencyMonitorSystemConfig.super.getTag();
    }

    private String getHostInitialize() {
        return FluencyMonitorSystemConfig.super.getHost();
    }

    private long getStepInitialize() {
        return FluencyMonitorSystemConfig.super.getStep();
    }

    private Optional<String> getBackupDirInitialize() {
        return FluencyMonitorSystemConfig.super.getBackupDir();
    }

    @Override
    @JsonProperty(value="monitorSystemEnable")
    public boolean getMonitorSystemEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMonitorSystemEnable() : this.monitorSystemEnable;
    }

    @Override
    @JsonProperty(value="categoryDefaultEnable")
    public boolean getCategoryDefaultEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryDefaultEnable() : this.categoryDefaultEnable;
    }

    @Override
    @JsonProperty(value="categoryAgentEnable")
    public boolean getCategoryAgentEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryAgentEnable() : this.categoryAgentEnable;
    }

    @Override
    @JsonProperty(value="categoryApiEnable")
    public boolean getCategoryApiEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryApiEnable() : this.categoryApiEnable;
    }

    @Override
    @JsonProperty(value="categoryDbEnable")
    public boolean getCategoryDbEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryDbEnable() : this.categoryDbEnable;
    }

    @Override
    @JsonProperty(value="categoryExecutorEnable")
    public boolean getCategoryExecutorEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryExecutorEnable() : this.categoryExecutorEnable;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty(value="tag")
    public String getTag() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTag() : this.tag;
    }

    @Override
    @JsonProperty(value="host")
    public String getHost() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHost() : this.host;
    }

    @Override
    @JsonProperty(value="step")
    public long getStep() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStep() : this.step;
    }

    @Override
    @JsonProperty(value="backupDir")
    public Optional<String> getBackupDir() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBackupDir() : this.backupDir;
    }

    public final ImmutableFluencyMonitorSystemConfig withMonitorSystemEnable(boolean value) {
        if (this.monitorSystemEnable == value) {
            return this;
        }
        return new ImmutableFluencyMonitorSystemConfig(value, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, this.type, this.tag, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withCategoryDefaultEnable(boolean value) {
        if (this.categoryDefaultEnable == value) {
            return this;
        }
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, value, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, this.type, this.tag, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withCategoryAgentEnable(boolean value) {
        if (this.categoryAgentEnable == value) {
            return this;
        }
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, value, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, this.type, this.tag, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withCategoryApiEnable(boolean value) {
        if (this.categoryApiEnable == value) {
            return this;
        }
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, value, this.categoryDbEnable, this.categoryExecutorEnable, this.type, this.tag, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withCategoryDbEnable(boolean value) {
        if (this.categoryDbEnable == value) {
            return this;
        }
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, value, this.categoryExecutorEnable, this.type, this.tag, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withCategoryExecutorEnable(boolean value) {
        if (this.categoryExecutorEnable == value) {
            return this;
        }
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, value, this.type, this.tag, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, newValue, this.tag, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withTag(String value) {
        if (this.tag.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"tag");
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, this.type, newValue, this.host, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withHost(String value) {
        if (this.host.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"host");
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, this.type, this.tag, newValue, this.step, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withStep(long value) {
        if (this.step == value) {
            return this;
        }
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, this.type, this.tag, this.host, value, this.backupDir);
    }

    public final ImmutableFluencyMonitorSystemConfig withBackupDir(Optional<String> value) {
        if (this.backupDir == value) {
            return this;
        }
        Optional newValue = (Optional)Preconditions.checkNotNull(value, (Object)"backupDir");
        return new ImmutableFluencyMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable, this.type, this.tag, this.host, this.step, (Optional<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFluencyMonitorSystemConfig && this.equalTo((ImmutableFluencyMonitorSystemConfig)another);
    }

    private boolean equalTo(ImmutableFluencyMonitorSystemConfig another) {
        return this.monitorSystemEnable == another.monitorSystemEnable && this.categoryDefaultEnable == another.categoryDefaultEnable && this.categoryAgentEnable == another.categoryAgentEnable && this.categoryApiEnable == another.categoryApiEnable && this.categoryDbEnable == another.categoryDbEnable && this.categoryExecutorEnable == another.categoryExecutorEnable && this.type.equals(another.type) && this.tag.equals(another.tag) && this.host.equals(another.host) && this.step == another.step && this.backupDir.equals(another.backupDir);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode((boolean)this.monitorSystemEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryDefaultEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryAgentEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryApiEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryDbEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryExecutorEnable);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.tag.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + Longs.hashCode((long)this.step);
        h = h * 17 + this.backupDir.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FluencyMonitorSystemConfig").omitNullValues().add("monitorSystemEnable", this.monitorSystemEnable).add("categoryDefaultEnable", this.categoryDefaultEnable).add("categoryAgentEnable", this.categoryAgentEnable).add("categoryApiEnable", this.categoryApiEnable).add("categoryDbEnable", this.categoryDbEnable).add("categoryExecutorEnable", this.categoryExecutorEnable).add("type", (Object)this.type).add("tag", (Object)this.tag).add("host", (Object)this.host).add("step", this.step).add("backupDir", this.backupDir).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFluencyMonitorSystemConfig fromJson(Json json) {
        Builder builder = ImmutableFluencyMonitorSystemConfig.builder();
        if (json.monitorSystemEnableIsSet) {
            builder.monitorSystemEnable(json.monitorSystemEnable);
        }
        if (json.categoryDefaultEnableIsSet) {
            builder.categoryDefaultEnable(json.categoryDefaultEnable);
        }
        if (json.categoryAgentEnableIsSet) {
            builder.categoryAgentEnable(json.categoryAgentEnable);
        }
        if (json.categoryApiEnableIsSet) {
            builder.categoryApiEnable(json.categoryApiEnable);
        }
        if (json.categoryDbEnableIsSet) {
            builder.categoryDbEnable(json.categoryDbEnable);
        }
        if (json.categoryExecutorEnableIsSet) {
            builder.categoryExecutorEnable(json.categoryExecutorEnable);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.tag != null) {
            builder.tag(json.tag);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.stepIsSet) {
            builder.step(json.step);
        }
        if (json.backupDir != null) {
            builder.backupDir(json.backupDir);
        }
        return builder.build();
    }

    public static ImmutableFluencyMonitorSystemConfig copyOf(FluencyMonitorSystemConfig instance) {
        if (instance instanceof ImmutableFluencyMonitorSystemConfig) {
            return (ImmutableFluencyMonitorSystemConfig)instance;
        }
        return ImmutableFluencyMonitorSystemConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_MONITOR_SYSTEM_ENABLE = 1L;
        private static final long OPT_BIT_CATEGORY_DEFAULT_ENABLE = 2L;
        private static final long OPT_BIT_CATEGORY_AGENT_ENABLE = 4L;
        private static final long OPT_BIT_CATEGORY_API_ENABLE = 8L;
        private static final long OPT_BIT_CATEGORY_DB_ENABLE = 16L;
        private static final long OPT_BIT_CATEGORY_EXECUTOR_ENABLE = 32L;
        private static final long OPT_BIT_STEP = 64L;
        private long optBits;
        private boolean monitorSystemEnable;
        private boolean categoryDefaultEnable;
        private boolean categoryAgentEnable;
        private boolean categoryApiEnable;
        private boolean categoryDbEnable;
        private boolean categoryExecutorEnable;
        @Nullable
        private String type;
        @Nullable
        private String tag;
        @Nullable
        private String host;
        private long step;
        @Nullable
        private Optional<String> backupDir;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MonitorSystemConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FluencyMonitorSystemConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MonitorSystemConfig instance;
            long bits = 0L;
            if (object instanceof MonitorSystemConfig) {
                instance = (MonitorSystemConfig)object;
                if ((bits & 1L) == 0L) {
                    this.categoryDefaultEnable(instance.getCategoryDefaultEnable());
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.categoryExecutorEnable(instance.getCategoryExecutorEnable());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.monitorSystemEnable(instance.getMonitorSystemEnable());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.categoryApiEnable(instance.getCategoryApiEnable());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.categoryDbEnable(instance.getCategoryDbEnable());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.categoryAgentEnable(instance.getCategoryAgentEnable());
                    bits |= 8L;
                }
            }
            if (object instanceof FluencyMonitorSystemConfig) {
                instance = (FluencyMonitorSystemConfig)object;
                if ((bits & 1L) == 0L) {
                    this.categoryDefaultEnable(instance.getCategoryDefaultEnable());
                    bits |= 1L;
                }
                this.backupDir(instance.getBackupDir());
                if ((bits & 2L) == 0L) {
                    this.categoryApiEnable(instance.getCategoryApiEnable());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.categoryDbEnable(instance.getCategoryDbEnable());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.categoryAgentEnable(instance.getCategoryAgentEnable());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.categoryExecutorEnable(instance.getCategoryExecutorEnable());
                    bits |= 0x10L;
                }
                this.host(instance.getHost());
                if ((bits & 0x20L) == 0L) {
                    this.monitorSystemEnable(instance.getMonitorSystemEnable());
                    bits |= 0x20L;
                }
                this.step(instance.getStep());
                this.tag(instance.getTag());
                this.type(instance.getType());
            }
        }

        @JsonProperty(value="monitorSystemEnable")
        @CanIgnoreReturnValue
        public final Builder monitorSystemEnable(boolean monitorSystemEnable) {
            this.monitorSystemEnable = monitorSystemEnable;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="categoryDefaultEnable")
        @CanIgnoreReturnValue
        public final Builder categoryDefaultEnable(boolean categoryDefaultEnable) {
            this.categoryDefaultEnable = categoryDefaultEnable;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="categoryAgentEnable")
        @CanIgnoreReturnValue
        public final Builder categoryAgentEnable(boolean categoryAgentEnable) {
            this.categoryAgentEnable = categoryAgentEnable;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="categoryApiEnable")
        @CanIgnoreReturnValue
        public final Builder categoryApiEnable(boolean categoryApiEnable) {
            this.categoryApiEnable = categoryApiEnable;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="categoryDbEnable")
        @CanIgnoreReturnValue
        public final Builder categoryDbEnable(boolean categoryDbEnable) {
            this.categoryDbEnable = categoryDbEnable;
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="categoryExecutorEnable")
        @CanIgnoreReturnValue
        public final Builder categoryExecutorEnable(boolean categoryExecutorEnable) {
            this.categoryExecutorEnable = categoryExecutorEnable;
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            return this;
        }

        @JsonProperty(value="tag")
        @CanIgnoreReturnValue
        public final Builder tag(String tag) {
            this.tag = (String)Preconditions.checkNotNull((Object)tag, (Object)"tag");
            return this;
        }

        @JsonProperty(value="host")
        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
            return this;
        }

        @JsonProperty(value="step")
        @CanIgnoreReturnValue
        public final Builder step(long step) {
            this.step = step;
            this.optBits |= 0x40L;
            return this;
        }

        @JsonProperty(value="backupDir")
        @CanIgnoreReturnValue
        public final Builder backupDir(Optional<String> backupDir) {
            this.backupDir = (Optional)Preconditions.checkNotNull(backupDir, (Object)"backupDir");
            return this;
        }

        public ImmutableFluencyMonitorSystemConfig build() {
            return new ImmutableFluencyMonitorSystemConfig(this);
        }

        private boolean monitorSystemEnableIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean categoryDefaultEnableIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean categoryAgentEnableIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean categoryApiEnableIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean categoryDbEnableIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean categoryExecutorEnableIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean stepIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FluencyMonitorSystemConfig {
        boolean monitorSystemEnable;
        boolean monitorSystemEnableIsSet;
        boolean categoryDefaultEnable;
        boolean categoryDefaultEnableIsSet;
        boolean categoryAgentEnable;
        boolean categoryAgentEnableIsSet;
        boolean categoryApiEnable;
        boolean categoryApiEnableIsSet;
        boolean categoryDbEnable;
        boolean categoryDbEnableIsSet;
        boolean categoryExecutorEnable;
        boolean categoryExecutorEnableIsSet;
        @Nullable
        String type;
        @Nullable
        String tag;
        @Nullable
        String host;
        long step;
        boolean stepIsSet;
        @Nullable
        Optional<String> backupDir;

        Json() {
        }

        @JsonProperty(value="monitorSystemEnable")
        public void setMonitorSystemEnable(boolean monitorSystemEnable) {
            this.monitorSystemEnable = monitorSystemEnable;
            this.monitorSystemEnableIsSet = true;
        }

        @JsonProperty(value="categoryDefaultEnable")
        public void setCategoryDefaultEnable(boolean categoryDefaultEnable) {
            this.categoryDefaultEnable = categoryDefaultEnable;
            this.categoryDefaultEnableIsSet = true;
        }

        @JsonProperty(value="categoryAgentEnable")
        public void setCategoryAgentEnable(boolean categoryAgentEnable) {
            this.categoryAgentEnable = categoryAgentEnable;
            this.categoryAgentEnableIsSet = true;
        }

        @JsonProperty(value="categoryApiEnable")
        public void setCategoryApiEnable(boolean categoryApiEnable) {
            this.categoryApiEnable = categoryApiEnable;
            this.categoryApiEnableIsSet = true;
        }

        @JsonProperty(value="categoryDbEnable")
        public void setCategoryDbEnable(boolean categoryDbEnable) {
            this.categoryDbEnable = categoryDbEnable;
            this.categoryDbEnableIsSet = true;
        }

        @JsonProperty(value="categoryExecutorEnable")
        public void setCategoryExecutorEnable(boolean categoryExecutorEnable) {
            this.categoryExecutorEnable = categoryExecutorEnable;
            this.categoryExecutorEnableIsSet = true;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="tag")
        public void setTag(String tag) {
            this.tag = tag;
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="step")
        public void setStep(long step) {
            this.step = step;
            this.stepIsSet = true;
        }

        @JsonProperty(value="backupDir")
        public void setBackupDir(Optional<String> backupDir) {
            this.backupDir = backupDir;
        }

        @Override
        public boolean getMonitorSystemEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryDefaultEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryAgentEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryApiEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryDbEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryExecutorEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getStep() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBackupDir() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private boolean monitorSystemEnable;
        private int monitorSystemEnableBuildStage;
        private boolean categoryDefaultEnable;
        private int categoryDefaultEnableBuildStage;
        private boolean categoryAgentEnable;
        private int categoryAgentEnableBuildStage;
        private boolean categoryApiEnable;
        private int categoryApiEnableBuildStage;
        private boolean categoryDbEnable;
        private int categoryDbEnableBuildStage;
        private boolean categoryExecutorEnable;
        private int categoryExecutorEnableBuildStage;
        private String type;
        private int typeBuildStage;
        private String tag;
        private int tagBuildStage;
        private String host;
        private int hostBuildStage;
        private long step;
        private int stepBuildStage;
        private Optional<String> backupDir;
        private int backupDirBuildStage;

        private InitShim() {
        }

        boolean getMonitorSystemEnable() {
            if (this.monitorSystemEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.monitorSystemEnableBuildStage == 0) {
                this.monitorSystemEnableBuildStage = -1;
                this.monitorSystemEnable = ImmutableFluencyMonitorSystemConfig.this.getMonitorSystemEnableInitialize();
                this.monitorSystemEnableBuildStage = 1;
            }
            return this.monitorSystemEnable;
        }

        void monitorSystemEnable(boolean monitorSystemEnable) {
            this.monitorSystemEnable = monitorSystemEnable;
            this.monitorSystemEnableBuildStage = 1;
        }

        boolean getCategoryDefaultEnable() {
            if (this.categoryDefaultEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryDefaultEnableBuildStage == 0) {
                this.categoryDefaultEnableBuildStage = -1;
                this.categoryDefaultEnable = ImmutableFluencyMonitorSystemConfig.this.getCategoryDefaultEnableInitialize();
                this.categoryDefaultEnableBuildStage = 1;
            }
            return this.categoryDefaultEnable;
        }

        void categoryDefaultEnable(boolean categoryDefaultEnable) {
            this.categoryDefaultEnable = categoryDefaultEnable;
            this.categoryDefaultEnableBuildStage = 1;
        }

        boolean getCategoryAgentEnable() {
            if (this.categoryAgentEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryAgentEnableBuildStage == 0) {
                this.categoryAgentEnableBuildStage = -1;
                this.categoryAgentEnable = ImmutableFluencyMonitorSystemConfig.this.getCategoryAgentEnableInitialize();
                this.categoryAgentEnableBuildStage = 1;
            }
            return this.categoryAgentEnable;
        }

        void categoryAgentEnable(boolean categoryAgentEnable) {
            this.categoryAgentEnable = categoryAgentEnable;
            this.categoryAgentEnableBuildStage = 1;
        }

        boolean getCategoryApiEnable() {
            if (this.categoryApiEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryApiEnableBuildStage == 0) {
                this.categoryApiEnableBuildStage = -1;
                this.categoryApiEnable = ImmutableFluencyMonitorSystemConfig.this.getCategoryApiEnableInitialize();
                this.categoryApiEnableBuildStage = 1;
            }
            return this.categoryApiEnable;
        }

        void categoryApiEnable(boolean categoryApiEnable) {
            this.categoryApiEnable = categoryApiEnable;
            this.categoryApiEnableBuildStage = 1;
        }

        boolean getCategoryDbEnable() {
            if (this.categoryDbEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryDbEnableBuildStage == 0) {
                this.categoryDbEnableBuildStage = -1;
                this.categoryDbEnable = ImmutableFluencyMonitorSystemConfig.this.getCategoryDbEnableInitialize();
                this.categoryDbEnableBuildStage = 1;
            }
            return this.categoryDbEnable;
        }

        void categoryDbEnable(boolean categoryDbEnable) {
            this.categoryDbEnable = categoryDbEnable;
            this.categoryDbEnableBuildStage = 1;
        }

        boolean getCategoryExecutorEnable() {
            if (this.categoryExecutorEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryExecutorEnableBuildStage == 0) {
                this.categoryExecutorEnableBuildStage = -1;
                this.categoryExecutorEnable = ImmutableFluencyMonitorSystemConfig.this.getCategoryExecutorEnableInitialize();
                this.categoryExecutorEnableBuildStage = 1;
            }
            return this.categoryExecutorEnable;
        }

        void categoryExecutorEnable(boolean categoryExecutorEnable) {
            this.categoryExecutorEnable = categoryExecutorEnable;
            this.categoryExecutorEnableBuildStage = 1;
        }

        String getType() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = -1;
                this.type = (String)Preconditions.checkNotNull((Object)ImmutableFluencyMonitorSystemConfig.this.getTypeInitialize(), (Object)"type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(String type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        String getTag() {
            if (this.tagBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagBuildStage == 0) {
                this.tagBuildStage = -1;
                this.tag = (String)Preconditions.checkNotNull((Object)ImmutableFluencyMonitorSystemConfig.this.getTagInitialize(), (Object)"tag");
                this.tagBuildStage = 1;
            }
            return this.tag;
        }

        void tag(String tag) {
            this.tag = tag;
            this.tagBuildStage = 1;
        }

        String getHost() {
            if (this.hostBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hostBuildStage == 0) {
                this.hostBuildStage = -1;
                this.host = (String)Preconditions.checkNotNull((Object)ImmutableFluencyMonitorSystemConfig.this.getHostInitialize(), (Object)"host");
                this.hostBuildStage = 1;
            }
            return this.host;
        }

        void host(String host) {
            this.host = host;
            this.hostBuildStage = 1;
        }

        long getStep() {
            if (this.stepBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stepBuildStage == 0) {
                this.stepBuildStage = -1;
                this.step = ImmutableFluencyMonitorSystemConfig.this.getStepInitialize();
                this.stepBuildStage = 1;
            }
            return this.step;
        }

        void step(long step) {
            this.step = step;
            this.stepBuildStage = 1;
        }

        Optional<String> getBackupDir() {
            if (this.backupDirBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backupDirBuildStage == 0) {
                this.backupDirBuildStage = -1;
                this.backupDir = (Optional)Preconditions.checkNotNull((Object)ImmutableFluencyMonitorSystemConfig.this.getBackupDirInitialize(), (Object)"backupDir");
                this.backupDirBuildStage = 1;
            }
            return this.backupDir;
        }

        void backupDir(Optional<String> backupDir) {
            this.backupDir = backupDir;
            this.backupDirBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.monitorSystemEnableBuildStage == -1) {
                attributes.add("monitorSystemEnable");
            }
            if (this.categoryDefaultEnableBuildStage == -1) {
                attributes.add("categoryDefaultEnable");
            }
            if (this.categoryAgentEnableBuildStage == -1) {
                attributes.add("categoryAgentEnable");
            }
            if (this.categoryApiEnableBuildStage == -1) {
                attributes.add("categoryApiEnable");
            }
            if (this.categoryDbEnableBuildStage == -1) {
                attributes.add("categoryDbEnable");
            }
            if (this.categoryExecutorEnableBuildStage == -1) {
                attributes.add("categoryExecutorEnable");
            }
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            if (this.tagBuildStage == -1) {
                attributes.add("tag");
            }
            if (this.hostBuildStage == -1) {
                attributes.add("host");
            }
            if (this.stepBuildStage == -1) {
                attributes.add("step");
            }
            if (this.backupDirBuildStage == -1) {
                attributes.add("backupDir");
            }
            return "Cannot build FluencyMonitorSystemConfig, attribute initializers form cycle" + attributes;
        }
    }
}

