/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics.jmx;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.server.metrics.MonitorSystemConfig;
import io.digdag.server.metrics.jmx.JmxMonitorSystemConfig;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableJmxMonitorSystemConfig
implements JmxMonitorSystemConfig {
    private final boolean monitorSystemEnable;
    private final boolean categoryDefaultEnable;
    private final boolean categoryAgentEnable;
    private final boolean categoryApiEnable;
    private final boolean categoryDbEnable;
    private final boolean categoryExecutorEnable;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJmxMonitorSystemConfig(Builder builder) {
        if (builder.monitorSystemEnableIsSet()) {
            this.initShim.monitorSystemEnable(builder.monitorSystemEnable);
        }
        if (builder.categoryDefaultEnableIsSet()) {
            this.initShim.categoryDefaultEnable(builder.categoryDefaultEnable);
        }
        if (builder.categoryAgentEnableIsSet()) {
            this.initShim.categoryAgentEnable(builder.categoryAgentEnable);
        }
        if (builder.categoryApiEnableIsSet()) {
            this.initShim.categoryApiEnable(builder.categoryApiEnable);
        }
        if (builder.categoryDbEnableIsSet()) {
            this.initShim.categoryDbEnable(builder.categoryDbEnable);
        }
        if (builder.categoryExecutorEnableIsSet()) {
            this.initShim.categoryExecutorEnable(builder.categoryExecutorEnable);
        }
        this.monitorSystemEnable = this.initShim.getMonitorSystemEnable();
        this.categoryDefaultEnable = this.initShim.getCategoryDefaultEnable();
        this.categoryAgentEnable = this.initShim.getCategoryAgentEnable();
        this.categoryApiEnable = this.initShim.getCategoryApiEnable();
        this.categoryDbEnable = this.initShim.getCategoryDbEnable();
        this.categoryExecutorEnable = this.initShim.getCategoryExecutorEnable();
        this.initShim = null;
    }

    private ImmutableJmxMonitorSystemConfig(boolean monitorSystemEnable, boolean categoryDefaultEnable, boolean categoryAgentEnable, boolean categoryApiEnable, boolean categoryDbEnable, boolean categoryExecutorEnable) {
        this.monitorSystemEnable = monitorSystemEnable;
        this.categoryDefaultEnable = categoryDefaultEnable;
        this.categoryAgentEnable = categoryAgentEnable;
        this.categoryApiEnable = categoryApiEnable;
        this.categoryDbEnable = categoryDbEnable;
        this.categoryExecutorEnable = categoryExecutorEnable;
        this.initShim = null;
    }

    private boolean getMonitorSystemEnableInitialize() {
        return JmxMonitorSystemConfig.super.getMonitorSystemEnable();
    }

    private boolean getCategoryDefaultEnableInitialize() {
        return JmxMonitorSystemConfig.super.getCategoryDefaultEnable();
    }

    private boolean getCategoryAgentEnableInitialize() {
        return JmxMonitorSystemConfig.super.getCategoryAgentEnable();
    }

    private boolean getCategoryApiEnableInitialize() {
        return JmxMonitorSystemConfig.super.getCategoryApiEnable();
    }

    private boolean getCategoryDbEnableInitialize() {
        return JmxMonitorSystemConfig.super.getCategoryDbEnable();
    }

    private boolean getCategoryExecutorEnableInitialize() {
        return JmxMonitorSystemConfig.super.getCategoryExecutorEnable();
    }

    @Override
    @JsonProperty(value="monitorSystemEnable")
    public boolean getMonitorSystemEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMonitorSystemEnable() : this.monitorSystemEnable;
    }

    @Override
    @JsonProperty(value="categoryDefaultEnable")
    public boolean getCategoryDefaultEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryDefaultEnable() : this.categoryDefaultEnable;
    }

    @Override
    @JsonProperty(value="categoryAgentEnable")
    public boolean getCategoryAgentEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryAgentEnable() : this.categoryAgentEnable;
    }

    @Override
    @JsonProperty(value="categoryApiEnable")
    public boolean getCategoryApiEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryApiEnable() : this.categoryApiEnable;
    }

    @Override
    @JsonProperty(value="categoryDbEnable")
    public boolean getCategoryDbEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryDbEnable() : this.categoryDbEnable;
    }

    @Override
    @JsonProperty(value="categoryExecutorEnable")
    public boolean getCategoryExecutorEnable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCategoryExecutorEnable() : this.categoryExecutorEnable;
    }

    public final ImmutableJmxMonitorSystemConfig withMonitorSystemEnable(boolean value) {
        if (this.monitorSystemEnable == value) {
            return this;
        }
        return new ImmutableJmxMonitorSystemConfig(value, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable);
    }

    public final ImmutableJmxMonitorSystemConfig withCategoryDefaultEnable(boolean value) {
        if (this.categoryDefaultEnable == value) {
            return this;
        }
        return new ImmutableJmxMonitorSystemConfig(this.monitorSystemEnable, value, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable);
    }

    public final ImmutableJmxMonitorSystemConfig withCategoryAgentEnable(boolean value) {
        if (this.categoryAgentEnable == value) {
            return this;
        }
        return new ImmutableJmxMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, value, this.categoryApiEnable, this.categoryDbEnable, this.categoryExecutorEnable);
    }

    public final ImmutableJmxMonitorSystemConfig withCategoryApiEnable(boolean value) {
        if (this.categoryApiEnable == value) {
            return this;
        }
        return new ImmutableJmxMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, value, this.categoryDbEnable, this.categoryExecutorEnable);
    }

    public final ImmutableJmxMonitorSystemConfig withCategoryDbEnable(boolean value) {
        if (this.categoryDbEnable == value) {
            return this;
        }
        return new ImmutableJmxMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, value, this.categoryExecutorEnable);
    }

    public final ImmutableJmxMonitorSystemConfig withCategoryExecutorEnable(boolean value) {
        if (this.categoryExecutorEnable == value) {
            return this;
        }
        return new ImmutableJmxMonitorSystemConfig(this.monitorSystemEnable, this.categoryDefaultEnable, this.categoryAgentEnable, this.categoryApiEnable, this.categoryDbEnable, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJmxMonitorSystemConfig && this.equalTo((ImmutableJmxMonitorSystemConfig)another);
    }

    private boolean equalTo(ImmutableJmxMonitorSystemConfig another) {
        return this.monitorSystemEnable == another.monitorSystemEnable && this.categoryDefaultEnable == another.categoryDefaultEnable && this.categoryAgentEnable == another.categoryAgentEnable && this.categoryApiEnable == another.categoryApiEnable && this.categoryDbEnable == another.categoryDbEnable && this.categoryExecutorEnable == another.categoryExecutorEnable;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode((boolean)this.monitorSystemEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryDefaultEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryAgentEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryApiEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryDbEnable);
        h = h * 17 + Booleans.hashCode((boolean)this.categoryExecutorEnable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JmxMonitorSystemConfig").omitNullValues().add("monitorSystemEnable", this.monitorSystemEnable).add("categoryDefaultEnable", this.categoryDefaultEnable).add("categoryAgentEnable", this.categoryAgentEnable).add("categoryApiEnable", this.categoryApiEnable).add("categoryDbEnable", this.categoryDbEnable).add("categoryExecutorEnable", this.categoryExecutorEnable).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJmxMonitorSystemConfig fromJson(Json json) {
        Builder builder = ImmutableJmxMonitorSystemConfig.builder();
        if (json.monitorSystemEnableIsSet) {
            builder.monitorSystemEnable(json.monitorSystemEnable);
        }
        if (json.categoryDefaultEnableIsSet) {
            builder.categoryDefaultEnable(json.categoryDefaultEnable);
        }
        if (json.categoryAgentEnableIsSet) {
            builder.categoryAgentEnable(json.categoryAgentEnable);
        }
        if (json.categoryApiEnableIsSet) {
            builder.categoryApiEnable(json.categoryApiEnable);
        }
        if (json.categoryDbEnableIsSet) {
            builder.categoryDbEnable(json.categoryDbEnable);
        }
        if (json.categoryExecutorEnableIsSet) {
            builder.categoryExecutorEnable(json.categoryExecutorEnable);
        }
        return builder.build();
    }

    public static ImmutableJmxMonitorSystemConfig copyOf(JmxMonitorSystemConfig instance) {
        if (instance instanceof ImmutableJmxMonitorSystemConfig) {
            return (ImmutableJmxMonitorSystemConfig)instance;
        }
        return ImmutableJmxMonitorSystemConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_MONITOR_SYSTEM_ENABLE = 1L;
        private static final long OPT_BIT_CATEGORY_DEFAULT_ENABLE = 2L;
        private static final long OPT_BIT_CATEGORY_AGENT_ENABLE = 4L;
        private static final long OPT_BIT_CATEGORY_API_ENABLE = 8L;
        private static final long OPT_BIT_CATEGORY_DB_ENABLE = 16L;
        private static final long OPT_BIT_CATEGORY_EXECUTOR_ENABLE = 32L;
        private long optBits;
        private boolean monitorSystemEnable;
        private boolean categoryDefaultEnable;
        private boolean categoryAgentEnable;
        private boolean categoryApiEnable;
        private boolean categoryDbEnable;
        private boolean categoryExecutorEnable;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MonitorSystemConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(JmxMonitorSystemConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MonitorSystemConfig instance;
            long bits = 0L;
            if (object instanceof MonitorSystemConfig) {
                instance = (MonitorSystemConfig)object;
                if ((bits & 1L) == 0L) {
                    this.categoryDefaultEnable(instance.getCategoryDefaultEnable());
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.categoryExecutorEnable(instance.getCategoryExecutorEnable());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.monitorSystemEnable(instance.getMonitorSystemEnable());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.categoryApiEnable(instance.getCategoryApiEnable());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.categoryDbEnable(instance.getCategoryDbEnable());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.categoryAgentEnable(instance.getCategoryAgentEnable());
                    bits |= 8L;
                }
            }
            if (object instanceof JmxMonitorSystemConfig) {
                instance = (JmxMonitorSystemConfig)object;
                if ((bits & 1L) == 0L) {
                    this.categoryDefaultEnable(instance.getCategoryDefaultEnable());
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.categoryExecutorEnable(instance.getCategoryExecutorEnable());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.monitorSystemEnable(instance.getMonitorSystemEnable());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.categoryApiEnable(instance.getCategoryApiEnable());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.categoryDbEnable(instance.getCategoryDbEnable());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.categoryAgentEnable(instance.getCategoryAgentEnable());
                    bits |= 8L;
                }
            }
        }

        @JsonProperty(value="monitorSystemEnable")
        @CanIgnoreReturnValue
        public final Builder monitorSystemEnable(boolean monitorSystemEnable) {
            this.monitorSystemEnable = monitorSystemEnable;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="categoryDefaultEnable")
        @CanIgnoreReturnValue
        public final Builder categoryDefaultEnable(boolean categoryDefaultEnable) {
            this.categoryDefaultEnable = categoryDefaultEnable;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="categoryAgentEnable")
        @CanIgnoreReturnValue
        public final Builder categoryAgentEnable(boolean categoryAgentEnable) {
            this.categoryAgentEnable = categoryAgentEnable;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="categoryApiEnable")
        @CanIgnoreReturnValue
        public final Builder categoryApiEnable(boolean categoryApiEnable) {
            this.categoryApiEnable = categoryApiEnable;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="categoryDbEnable")
        @CanIgnoreReturnValue
        public final Builder categoryDbEnable(boolean categoryDbEnable) {
            this.categoryDbEnable = categoryDbEnable;
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="categoryExecutorEnable")
        @CanIgnoreReturnValue
        public final Builder categoryExecutorEnable(boolean categoryExecutorEnable) {
            this.categoryExecutorEnable = categoryExecutorEnable;
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableJmxMonitorSystemConfig build() {
            return new ImmutableJmxMonitorSystemConfig(this);
        }

        private boolean monitorSystemEnableIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean categoryDefaultEnableIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean categoryAgentEnableIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean categoryApiEnableIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean categoryDbEnableIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean categoryExecutorEnableIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements JmxMonitorSystemConfig {
        boolean monitorSystemEnable;
        boolean monitorSystemEnableIsSet;
        boolean categoryDefaultEnable;
        boolean categoryDefaultEnableIsSet;
        boolean categoryAgentEnable;
        boolean categoryAgentEnableIsSet;
        boolean categoryApiEnable;
        boolean categoryApiEnableIsSet;
        boolean categoryDbEnable;
        boolean categoryDbEnableIsSet;
        boolean categoryExecutorEnable;
        boolean categoryExecutorEnableIsSet;

        Json() {
        }

        @JsonProperty(value="monitorSystemEnable")
        public void setMonitorSystemEnable(boolean monitorSystemEnable) {
            this.monitorSystemEnable = monitorSystemEnable;
            this.monitorSystemEnableIsSet = true;
        }

        @JsonProperty(value="categoryDefaultEnable")
        public void setCategoryDefaultEnable(boolean categoryDefaultEnable) {
            this.categoryDefaultEnable = categoryDefaultEnable;
            this.categoryDefaultEnableIsSet = true;
        }

        @JsonProperty(value="categoryAgentEnable")
        public void setCategoryAgentEnable(boolean categoryAgentEnable) {
            this.categoryAgentEnable = categoryAgentEnable;
            this.categoryAgentEnableIsSet = true;
        }

        @JsonProperty(value="categoryApiEnable")
        public void setCategoryApiEnable(boolean categoryApiEnable) {
            this.categoryApiEnable = categoryApiEnable;
            this.categoryApiEnableIsSet = true;
        }

        @JsonProperty(value="categoryDbEnable")
        public void setCategoryDbEnable(boolean categoryDbEnable) {
            this.categoryDbEnable = categoryDbEnable;
            this.categoryDbEnableIsSet = true;
        }

        @JsonProperty(value="categoryExecutorEnable")
        public void setCategoryExecutorEnable(boolean categoryExecutorEnable) {
            this.categoryExecutorEnable = categoryExecutorEnable;
            this.categoryExecutorEnableIsSet = true;
        }

        @Override
        public boolean getMonitorSystemEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryDefaultEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryAgentEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryApiEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryDbEnable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCategoryExecutorEnable() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private boolean monitorSystemEnable;
        private int monitorSystemEnableBuildStage;
        private boolean categoryDefaultEnable;
        private int categoryDefaultEnableBuildStage;
        private boolean categoryAgentEnable;
        private int categoryAgentEnableBuildStage;
        private boolean categoryApiEnable;
        private int categoryApiEnableBuildStage;
        private boolean categoryDbEnable;
        private int categoryDbEnableBuildStage;
        private boolean categoryExecutorEnable;
        private int categoryExecutorEnableBuildStage;

        private InitShim() {
        }

        boolean getMonitorSystemEnable() {
            if (this.monitorSystemEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.monitorSystemEnableBuildStage == 0) {
                this.monitorSystemEnableBuildStage = -1;
                this.monitorSystemEnable = ImmutableJmxMonitorSystemConfig.this.getMonitorSystemEnableInitialize();
                this.monitorSystemEnableBuildStage = 1;
            }
            return this.monitorSystemEnable;
        }

        void monitorSystemEnable(boolean monitorSystemEnable) {
            this.monitorSystemEnable = monitorSystemEnable;
            this.monitorSystemEnableBuildStage = 1;
        }

        boolean getCategoryDefaultEnable() {
            if (this.categoryDefaultEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryDefaultEnableBuildStage == 0) {
                this.categoryDefaultEnableBuildStage = -1;
                this.categoryDefaultEnable = ImmutableJmxMonitorSystemConfig.this.getCategoryDefaultEnableInitialize();
                this.categoryDefaultEnableBuildStage = 1;
            }
            return this.categoryDefaultEnable;
        }

        void categoryDefaultEnable(boolean categoryDefaultEnable) {
            this.categoryDefaultEnable = categoryDefaultEnable;
            this.categoryDefaultEnableBuildStage = 1;
        }

        boolean getCategoryAgentEnable() {
            if (this.categoryAgentEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryAgentEnableBuildStage == 0) {
                this.categoryAgentEnableBuildStage = -1;
                this.categoryAgentEnable = ImmutableJmxMonitorSystemConfig.this.getCategoryAgentEnableInitialize();
                this.categoryAgentEnableBuildStage = 1;
            }
            return this.categoryAgentEnable;
        }

        void categoryAgentEnable(boolean categoryAgentEnable) {
            this.categoryAgentEnable = categoryAgentEnable;
            this.categoryAgentEnableBuildStage = 1;
        }

        boolean getCategoryApiEnable() {
            if (this.categoryApiEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryApiEnableBuildStage == 0) {
                this.categoryApiEnableBuildStage = -1;
                this.categoryApiEnable = ImmutableJmxMonitorSystemConfig.this.getCategoryApiEnableInitialize();
                this.categoryApiEnableBuildStage = 1;
            }
            return this.categoryApiEnable;
        }

        void categoryApiEnable(boolean categoryApiEnable) {
            this.categoryApiEnable = categoryApiEnable;
            this.categoryApiEnableBuildStage = 1;
        }

        boolean getCategoryDbEnable() {
            if (this.categoryDbEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryDbEnableBuildStage == 0) {
                this.categoryDbEnableBuildStage = -1;
                this.categoryDbEnable = ImmutableJmxMonitorSystemConfig.this.getCategoryDbEnableInitialize();
                this.categoryDbEnableBuildStage = 1;
            }
            return this.categoryDbEnable;
        }

        void categoryDbEnable(boolean categoryDbEnable) {
            this.categoryDbEnable = categoryDbEnable;
            this.categoryDbEnableBuildStage = 1;
        }

        boolean getCategoryExecutorEnable() {
            if (this.categoryExecutorEnableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.categoryExecutorEnableBuildStage == 0) {
                this.categoryExecutorEnableBuildStage = -1;
                this.categoryExecutorEnable = ImmutableJmxMonitorSystemConfig.this.getCategoryExecutorEnableInitialize();
                this.categoryExecutorEnableBuildStage = 1;
            }
            return this.categoryExecutorEnable;
        }

        void categoryExecutorEnable(boolean categoryExecutorEnable) {
            this.categoryExecutorEnable = categoryExecutorEnable;
            this.categoryExecutorEnableBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.monitorSystemEnableBuildStage == -1) {
                attributes.add("monitorSystemEnable");
            }
            if (this.categoryDefaultEnableBuildStage == -1) {
                attributes.add("categoryDefaultEnable");
            }
            if (this.categoryAgentEnableBuildStage == -1) {
                attributes.add("categoryAgentEnable");
            }
            if (this.categoryApiEnableBuildStage == -1) {
                attributes.add("categoryApiEnable");
            }
            if (this.categoryDbEnableBuildStage == -1) {
                attributes.add("categoryDbEnable");
            }
            if (this.categoryExecutorEnableBuildStage == -1) {
                attributes.add("categoryExecutorEnable");
            }
            return "Cannot build JmxMonitorSystemConfig, attribute initializers form cycle" + attributes;
        }
    }
}

