/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DuplicateInputStream
extends FilterInputStream {
    private final OutputStream out;
    private byte[] tempBuffer;

    public DuplicateInputStream(InputStream in, OutputStream out) {
        super(in);
        this.out = out;
    }

    private void ensureTempBuffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new byte[32768];
        }
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.out.write(c);
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n >= 0) {
            this.out.write(b, off, n);
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureTempBuffer();
        return this.read(this.tempBuffer, 0, (int)Math.min(n, (long)this.tempBuffer.length));
    }

    @Override
    public void close() throws IOException {
        this.ensureTempBuffer();
        while (this.read(this.tempBuffer) >= 0) {
        }
        this.in.close();
    }

    public void abort() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

