/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import io.digdag.client.api.RestProject;
import io.digdag.client.api.RestProjectCollection;
import io.digdag.client.api.RestRevisionCollection;
import io.digdag.client.api.RestScheduleCollection;
import io.digdag.client.api.RestSecret;
import io.digdag.client.api.RestSecretList;
import io.digdag.client.api.RestSecretMetadata;
import io.digdag.client.api.RestSessionCollection;
import io.digdag.client.api.RestSetSecretRequest;
import io.digdag.client.api.RestWorkflowDefinition;
import io.digdag.client.api.RestWorkflowDefinitionCollection;
import io.digdag.client.api.SecretValidation;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.TempFileManager;
import io.digdag.core.archive.ArchiveMetadata;
import io.digdag.core.archive.ProjectArchiveLoader;
import io.digdag.core.archive.WorkflowResourceMatcher;
import io.digdag.core.config.YamlConfigLoader;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ArchiveType;
import io.digdag.core.repository.ImmutableRevision;
import io.digdag.core.repository.Project;
import io.digdag.core.repository.ProjectControl;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.Revision;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.repository.WorkflowDefinitionList;
import io.digdag.core.schedule.ScheduleStore;
import io.digdag.core.schedule.ScheduleStoreManager;
import io.digdag.core.schedule.SchedulerManager;
import io.digdag.core.schedule.StoredSchedule;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.storage.ArchiveManager;
import io.digdag.core.workflow.Workflow;
import io.digdag.core.workflow.WorkflowCompiler;
import io.digdag.core.workflow.WorkflowTask;
import io.digdag.metrics.DigdagTimed;
import io.digdag.server.GenericJsonExceptionHandler;
import io.digdag.server.rs.AuthenticatedResource;
import io.digdag.server.rs.DuplicateInputStream;
import io.digdag.server.rs.QueryParamValidator;
import io.digdag.server.rs.RestModels;
import io.digdag.spi.DirectDownloadHandle;
import io.digdag.spi.SecretControlStore;
import io.digdag.spi.SecretControlStoreManager;
import io.digdag.spi.StorageFileNotFoundException;
import io.digdag.spi.StorageObject;
import io.digdag.spi.ac.AccessControlException;
import io.digdag.spi.ac.AccessController;
import io.digdag.spi.ac.ProjectTarget;
import io.digdag.spi.ac.SecretTarget;
import io.digdag.spi.ac.SiteTarget;
import io.digdag.spi.ac.WorkflowTarget;
import io.digdag.spi.metrics.DigdagMetrics;
import io.digdag.util.Md5CountInputStream;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Project")
@javax.ws.rs.Path(value="/")
@Produces(value={"application/json"})
public class ProjectResource
extends AuthenticatedResource {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResource.class);
    private static int MAX_ARCHIVE_TOTAL_SIZE_LIMIT;
    private static final int DEFAULT_ARCHIVE_TOTAL_SIZE_LIMIT = 0x200000;
    private static int MAX_ARCHIVE_FILE_SIZE_LIMIT;
    private static int MAX_SESSIONS_PAGE_SIZE;
    private static final int DEFAULT_SESSIONS_PAGE_SIZE = 100;
    private final ConfigFactory cf;
    private final YamlConfigLoader rawLoader;
    private final WorkflowCompiler compiler;
    private final ArchiveManager archiveManager;
    private final ProjectStoreManager rm;
    private final ScheduleStoreManager sm;
    private final AccessController ac;
    private final SchedulerManager srm;
    private final TempFileManager tempFiles;
    private final SessionStoreManager ssm;
    private final SecretControlStoreManager scsp;
    private final TransactionManager tm;
    private final ProjectArchiveLoader projectArchiveLoader;
    private final DigdagMetrics metrics;

    @Inject
    public ProjectResource(ConfigFactory cf, YamlConfigLoader rawLoader, WorkflowCompiler compiler, ArchiveManager archiveManager, ProjectStoreManager rm, ScheduleStoreManager sm, AccessController ac, SchedulerManager srm, TempFileManager tempFiles, SessionStoreManager ssm, SecretControlStoreManager scsp, TransactionManager tm, ProjectArchiveLoader projectArchiveLoader, Config systemConfig, DigdagMetrics metrics) {
        this.cf = cf;
        this.rawLoader = rawLoader;
        this.srm = srm;
        this.compiler = compiler;
        this.archiveManager = archiveManager;
        this.rm = rm;
        this.sm = sm;
        this.ac = ac;
        this.tempFiles = tempFiles;
        this.ssm = ssm;
        this.tm = tm;
        this.scsp = scsp;
        this.projectArchiveLoader = projectArchiveLoader;
        this.metrics = metrics;
        MAX_SESSIONS_PAGE_SIZE = (Integer)systemConfig.get("api.max_sessions_page_size", Integer.class, (Object)100);
        MAX_ARCHIVE_FILE_SIZE_LIMIT = MAX_ARCHIVE_TOTAL_SIZE_LIMIT = ((Integer)systemConfig.get("api.max_archive_total_size_limit", Integer.class, (Object)0x200000)).intValue();
    }

    private static StoredProject ensureNotDeletedProject(StoredProject proj) throws ResourceNotFoundException {
        if (proj.getDeletedAt().isPresent()) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Project id=%d is already deleted at %s", proj.getId(), ((Instant)proj.getDeletedAt().get()).toString()));
        }
        return proj;
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @Deprecated
    @GET
    @javax.ws.rs.Path(value="/api/project")
    @ApiOperation(value="(deprecated)")
    public RestProject getProject(@QueryParam(value="name") String name) throws ResourceNotFoundException, AccessControlException {
        return (RestProject)this.tm.begin(() -> {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name= is required");
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectByName(name));
            StoredRevision rev = ps.getLatestRevision(proj.getId());
            this.ac.checkGetProject(ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId()), this.getAuthenticatedUser());
            return RestModels.project(proj, rev);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @javax.ws.rs.Path(value="/api/projects")
    @ApiOperation(value="List projects with filters")
    public RestProjectCollection getProjects(@ApiParam(value="exact matching filter on project name", required=false) @QueryParam(value="name") String name, @ApiParam(value="list projects whose id is grater than this id for pagination", required=false) @QueryParam(value="last_id") Integer lastId, @ApiParam(value="number of projects to return", required=false) @QueryParam(value="count") Integer count, @ApiParam(value="name pattern to be partially matched", required=false) @QueryParam(value="name_pattern") String namePattern) {
        return (RestProjectCollection)this.tm.begin(() -> {
            Object collection;
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            if (name != null) {
                try {
                    StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectByName(name));
                    StoredRevision rev = ps.getLatestRevision(proj.getId());
                    this.ac.checkGetProject(ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId()), this.getAuthenticatedUser());
                    collection = ImmutableList.of((Object)RestModels.project(proj, rev));
                }
                catch (ResourceNotFoundException | AccessControlException ex) {
                    collection = ImmutableList.of();
                }
            } else {
                SiteTarget siteTarget = SiteTarget.of((int)this.getSiteId());
                try {
                    this.ac.checkListProjectsOfSite(siteTarget, this.getAuthenticatedUser());
                    collection = ps.getProjectsWithLatestRevision(((Integer)Optional.fromNullable((Object)count).or((Object)100)).intValue(), Optional.fromNullable((Object)lastId), Optional.fromNullable((Object)namePattern), this.ac.getListProjectsFilterOfSite(siteTarget, this.getAuthenticatedUser())).stream().map(projWithRev -> RestModels.project(projWithRev)).collect(Collectors.toList());
                }
                catch (AccessControlException ex) {
                    collection = ImmutableList.of();
                }
            }
            return RestModels.projectCollection((List<RestProject>)collection);
        });
    }

    @DigdagTimed(category="api", value="getProjectById")
    @GET
    @javax.ws.rs.Path(value="/api/projects/{id}")
    @ApiOperation(value="Get a project")
    public RestProject getProject(@ApiParam(value="project id", required=false) @PathParam(value="id") int projId) throws ResourceNotFoundException, AccessControlException {
        return (RestProject)this.tm.begin(() -> {
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectById(projId));
            StoredRevision rev = ps.getLatestRevision(proj.getId());
            this.ac.checkGetProject(ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId()), this.getAuthenticatedUser());
            return RestModels.project(proj, rev);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @javax.ws.rs.Path(value="/api/projects/{id}/revisions")
    @ApiOperation(value="List revisions of a project")
    public RestRevisionCollection getRevisions(@PathParam(value="id") int projId, @ApiParam(value="deprecated - do not use") @QueryParam(value="last_id") Integer lastId, @ApiParam(value="revision name") @QueryParam(value="name") String revName) throws ResourceNotFoundException, AccessControlException {
        return (RestRevisionCollection)this.tm.begin(() -> {
            Object revs;
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectById(projId));
            if (revName != null) {
                try {
                    StoredRevision rev = ps.getRevisionByName(proj.getId(), revName);
                    revs = ImmutableList.of((Object)rev);
                }
                catch (ResourceNotFoundException ex) {
                    revs = ImmutableList.of();
                }
            } else {
                revs = ps.getRevisions(proj.getId(), 100, Optional.fromNullable((Object)lastId));
            }
            this.ac.checkGetProject(ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId()), this.getAuthenticatedUser());
            return RestModels.revisionCollection(proj, (List<StoredRevision>)revs);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @Deprecated
    @GET
    @javax.ws.rs.Path(value="/api/projects/{id}/workflow")
    @ApiOperation(value="(deprecated)")
    public RestWorkflowDefinition getWorkflow(@PathParam(value="id") int projId, @QueryParam(value="name") String name, @QueryParam(value="revision") String revName) throws ResourceNotFoundException, AccessControlException {
        return (RestWorkflowDefinition)this.tm.begin(() -> {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name= is required");
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectById(projId));
            StoredRevision rev = revName == null ? ps.getLatestRevision(proj.getId()) : ps.getRevisionByName(proj.getId(), revName);
            StoredWorkflowDefinition def = ps.getWorkflowDefinitionByName(rev.getId(), name);
            this.ac.checkGetWorkflow(WorkflowTarget.of((int)this.getSiteId(), (String)name, (String)proj.getName()), this.getAuthenticatedUser());
            return RestModels.workflowDefinition(proj, (Revision)rev, def);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @javax.ws.rs.Path(value="/api/projects/{id}/workflows/{name}")
    public RestWorkflowDefinition getWorkflowByName(@PathParam(value="id") int projId, @PathParam(value="name") String name, @QueryParam(value="revision") String revName) throws ResourceNotFoundException, AccessControlException {
        return this.getWorkflow(projId, name, revName);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @javax.ws.rs.Path(value="/api/projects/{id}/workflows")
    @ApiOperation(value="List workflows of a project with filters")
    public RestWorkflowDefinitionCollection getWorkflows(@ApiParam(value="project id", required=true) @PathParam(value="id") int projId, @ApiParam(value="use a given revision of the project instead of the latest revision", required=true) @QueryParam(value="revision") String revName, @ApiParam(value="exact matching filter on workflow name", required=false) @QueryParam(value="name") String name) throws ResourceNotFoundException {
        return (RestWorkflowDefinitionCollection)this.tm.begin(() -> {
            Object collection;
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectById(projId));
            StoredRevision rev = revName == null ? ps.getLatestRevision(proj.getId()) : ps.getRevisionByName(proj.getId(), revName);
            if (name != null) {
                try {
                    StoredWorkflowDefinition def = ps.getWorkflowDefinitionByName(rev.getId(), name);
                    this.ac.checkGetWorkflow(WorkflowTarget.of((int)this.getSiteId(), (String)def.getName(), (String)proj.getName()), this.getAuthenticatedUser());
                    collection = ImmutableList.of((Object)def);
                }
                catch (ResourceNotFoundException | AccessControlException ex) {
                    collection = ImmutableList.of();
                }
            } else {
                ProjectTarget projTarget = ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId());
                try {
                    this.ac.checkListWorkflowsOfProject(projTarget, this.getAuthenticatedUser());
                    collection = ps.getWorkflowDefinitions(rev.getId(), Integer.MAX_VALUE, Optional.absent(), this.ac.getListWorkflowsFilterOfProject(projTarget, this.getAuthenticatedUser()));
                }
                catch (AccessControlException ex) {
                    collection = ImmutableList.of();
                }
            }
            return RestModels.workflowDefinitionCollection(proj, rev, (List<StoredWorkflowDefinition>)collection);
        }, ResourceNotFoundException.class);
    }

    @DigdagTimed(category="api", value="getProjectSchedules")
    @GET
    @ApiOperation(value="List schedules of a project with filters")
    @javax.ws.rs.Path(value="/api/projects/{id}/schedules")
    public RestScheduleCollection getSchedules(@ApiParam(value="project id", required=true) @PathParam(value="id") int projectId, @ApiParam(value="exact matching filter on workflow name", required=false) @QueryParam(value="workflow") String workflowName, @ApiParam(value="list schedules whose id is grater than this id for pagination", required=false) @QueryParam(value="last_id") Integer lastId) throws ResourceNotFoundException, AccessControlException {
        return (RestScheduleCollection)this.tm.begin(() -> {
            Object scheds;
            ProjectStore projectStore = this.rm.getProjectStore(this.getSiteId());
            ScheduleStore scheduleStore = this.sm.getScheduleStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(projectStore.getProjectById(projectId));
            if (workflowName != null) {
                try {
                    this.ac.checkGetScheduleFromWorkflow(WorkflowTarget.of((int)this.getSiteId(), (String)workflowName, (String)proj.getName()), this.getAuthenticatedUser());
                    StoredSchedule sched = scheduleStore.getScheduleByProjectIdAndWorkflowName(projectId, workflowName);
                    scheds = ImmutableList.of((Object)sched);
                }
                catch (ResourceNotFoundException | AccessControlException ex) {
                    scheds = ImmutableList.of();
                }
            } else {
                ProjectTarget projTarget = ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId());
                this.ac.checkListSchedulesOfProject(projTarget, this.getAuthenticatedUser());
                scheds = scheduleStore.getSchedulesByProjectId(projectId, 100, Optional.fromNullable((Object)lastId), this.ac.getListSchedulesFilterOfProject(projTarget, this.getAuthenticatedUser()));
            }
            return RestModels.scheduleCollection(projectStore, (List<StoredSchedule>)scheds);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", value="getProjectSessions")
    @GET
    @ApiOperation(value="List sessions of a project with filters")
    @javax.ws.rs.Path(value="/api/projects/{id}/sessions")
    public RestSessionCollection getSessions(@ApiParam(value="project id", required=true) @PathParam(value="id") int projectId, @ApiParam(value="exact matching filter on workflow name", required=false) @QueryParam(value="workflow") String workflowName, @ApiParam(value="list sessions whose id is grater than this id for pagination", required=false) @QueryParam(value="last_id") Long lastId, @ApiParam(value="number of sessions to return", required=false) @QueryParam(value="page_size") Integer pageSize) throws ResourceNotFoundException, AccessControlException {
        int validPageSize = QueryParamValidator.validatePageSize((Optional<Integer>)Optional.fromNullable((Object)pageSize), MAX_SESSIONS_PAGE_SIZE, 100);
        return (RestSessionCollection)this.tm.begin(() -> {
            List sessions;
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            SessionStore ss = this.ssm.getSessionStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectById(projectId));
            if (workflowName != null) {
                WorkflowTarget wfTarget = WorkflowTarget.of((int)this.getSiteId(), (String)workflowName, (String)proj.getName());
                this.ac.checkListSessionsOfWorkflow(wfTarget, this.getAuthenticatedUser());
                sessions = ss.getSessionsOfWorkflowByName(proj.getId(), workflowName, validPageSize, Optional.fromNullable((Object)lastId), this.ac.getListSessionsFilterOfWorkflow(wfTarget, this.getAuthenticatedUser()));
            } else {
                ProjectTarget projTarget = ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId());
                this.ac.checkListSessionsOfProject(projTarget, this.getAuthenticatedUser());
                sessions = ss.getSessionsOfProject(proj.getId(), validPageSize, Optional.fromNullable((Object)lastId), this.ac.getListSessionsFilterOfProject(projTarget, this.getAuthenticatedUser()));
            }
            return RestModels.sessionCollection(ps, sessions);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @javax.ws.rs.Path(value="/api/projects/{id}/archive")
    @Produces(value={"application/gzip"})
    @ApiOperation(value="Download a project archive file")
    public Response getArchive(@ApiParam(value="project id", required=true) @PathParam(value="id") int projId, @ApiParam(value="use a given revision of a project instead of the latest revision", required=true) @QueryParam(value="revision") String revName, @ApiParam(value="enable returning direct download handle", required=false) @QueryParam(value="direct_download") Boolean directDownloadAllowed) throws ResourceNotFoundException, AccessControlException {
        boolean enableDirectDownload = directDownloadAllowed == null || directDownloadAllowed != false;
        return (Response)this.tm.begin(() -> {
            Optional bytes;
            Optional direct;
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            StoredProject proj = ProjectResource.ensureNotDeletedProject(ps.getProjectById(projId));
            Optional archiveOrNone = this.archiveManager.getArchive(ps, projId, revName);
            this.ac.checkGetProjectArchive(ProjectTarget.of((int)this.getSiteId(), (String)proj.getName(), (int)proj.getId()), this.getAuthenticatedUser());
            if (!archiveOrNone.isPresent()) {
                throw new ResourceNotFoundException("Archive is not stored");
            }
            final ArchiveManager.StoredArchive archive = (ArchiveManager.StoredArchive)archiveOrNone.get();
            if (enableDirectDownload && (direct = archive.getDirectDownloadHandle()).isPresent()) {
                try {
                    return Response.seeOther((URI)URI.create(String.valueOf(((DirectDownloadHandle)direct.get()).getUrl()))).build();
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Failed to create a HTTP response to redirect /api/projects/{id}/archive to a direct download URL. Falling back to fetching from the server.", (Throwable)ex);
                }
            }
            if ((bytes = archive.getByteArray()).isPresent()) {
                return Response.ok((Object)bytes.get()).build();
            }
            return Response.ok((Object)new StreamingOutput(){

                public void write(OutputStream out) throws IOException, WebApplicationException {
                    StorageObject obj;
                    try {
                        obj = archive.open();
                    }
                    catch (StorageFileNotFoundException ex) {
                        throw new NotFoundException(GenericJsonExceptionHandler.toResponse(Response.Status.NOT_FOUND, "Archive file not found"));
                    }
                    try (InputStream in = obj.getContentInputStream();){
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                }
            }).build();
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @DELETE
    @javax.ws.rs.Path(value="/api/projects/{id}")
    @ApiOperation(value="Delete a project")
    public RestProject deleteProject(@PathParam(value="id") int projId) throws ResourceNotFoundException, AccessControlException {
        return (RestProject)this.tm.begin(() -> {
            ProjectStore ps = this.rm.getProjectStore(this.getSiteId());
            StoredProject project = ProjectResource.ensureNotDeletedProject(ps.getProjectById(projId));
            this.ac.checkDeleteProject(ProjectTarget.of((int)this.getSiteId(), (String)project.getName(), (int)project.getId()), this.getAuthenticatedUser());
            return (RestProject)ProjectControl.deleteProject((ProjectStore)ps, (int)projId, (control, proj) -> {
                StoredRevision rev = ps.getLatestRevision(proj.getId());
                return RestModels.project(proj, rev);
            });
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @PUT
    @Consumes(value={"application/gzip"})
    @javax.ws.rs.Path(value="/api/projects")
    @ApiOperation(value="Upload a project archive as a new project or a new revision of an existing project")
    public RestProject putProject(@ApiParam(value="project name", required=true) @QueryParam(value="project") String name, @ApiParam(value="revision", required=true) @QueryParam(value="revision") String revision, InputStream body, @HeaderParam(value="Content-Length") long contentLength, @ApiParam(value="start scheduling of new workflows from the given time instead of current time", required=false) @QueryParam(value="schedule_from") String scheduleFromString) throws ResourceConflictException, IOException, ResourceNotFoundException, AccessControlException {
        this.ac.checkPutProject(ProjectTarget.of((int)this.getSiteId(), (String)name), this.getAuthenticatedUser());
        return (RestProject)this.tm.begin(() -> {
            Instant scheduleFrom;
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"project= is required");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)revision) ? 1 : 0) != 0, (Object)"revision= is required");
            if (scheduleFromString == null || scheduleFromString.isEmpty()) {
                scheduleFrom = Instant.now();
            } else {
                try {
                    scheduleFrom = Instant.parse(scheduleFromString);
                }
                catch (DateTimeParseException ex) {
                    throw new IllegalArgumentException("Invalid schedule_from= parameter format. Expected yyyy-MM-dd'T'HH:mm:ss'Z' format", ex);
                }
            }
            if (contentLength > (long)MAX_ARCHIVE_TOTAL_SIZE_LIMIT) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Size of the uploaded archive file exceeds limit (%d bytes)", MAX_ARCHIVE_TOTAL_SIZE_LIMIT));
            }
            int size = (int)contentLength;
            try (TempFileManager.TempFile tempFile = this.tempFiles.createTempFile("upload-", ".tar.gz");){
                byte[] md5;
                ArchiveMetadata meta;
                try (OutputStream writeToTemp = Files.newOutputStream(tempFile.get(), new OpenOption[0]);){
                    Md5CountInputStream md5Count = new Md5CountInputStream(body);
                    meta = this.readArchiveMetadata(new DuplicateInputStream((InputStream)md5Count, writeToTemp), name);
                    md5 = md5Count.getDigest();
                    if (md5Count.getCount() != contentLength) {
                        throw new IllegalArgumentException("Content-Length header doesn't match with uploaded data size");
                    }
                    this.validateWorkflowAndSchedule(meta);
                }
                ArchiveManager.Location location = this.archiveManager.newArchiveLocation(this.getSiteId(), name, revision, (long)size);
                boolean storeInDb = location.getArchiveType().equals((Object)ArchiveType.DB);
                if (!storeInDb) {
                    try {
                        this.archiveManager.getStorage(location.getArchiveType()).put(location.getPath(), (long)size, () -> Files.newInputStream(tempFile.get(), new OpenOption[0]));
                    }
                    catch (IOException | RuntimeException ex) {
                        throw new InternalServerErrorException("Failed to upload archive to a remote storage", (Throwable)ex);
                    }
                }
                Map secrets = (Map)this.getSecrets().get();
                RestProject restProject = (RestProject)this.rm.getProjectStore(this.getSiteId()).putAndLockProject(Project.of((String)name), (store, storedProject) -> {
                    StoredRevision rev;
                    ProjectControl lockedProj = new ProjectControl(store, storedProject);
                    if (storeInDb) {
                        byte[] data = new byte[size];
                        try (InputStream in = Files.newInputStream(tempFile.get(), new OpenOption[0]);){
                            ByteStreams.readFully((InputStream)in, (byte[])data);
                        }
                        catch (IOException | RuntimeException ex) {
                            throw new InternalServerErrorException("Failed to load archive data in memory", (Throwable)ex);
                        }
                        rev = lockedProj.insertRevision((Revision)Revision.builderFromArchive((String)revision, (ArchiveMetadata)meta, (Config)this.getUserInfo()).archiveType(ArchiveType.DB).archivePath(Optional.absent()).archiveMd5(Optional.of((Object)md5)).build());
                        lockedProj.insertRevisionArchiveData(rev.getId(), data);
                    } else {
                        rev = lockedProj.insertRevision((Revision)Revision.builderFromArchive((String)revision, (ArchiveMetadata)meta, (Config)this.getUserInfo()).archiveType(location.getArchiveType()).archivePath(Optional.of((Object)location.getPath())).archiveMd5(Optional.of((Object)md5)).build());
                    }
                    List defs = lockedProj.insertWorkflowDefinitions(rev, meta.getWorkflowList().get(), this.srm, scheduleFrom);
                    return RestModels.project(storedProject, rev);
                });
                SecretControlStore secretControlStore = this.scsp.getSecretControlStore(this.getSiteId());
                secrets.forEach((k, v) -> secretControlStore.setProjectSecret(RestModels.parseProjectId(restProject.getId()), "project-default", k, v));
                RestProject restProject2 = restProject;
                return restProject2;
            }
        }, IOException.class, ResourceConflictException.class, ResourceNotFoundException.class, AccessControlException.class);
    }

    private ArchiveMetadata readArchiveMetadata(InputStream in, String projectName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"projectName");
        try (TempFileManager.TempDir dir = this.tempFiles.createTempDir("push", projectName);){
            long totalSize = 0L;
            try (TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(in, 32768)));){
                totalSize = this.extractConfigFiles(dir.get(), archive);
            }
            if (totalSize > (long)MAX_ARCHIVE_TOTAL_SIZE_LIMIT) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Total size of the archive exceeds limit (%d > %d bytes)", totalSize, MAX_ARCHIVE_TOTAL_SIZE_LIMIT));
            }
            archive = this.projectArchiveLoader.load(dir.get(), WorkflowResourceMatcher.defaultMatcher(), this.cf.create());
            var8_8 = archive.getArchiveMetadata();
            return var8_8;
        }
    }

    private long extractConfigFiles(Path dir, TarArchiveInputStream archive) throws IOException {
        TarArchiveEntry entry;
        long totalSize = 0L;
        while ((entry = archive.getNextTarEntry()) != null) {
            if (entry.isDirectory()) continue;
            this.validateTarEntry(entry);
            totalSize += entry.getSize();
            Path file = dir.resolve(entry.getName());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            OutputStream out = Files.newOutputStream(file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                ByteStreams.copy((InputStream)archive, (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
        return totalSize;
    }

    private void validateTarEntry(TarArchiveEntry entry) {
        if (entry.getSize() > (long)MAX_ARCHIVE_FILE_SIZE_LIMIT) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Size of a file in the archive exceeds limit (%d > %d bytes): %s", entry.getSize(), MAX_ARCHIVE_FILE_SIZE_LIMIT, entry.getName()));
        }
    }

    private void validateWorkflowAndSchedule(ArchiveMetadata meta) {
        WorkflowDefinitionList defs = meta.getWorkflowList();
        for (WorkflowDefinition def : defs.get()) {
            Workflow wf = this.compiler.compile(def.getName(), def.getConfig());
            for (WorkflowTask task : wf.getTasks()) {
                task.getConfig();
            }
            ImmutableRevision rev = Revision.builderFromArchive((String)"check", (ArchiveMetadata)meta, (Config)this.getUserInfo()).archiveType(ArchiveType.NONE).build();
            this.srm.tryGetScheduler((Revision)rev, def);
        }
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @PUT
    @Consumes(value={"application/json"})
    @javax.ws.rs.Path(value="/api/projects/{id}/secrets/{key}")
    @ApiOperation(value="Set a secret to a project")
    public RestSecret putProjectSecret(@ApiParam(value="project id", required=true) @PathParam(value="id") int projectId, @ApiParam(value="secret key", required=true) @PathParam(value="key") String key, RestSetSecretRequest request) throws ResourceNotFoundException, AccessControlException {
        return (RestSecret)this.tm.begin(() -> {
            if (!SecretValidation.isValidSecret((String)key, (String)request.value())) {
                throw new IllegalArgumentException("Invalid secret");
            }
            ProjectStore projectStore = this.rm.getProjectStore(this.getSiteId());
            StoredProject project = projectStore.getProjectById(projectId);
            ProjectResource.ensureNotDeletedProject(project);
            this.ac.checkPutProjectSecret(SecretTarget.of((int)this.getSiteId(), (String)key, (int)project.getId(), (String)project.getName()), this.getAuthenticatedUser());
            SecretControlStore store = this.scsp.getSecretControlStore(this.getSiteId());
            store.setProjectSecret(projectId, "project", key, request.value());
            return RestModels.secret(project, key);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @DELETE
    @javax.ws.rs.Path(value="/api/projects/{id}/secrets/{key}")
    @ApiOperation(value="Delete a secret from a project")
    public RestSecret deleteProjectSecret(@ApiParam(value="project id", required=true) @PathParam(value="id") int projectId, @ApiParam(value="secret key", required=true) @PathParam(value="key") String key) throws ResourceNotFoundException, AccessControlException {
        return (RestSecret)this.tm.begin(() -> {
            if (!SecretValidation.isValidSecretKey((String)key)) {
                throw new IllegalArgumentException("Invalid secret");
            }
            ProjectStore projectStore = this.rm.getProjectStore(this.getSiteId());
            StoredProject project = projectStore.getProjectById(projectId);
            ProjectResource.ensureNotDeletedProject(project);
            this.ac.checkDeleteProjectSecret(SecretTarget.of((int)this.getSiteId(), (String)key, (int)project.getId(), (String)project.getName()), this.getAuthenticatedUser());
            SecretControlStore store = this.scsp.getSecretControlStore(this.getSiteId());
            store.deleteProjectSecret(projectId, "project", key);
            return RestModels.secret(project, key);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @javax.ws.rs.Path(value="/api/projects/{id}/secrets")
    @Produces(value={"application/json"})
    @ApiOperation(value="List secret keys of a project")
    public RestSecretList getProjectSecrets(@ApiParam(value="project id", required=true) @PathParam(value="id") int projectId) throws ResourceNotFoundException, AccessControlException {
        return (RestSecretList)this.tm.begin(() -> {
            ProjectStore projectStore = this.rm.getProjectStore(this.getSiteId());
            StoredProject project = projectStore.getProjectById(projectId);
            ProjectResource.ensureNotDeletedProject(project);
            this.ac.checkGetProjectSecretList(ProjectTarget.of((int)this.getSiteId(), (String)project.getName(), (int)project.getId()), this.getAuthenticatedUser());
            SecretControlStore store = this.scsp.getSecretControlStore(this.getSiteId());
            List keys = store.listProjectSecrets(projectId, "project");
            return RestSecretList.builder().secrets((Iterable)keys.stream().map(RestSecretMetadata::of).collect(Collectors.toList())).build();
        }, ResourceNotFoundException.class, AccessControlException.class);
    }
}

