/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.digdag.client.api.LocalTimeOrInstant;
import io.digdag.client.api.RestWorkflowDefinition;
import io.digdag.client.api.RestWorkflowDefinitionCollection;
import io.digdag.client.api.RestWorkflowSessionTime;
import io.digdag.client.api.SessionTimeTruncate;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.Revision;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.schedule.ScheduleStoreManager;
import io.digdag.core.schedule.SchedulerManager;
import io.digdag.metrics.DigdagTimed;
import io.digdag.server.rs.AuthenticatedResource;
import io.digdag.server.rs.RestModels;
import io.digdag.spi.Scheduler;
import io.digdag.spi.ac.AccessControlException;
import io.digdag.spi.ac.AccessController;
import io.digdag.spi.ac.SiteTarget;
import io.digdag.spi.ac.WorkflowTarget;
import io.digdag.spi.metrics.DigdagMetrics;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="Workflow")
@Path(value="/")
@Produces(value={"application/json"})
public class WorkflowResource
extends AuthenticatedResource {
    private final ProjectStoreManager rm;
    private final ScheduleStoreManager sm;
    private final SchedulerManager srm;
    private final TransactionManager tm;
    private final AccessController ac;
    private final DigdagMetrics metrics;

    @Inject
    public WorkflowResource(ProjectStoreManager rm, ScheduleStoreManager sm, SchedulerManager srm, TransactionManager tm, AccessController ac, DigdagMetrics metrics) {
        this.rm = rm;
        this.sm = sm;
        this.srm = srm;
        this.tm = tm;
        this.ac = ac;
        this.metrics = metrics;
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @Deprecated
    @GET
    @Path(value="/api/workflow")
    @ApiOperation(value="(deprecated)")
    public RestWorkflowDefinition getWorkflowDefinition(@QueryParam(value="project") String projName, @QueryParam(value="revision") String revName, @QueryParam(value="name") String wfName) throws ResourceNotFoundException, AccessControlException {
        return (RestWorkflowDefinition)this.tm.begin(() -> {
            Preconditions.checkArgument((projName != null ? 1 : 0) != 0, (Object)"project= is required");
            Preconditions.checkArgument((wfName != null ? 1 : 0) != 0, (Object)"name= is required");
            ProjectStore rs = this.rm.getProjectStore(this.getSiteId());
            StoredProject proj = rs.getProjectByName(projName);
            StoredRevision rev = revName == null ? rs.getLatestRevision(proj.getId()) : rs.getRevisionByName(proj.getId(), revName);
            StoredWorkflowDefinition def = rs.getWorkflowDefinitionByName(rev.getId(), wfName);
            this.ac.checkGetWorkflow(WorkflowTarget.of((int)this.getSiteId(), (String)def.getName(), (String)proj.getName()), this.getAuthenticatedUser());
            return RestModels.workflowDefinition(proj, (Revision)rev, def);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @Path(value="/api/workflows")
    @ApiOperation(value="List workflows")
    public RestWorkflowDefinitionCollection getWorkflowDefinitions(@ApiParam(value="pagination. return workflows which id are greater than last_id with order 'asc', which id are less than the last_id with order 'desc'", required=false) @QueryParam(value="last_id") Long lastId, @ApiParam(value="number of workflows to return", required=false) @QueryParam(value="count") Integer count, @ApiParam(value="Sort order. 'asc' or 'desc'", defaultValue="asc", required=false) @DefaultValue(value="asc") @QueryParam(value="order") String orderDirection, @ApiParam(value="name pattern to be partially matched", required=false) @QueryParam(value="name_pattern") String namePattern, @ApiParam(value="name pattern to be partially matched", required=false) @DefaultValue(value="false") @QueryParam(value="search_project_name") Boolean searchProjectName) throws ResourceNotFoundException, AccessControlException {
        SiteTarget siteTarget = SiteTarget.of((int)this.getSiteId());
        this.ac.checkListWorkflowsOfSite(siteTarget, this.getAuthenticatedUser());
        return (RestWorkflowDefinitionCollection)this.tm.begin(() -> {
            List defs = this.rm.getProjectStore(this.getSiteId()).getLatestActiveWorkflowDefinitions(((Integer)Optional.fromNullable((Object)count).or((Object)100)).intValue(), Optional.fromNullable((Object)lastId), this.orderAscending(orderDirection), Optional.fromNullable((Object)namePattern), searchProjectName.booleanValue(), this.ac.getListWorkflowsFilterOfSite(SiteTarget.of((int)this.getSiteId()), this.getAuthenticatedUser()));
            return RestModels.workflowDefinitionCollection(defs);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    private boolean orderAscending(String orderDirection) {
        if (orderDirection == null || orderDirection.equals("asc")) {
            return true;
        }
        if (orderDirection.equals("desc")) {
            return false;
        }
        throw new IllegalArgumentException("parameter 'order' must be either 'asc' or 'desc'");
    }

    @DigdagTimed(category="api", value="getWorkflowDefinitionById")
    @GET
    @Path(value="/api/workflows/{id}")
    @ApiOperation(value="Get a workflow")
    public RestWorkflowDefinition getWorkflowDefinition(@ApiParam(value="workflow id", required=true) @PathParam(value="id") long id) throws ResourceNotFoundException, AccessControlException {
        return (RestWorkflowDefinition)this.tm.begin(() -> {
            StoredWorkflowDefinitionWithProject def = this.rm.getProjectStore(this.getSiteId()).getWorkflowDefinitionById(id);
            this.ac.checkGetWorkflow(WorkflowTarget.of((int)this.getSiteId(), (String)def.getName(), (String)def.getProject().getName()), this.getAuthenticatedUser());
            return RestModels.workflowDefinition(def);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @Path(value="/api/workflows/{id}/truncated_session_time")
    @ApiOperation(value="Get truncated local time based on the time zone of a workflow")
    public RestWorkflowSessionTime getWorkflowDefinition(@ApiParam(value="workflow id", required=true) @PathParam(value="id") long id, @ApiParam(value="session time to be truncated", required=true) @QueryParam(value="session_time") LocalTimeOrInstant localTime, @ApiParam(value="truncation mode - second, minute, hour, day, schedule, or next_schedule", required=false) @QueryParam(value="mode") SessionTimeTruncate mode) throws ResourceNotFoundException, AccessControlException {
        return (RestWorkflowSessionTime)this.tm.begin(() -> {
            Preconditions.checkArgument((localTime != null ? 1 : 0) != 0, (Object)"session_time= is required");
            StoredWorkflowDefinitionWithProject def = this.rm.getProjectStore(this.getSiteId()).getWorkflowDefinitionById(id);
            this.ac.checkGetWorkflow(WorkflowTarget.of((int)this.getSiteId(), (String)def.getName(), (String)def.getProject().getName()), this.getAuthenticatedUser());
            ZoneId timeZone = def.getTimeZone();
            Instant truncated = mode != null ? this.truncateSessionTime(localTime.toInstant(timeZone), timeZone, () -> this.srm.tryGetScheduler(def), mode) : localTime.toInstant(timeZone);
            return RestModels.workflowSessionTime(def, truncated, timeZone);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    private Instant truncateSessionTime(Instant sessionTime, ZoneId timeZone, Supplier<Optional<Scheduler>> schedulerSupplier, SessionTimeTruncate mode) {
        switch (mode) {
            case HOUR: {
                return ZonedDateTime.ofInstant(sessionTime, timeZone).truncatedTo(ChronoUnit.HOURS).toInstant();
            }
            case DAY: {
                return ZonedDateTime.ofInstant(sessionTime, timeZone).truncatedTo(ChronoUnit.DAYS).toInstant();
            }
        }
        Optional<Scheduler> scheduler = schedulerSupplier.get();
        if (!scheduler.isPresent()) {
            throw new IllegalArgumentException("session_time_truncate=" + mode + " is set but schedule is not set to this workflow");
        }
        switch (mode) {
            case SCHEDULE: {
                return ((Scheduler)scheduler.get()).getFirstScheduleTime(sessionTime).getTime();
            }
            case NEXT_SCHEDULE: {
                return ((Scheduler)scheduler.get()).nextScheduleTime(sessionTime).getTime();
            }
        }
        throw new IllegalArgumentException();
    }
}

