/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.ConfigElement;
import io.digdag.guice.rs.server.undertow.UndertowServerConfig;
import io.digdag.server.ServerConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableServerConfig
implements ServerConfig {
    private final Optional<String> serverRuntimeInfoPath;
    private final int port;
    private final String bind;
    private final Optional<Integer> adminPort;
    private final Optional<String> adminBind;
    private final boolean executorEnabled;
    private final boolean enableSwagger;
    private final ImmutableMap<String, String> headers;
    private final ConfigElement systemConfig;
    private final ImmutableMap<String, String> environment;
    private final String authenticatorClass;
    private final ImmutableSet<Integer> adminSites;
    private final Optional<String> accessLogPath;
    private final String accessLogPattern;
    private final Optional<Integer> httpIoThreads;
    private final Optional<Integer> httpWorkerThreads;
    private final Optional<Integer> httpNoRequestTimeout;
    private final Optional<Integer> httpRequestParseTimeout;
    private final Optional<Integer> httpIoIdleTimeout;
    private final Optional<Integer> jmxPort;
    private final boolean enableHttp2;

    private ImmutableServerConfig(Optional<String> serverRuntimeInfoPath, int port, String bind, Optional<Integer> adminPort, Optional<String> adminBind, boolean executorEnabled, boolean enableSwagger, ImmutableMap<String, String> headers, ConfigElement systemConfig, ImmutableMap<String, String> environment, String authenticatorClass, ImmutableSet<Integer> adminSites, Optional<String> accessLogPath, String accessLogPattern, Optional<Integer> httpIoThreads, Optional<Integer> httpWorkerThreads, Optional<Integer> httpNoRequestTimeout, Optional<Integer> httpRequestParseTimeout, Optional<Integer> httpIoIdleTimeout, Optional<Integer> jmxPort, boolean enableHttp2) {
        this.serverRuntimeInfoPath = serverRuntimeInfoPath;
        this.port = port;
        this.bind = bind;
        this.adminPort = adminPort;
        this.adminBind = adminBind;
        this.executorEnabled = executorEnabled;
        this.enableSwagger = enableSwagger;
        this.headers = headers;
        this.systemConfig = systemConfig;
        this.environment = environment;
        this.authenticatorClass = authenticatorClass;
        this.adminSites = adminSites;
        this.accessLogPath = accessLogPath;
        this.accessLogPattern = accessLogPattern;
        this.httpIoThreads = httpIoThreads;
        this.httpWorkerThreads = httpWorkerThreads;
        this.httpNoRequestTimeout = httpNoRequestTimeout;
        this.httpRequestParseTimeout = httpRequestParseTimeout;
        this.httpIoIdleTimeout = httpIoIdleTimeout;
        this.jmxPort = jmxPort;
        this.enableHttp2 = enableHttp2;
    }

    @Override
    @JsonProperty(value="serverRuntimeInfoPath")
    public Optional<String> getServerRuntimeInfoPath() {
        return this.serverRuntimeInfoPath;
    }

    @Override
    @JsonProperty(value="port")
    public int getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="bind")
    public String getBind() {
        return this.bind;
    }

    @Override
    @JsonProperty(value="adminPort")
    public Optional<Integer> getAdminPort() {
        return this.adminPort;
    }

    @Override
    @JsonProperty(value="adminBind")
    public Optional<String> getAdminBind() {
        return this.adminBind;
    }

    @Override
    @JsonProperty(value="executorEnabled")
    public boolean getExecutorEnabled() {
        return this.executorEnabled;
    }

    @Override
    @JsonProperty(value="enableSwagger")
    public boolean getEnableSwagger() {
        return this.enableSwagger;
    }

    @JsonProperty(value="headers")
    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    @JsonProperty(value="systemConfig")
    public ConfigElement getSystemConfig() {
        return this.systemConfig;
    }

    @JsonProperty(value="environment")
    public ImmutableMap<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    @JsonProperty(value="authenticatorClass")
    public String getAuthenticatorClass() {
        return this.authenticatorClass;
    }

    @JsonProperty(value="adminSites")
    public ImmutableSet<Integer> getAdminSites() {
        return this.adminSites;
    }

    @JsonProperty(value="accessLogPath")
    public Optional<String> getAccessLogPath() {
        return this.accessLogPath;
    }

    @JsonProperty(value="accessLogPattern")
    public String getAccessLogPattern() {
        return this.accessLogPattern;
    }

    @JsonProperty(value="httpIoThreads")
    public Optional<Integer> getHttpIoThreads() {
        return this.httpIoThreads;
    }

    @JsonProperty(value="httpWorkerThreads")
    public Optional<Integer> getHttpWorkerThreads() {
        return this.httpWorkerThreads;
    }

    @JsonProperty(value="httpNoRequestTimeout")
    public Optional<Integer> getHttpNoRequestTimeout() {
        return this.httpNoRequestTimeout;
    }

    @JsonProperty(value="httpRequestParseTimeout")
    public Optional<Integer> getHttpRequestParseTimeout() {
        return this.httpRequestParseTimeout;
    }

    @JsonProperty(value="httpIoIdleTimeout")
    public Optional<Integer> getHttpIoIdleTimeout() {
        return this.httpIoIdleTimeout;
    }

    @JsonProperty(value="jmxPort")
    public Optional<Integer> getJmxPort() {
        return this.jmxPort;
    }

    @JsonProperty(value="enableHttp2")
    public boolean getEnableHttp2() {
        return this.enableHttp2;
    }

    public final ImmutableServerConfig withServerRuntimeInfoPath(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.serverRuntimeInfoPath.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig((Optional<String>)newValue, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withServerRuntimeInfoPath(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"serverRuntimeInfoPath");
        if (this.serverRuntimeInfoPath.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig((Optional<String>)value, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, value, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withBind(String value) {
        if (this.bind.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"bind");
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, newValue, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAdminPort(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.adminPort.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, (Optional<Integer>)newValue, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAdminPort(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"adminPort");
        if (this.adminPort.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, (Optional<Integer>)value, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAdminBind(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.adminBind.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, (Optional<String>)newValue, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAdminBind(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"adminBind");
        if (this.adminBind.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, (Optional<String>)value, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withExecutorEnabled(boolean value) {
        if (this.executorEnabled == value) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, value, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withEnableSwagger(boolean value) {
        if (this.enableSwagger == value) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, value, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHeaders(Map<String, ? extends String> entries) {
        if (this.headers == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, (ImmutableMap<String, String>)newValue, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withSystemConfig(ConfigElement value) {
        if (this.systemConfig == value) {
            return this;
        }
        ConfigElement newValue = (ConfigElement)Preconditions.checkNotNull((Object)value, (Object)"systemConfig");
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, newValue, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withEnvironment(Map<String, ? extends String> entries) {
        if (this.environment == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, (ImmutableMap<String, String>)newValue, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAuthenticatorClass(String value) {
        if (this.authenticatorClass.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"authenticatorClass");
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, newValue, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAdminSites(int ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, (ImmutableSet<Integer>)newValue, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAdminSites(Iterable<Integer> elements) {
        if (this.adminSites == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, (ImmutableSet<Integer>)newValue, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAccessLogPath(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.accessLogPath.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, (Optional<String>)newValue, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAccessLogPath(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"accessLogPath");
        if (this.accessLogPath.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, (Optional<String>)value, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withAccessLogPattern(String value) {
        if (this.accessLogPattern.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"accessLogPattern");
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, newValue, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpIoThreads(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.httpIoThreads.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, (Optional<Integer>)newValue, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpIoThreads(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"httpIoThreads");
        if (this.httpIoThreads.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, (Optional<Integer>)value, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpWorkerThreads(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.httpWorkerThreads.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, (Optional<Integer>)newValue, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpWorkerThreads(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"httpWorkerThreads");
        if (this.httpWorkerThreads.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, (Optional<Integer>)value, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpNoRequestTimeout(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.httpNoRequestTimeout.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, (Optional<Integer>)newValue, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpNoRequestTimeout(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"httpNoRequestTimeout");
        if (this.httpNoRequestTimeout.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, (Optional<Integer>)value, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpRequestParseTimeout(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.httpRequestParseTimeout.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, (Optional<Integer>)newValue, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpRequestParseTimeout(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"httpRequestParseTimeout");
        if (this.httpRequestParseTimeout.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, (Optional<Integer>)value, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpIoIdleTimeout(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.httpIoIdleTimeout.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, (Optional<Integer>)newValue, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withHttpIoIdleTimeout(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"httpIoIdleTimeout");
        if (this.httpIoIdleTimeout.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, (Optional<Integer>)value, this.jmxPort, this.enableHttp2);
    }

    public final ImmutableServerConfig withJmxPort(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.jmxPort.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, (Optional<Integer>)newValue, this.enableHttp2);
    }

    public final ImmutableServerConfig withJmxPort(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"jmxPort");
        if (this.jmxPort.equals((Object)value)) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, (Optional<Integer>)value, this.enableHttp2);
    }

    public final ImmutableServerConfig withEnableHttp2(boolean value) {
        if (this.enableHttp2 == value) {
            return this;
        }
        return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers, this.systemConfig, this.environment, this.authenticatorClass, this.adminSites, this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerConfig && this.equalTo((ImmutableServerConfig)another);
    }

    private boolean equalTo(ImmutableServerConfig another) {
        return this.serverRuntimeInfoPath.equals(another.serverRuntimeInfoPath) && this.port == another.port && this.bind.equals(another.bind) && this.adminPort.equals(another.adminPort) && this.adminBind.equals(another.adminBind) && this.executorEnabled == another.executorEnabled && this.enableSwagger == another.enableSwagger && this.headers.equals(another.headers) && this.systemConfig.equals((Object)another.systemConfig) && this.environment.equals(another.environment) && this.authenticatorClass.equals(another.authenticatorClass) && this.adminSites.equals(another.adminSites) && this.accessLogPath.equals(another.accessLogPath) && this.accessLogPattern.equals(another.accessLogPattern) && this.httpIoThreads.equals(another.httpIoThreads) && this.httpWorkerThreads.equals(another.httpWorkerThreads) && this.httpNoRequestTimeout.equals(another.httpNoRequestTimeout) && this.httpRequestParseTimeout.equals(another.httpRequestParseTimeout) && this.httpIoIdleTimeout.equals(another.httpIoIdleTimeout) && this.jmxPort.equals(another.jmxPort) && this.enableHttp2 == another.enableHttp2;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.serverRuntimeInfoPath.hashCode();
        h = h * 17 + this.port;
        h = h * 17 + this.bind.hashCode();
        h = h * 17 + this.adminPort.hashCode();
        h = h * 17 + this.adminBind.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.executorEnabled);
        h = h * 17 + Booleans.hashCode((boolean)this.enableSwagger);
        h = h * 17 + this.headers.hashCode();
        h = h * 17 + this.systemConfig.hashCode();
        h = h * 17 + this.environment.hashCode();
        h = h * 17 + this.authenticatorClass.hashCode();
        h = h * 17 + this.adminSites.hashCode();
        h = h * 17 + this.accessLogPath.hashCode();
        h = h * 17 + this.accessLogPattern.hashCode();
        h = h * 17 + this.httpIoThreads.hashCode();
        h = h * 17 + this.httpWorkerThreads.hashCode();
        h = h * 17 + this.httpNoRequestTimeout.hashCode();
        h = h * 17 + this.httpRequestParseTimeout.hashCode();
        h = h * 17 + this.httpIoIdleTimeout.hashCode();
        h = h * 17 + this.jmxPort.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.enableHttp2);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerConfig").omitNullValues().add("serverRuntimeInfoPath", this.serverRuntimeInfoPath.orNull()).add("port", this.port).add("bind", (Object)this.bind).add("adminPort", this.adminPort.orNull()).add("adminBind", this.adminBind.orNull()).add("executorEnabled", this.executorEnabled).add("enableSwagger", this.enableSwagger).add("headers", this.headers).add("systemConfig", (Object)this.systemConfig).add("environment", this.environment).add("authenticatorClass", (Object)this.authenticatorClass).add("adminSites", this.adminSites).add("accessLogPath", this.accessLogPath.orNull()).add("accessLogPattern", (Object)this.accessLogPattern).add("httpIoThreads", this.httpIoThreads.orNull()).add("httpWorkerThreads", this.httpWorkerThreads.orNull()).add("httpNoRequestTimeout", this.httpNoRequestTimeout.orNull()).add("httpRequestParseTimeout", this.httpRequestParseTimeout.orNull()).add("httpIoIdleTimeout", this.httpIoIdleTimeout.orNull()).add("jmxPort", this.jmxPort.orNull()).add("enableHttp2", this.enableHttp2).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServerConfig fromJson(Json json) {
        Builder builder = ImmutableServerConfig.builder();
        if (json.serverRuntimeInfoPath != null) {
            builder.serverRuntimeInfoPath(json.serverRuntimeInfoPath);
        }
        if (json.portIsSet) {
            builder.port(json.port);
        }
        if (json.bind != null) {
            builder.bind(json.bind);
        }
        if (json.adminPort != null) {
            builder.adminPort(json.adminPort);
        }
        if (json.adminBind != null) {
            builder.adminBind(json.adminBind);
        }
        if (json.executorEnabledIsSet) {
            builder.executorEnabled(json.executorEnabled);
        }
        if (json.enableSwaggerIsSet) {
            builder.enableSwagger(json.enableSwagger);
        }
        if (json.headers != null) {
            builder.putAllHeaders(json.headers);
        }
        if (json.systemConfig != null) {
            builder.systemConfig(json.systemConfig);
        }
        if (json.environment != null) {
            builder.putAllEnvironment(json.environment);
        }
        if (json.authenticatorClass != null) {
            builder.authenticatorClass(json.authenticatorClass);
        }
        if (json.adminSites != null) {
            builder.addAllAdminSites(json.adminSites);
        }
        if (json.accessLogPath != null) {
            builder.accessLogPath(json.accessLogPath);
        }
        if (json.accessLogPattern != null) {
            builder.accessLogPattern(json.accessLogPattern);
        }
        if (json.httpIoThreads != null) {
            builder.httpIoThreads(json.httpIoThreads);
        }
        if (json.httpWorkerThreads != null) {
            builder.httpWorkerThreads(json.httpWorkerThreads);
        }
        if (json.httpNoRequestTimeout != null) {
            builder.httpNoRequestTimeout(json.httpNoRequestTimeout);
        }
        if (json.httpRequestParseTimeout != null) {
            builder.httpRequestParseTimeout(json.httpRequestParseTimeout);
        }
        if (json.httpIoIdleTimeout != null) {
            builder.httpIoIdleTimeout(json.httpIoIdleTimeout);
        }
        if (json.jmxPort != null) {
            builder.jmxPort(json.jmxPort);
        }
        if (json.enableHttp2IsSet) {
            builder.enableHttp2(json.enableHttp2);
        }
        return builder.build();
    }

    public static ImmutableServerConfig copyOf(ServerConfig instance) {
        if (instance instanceof ImmutableServerConfig) {
            return (ImmutableServerConfig)instance;
        }
        return ImmutableServerConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PORT = 1L;
        private static final long INIT_BIT_BIND = 2L;
        private static final long INIT_BIT_EXECUTOR_ENABLED = 4L;
        private static final long INIT_BIT_ENABLE_SWAGGER = 8L;
        private static final long INIT_BIT_SYSTEM_CONFIG = 16L;
        private static final long INIT_BIT_AUTHENTICATOR_CLASS = 32L;
        private static final long INIT_BIT_ACCESS_LOG_PATTERN = 64L;
        private static final long INIT_BIT_ENABLE_HTTP2 = 128L;
        private long initBits = 255L;
        private Optional<String> serverRuntimeInfoPath = Optional.absent();
        private int port;
        @Nullable
        private String bind;
        private Optional<Integer> adminPort = Optional.absent();
        private Optional<String> adminBind = Optional.absent();
        private boolean executorEnabled;
        private boolean enableSwagger;
        private ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();
        @Nullable
        private ConfigElement systemConfig;
        private ImmutableMap.Builder<String, String> environment = ImmutableMap.builder();
        @Nullable
        private String authenticatorClass;
        private ImmutableSet.Builder<Integer> adminSites = ImmutableSet.builder();
        private Optional<String> accessLogPath = Optional.absent();
        @Nullable
        private String accessLogPattern;
        private Optional<Integer> httpIoThreads = Optional.absent();
        private Optional<Integer> httpWorkerThreads = Optional.absent();
        private Optional<Integer> httpNoRequestTimeout = Optional.absent();
        private Optional<Integer> httpRequestParseTimeout = Optional.absent();
        private Optional<Integer> httpIoIdleTimeout = Optional.absent();
        private Optional<Integer> jmxPort = Optional.absent();
        private boolean enableHttp2;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UndertowServerConfig instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ServerConfig instance;
            if (object instanceof ServerConfig) {
                instance = (ServerConfig)object;
                this.putAllHeaders(instance.getHeaders());
                this.putAllEnvironment(instance.getEnvironment());
                this.bind(instance.getBind());
                Optional<String> serverRuntimeInfoPathOptional = instance.getServerRuntimeInfoPath();
                if (serverRuntimeInfoPathOptional.isPresent()) {
                    this.serverRuntimeInfoPath(serverRuntimeInfoPathOptional);
                }
                this.port(instance.getPort());
                this.addAllAdminSites(instance.getAdminSites());
                Optional<String> adminBindOptional = instance.getAdminBind();
                if (adminBindOptional.isPresent()) {
                    this.adminBind(adminBindOptional);
                }
                this.enableSwagger(instance.getEnableSwagger());
                this.systemConfig(instance.getSystemConfig());
                Optional<Integer> adminPortOptional = instance.getAdminPort();
                if (adminPortOptional.isPresent()) {
                    this.adminPort(adminPortOptional);
                }
                this.executorEnabled(instance.getExecutorEnabled());
                this.authenticatorClass(instance.getAuthenticatorClass());
            }
            if (object instanceof UndertowServerConfig) {
                Optional httpNoRequestTimeoutOptional;
                Optional accessLogPathOptional;
                Optional httpWorkerThreadsOptional;
                Optional jmxPortOptional;
                instance = (UndertowServerConfig)object;
                Optional httpIoThreadsOptional = instance.getHttpIoThreads();
                if (httpIoThreadsOptional.isPresent()) {
                    this.httpIoThreads((Optional<Integer>)httpIoThreadsOptional);
                }
                if ((jmxPortOptional = instance.getJmxPort()).isPresent()) {
                    this.jmxPort((Optional<Integer>)jmxPortOptional);
                }
                this.accessLogPattern(instance.getAccessLogPattern());
                Optional httpRequestParseTimeoutOptional = instance.getHttpRequestParseTimeout();
                if (httpRequestParseTimeoutOptional.isPresent()) {
                    this.httpRequestParseTimeout((Optional<Integer>)httpRequestParseTimeoutOptional);
                }
                if ((httpWorkerThreadsOptional = instance.getHttpWorkerThreads()).isPresent()) {
                    this.httpWorkerThreads((Optional<Integer>)httpWorkerThreadsOptional);
                }
                this.enableHttp2(instance.getEnableHttp2());
                Optional httpIoIdleTimeoutOptional = instance.getHttpIoIdleTimeout();
                if (httpIoIdleTimeoutOptional.isPresent()) {
                    this.httpIoIdleTimeout((Optional<Integer>)httpIoIdleTimeoutOptional);
                }
                if ((accessLogPathOptional = instance.getAccessLogPath()).isPresent()) {
                    this.accessLogPath((Optional<String>)accessLogPathOptional);
                }
                if ((httpNoRequestTimeoutOptional = instance.getHttpNoRequestTimeout()).isPresent()) {
                    this.httpNoRequestTimeout((Optional<Integer>)httpNoRequestTimeoutOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder serverRuntimeInfoPath(String serverRuntimeInfoPath) {
            this.serverRuntimeInfoPath = Optional.of((Object)serverRuntimeInfoPath);
            return this;
        }

        @JsonProperty(value="serverRuntimeInfoPath")
        @CanIgnoreReturnValue
        public final Builder serverRuntimeInfoPath(Optional<String> serverRuntimeInfoPath) {
            this.serverRuntimeInfoPath = (Optional)Preconditions.checkNotNull(serverRuntimeInfoPath, (Object)"serverRuntimeInfoPath");
            return this;
        }

        @JsonProperty(value="port")
        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="bind")
        @CanIgnoreReturnValue
        public final Builder bind(String bind) {
            this.bind = (String)Preconditions.checkNotNull((Object)bind, (Object)"bind");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder adminPort(int adminPort) {
            this.adminPort = Optional.of((Object)adminPort);
            return this;
        }

        @JsonProperty(value="adminPort")
        @CanIgnoreReturnValue
        public final Builder adminPort(Optional<Integer> adminPort) {
            this.adminPort = (Optional)Preconditions.checkNotNull(adminPort, (Object)"adminPort");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder adminBind(String adminBind) {
            this.adminBind = Optional.of((Object)adminBind);
            return this;
        }

        @JsonProperty(value="adminBind")
        @CanIgnoreReturnValue
        public final Builder adminBind(Optional<String> adminBind) {
            this.adminBind = (Optional)Preconditions.checkNotNull(adminBind, (Object)"adminBind");
            return this;
        }

        @JsonProperty(value="executorEnabled")
        @CanIgnoreReturnValue
        public final Builder executorEnabled(boolean executorEnabled) {
            this.executorEnabled = executorEnabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="enableSwagger")
        @CanIgnoreReturnValue
        public final Builder enableSwagger(boolean enableSwagger) {
            this.enableSwagger = enableSwagger;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(String key, String value) {
            this.headers.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(Map.Entry<String, ? extends String> entry) {
            this.headers.put(entry);
            return this;
        }

        @JsonProperty(value="headers")
        @CanIgnoreReturnValue
        public final Builder headers(Map<String, ? extends String> headers) {
            this.headers = ImmutableMap.builder();
            return this.putAllHeaders(headers);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHeaders(Map<String, ? extends String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        @JsonProperty(value="systemConfig")
        @CanIgnoreReturnValue
        public final Builder systemConfig(ConfigElement systemConfig) {
            this.systemConfig = (ConfigElement)Preconditions.checkNotNull((Object)systemConfig, (Object)"systemConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnvironment(String key, String value) {
            this.environment.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnvironment(Map.Entry<String, ? extends String> entry) {
            this.environment.put(entry);
            return this;
        }

        @JsonProperty(value="environment")
        @CanIgnoreReturnValue
        public final Builder environment(Map<String, ? extends String> environment) {
            this.environment = ImmutableMap.builder();
            return this.putAllEnvironment(environment);
        }

        @CanIgnoreReturnValue
        public final Builder putAllEnvironment(Map<String, ? extends String> environment) {
            this.environment.putAll(environment);
            return this;
        }

        @JsonProperty(value="authenticatorClass")
        @CanIgnoreReturnValue
        public final Builder authenticatorClass(String authenticatorClass) {
            this.authenticatorClass = (String)Preconditions.checkNotNull((Object)authenticatorClass, (Object)"authenticatorClass");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdminSites(int element) {
            this.adminSites.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdminSites(int ... elements) {
            this.adminSites.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @JsonProperty(value="adminSites")
        @CanIgnoreReturnValue
        public final Builder adminSites(Iterable<Integer> elements) {
            this.adminSites = ImmutableSet.builder();
            return this.addAllAdminSites(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdminSites(Iterable<Integer> elements) {
            this.adminSites.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessLogPath(String accessLogPath) {
            this.accessLogPath = Optional.of((Object)accessLogPath);
            return this;
        }

        @JsonProperty(value="accessLogPath")
        @CanIgnoreReturnValue
        public final Builder accessLogPath(Optional<String> accessLogPath) {
            this.accessLogPath = (Optional)Preconditions.checkNotNull(accessLogPath, (Object)"accessLogPath");
            return this;
        }

        @JsonProperty(value="accessLogPattern")
        @CanIgnoreReturnValue
        public final Builder accessLogPattern(String accessLogPattern) {
            this.accessLogPattern = (String)Preconditions.checkNotNull((Object)accessLogPattern, (Object)"accessLogPattern");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpIoThreads(int httpIoThreads) {
            this.httpIoThreads = Optional.of((Object)httpIoThreads);
            return this;
        }

        @JsonProperty(value="httpIoThreads")
        @CanIgnoreReturnValue
        public final Builder httpIoThreads(Optional<Integer> httpIoThreads) {
            this.httpIoThreads = (Optional)Preconditions.checkNotNull(httpIoThreads, (Object)"httpIoThreads");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpWorkerThreads(int httpWorkerThreads) {
            this.httpWorkerThreads = Optional.of((Object)httpWorkerThreads);
            return this;
        }

        @JsonProperty(value="httpWorkerThreads")
        @CanIgnoreReturnValue
        public final Builder httpWorkerThreads(Optional<Integer> httpWorkerThreads) {
            this.httpWorkerThreads = (Optional)Preconditions.checkNotNull(httpWorkerThreads, (Object)"httpWorkerThreads");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpNoRequestTimeout(int httpNoRequestTimeout) {
            this.httpNoRequestTimeout = Optional.of((Object)httpNoRequestTimeout);
            return this;
        }

        @JsonProperty(value="httpNoRequestTimeout")
        @CanIgnoreReturnValue
        public final Builder httpNoRequestTimeout(Optional<Integer> httpNoRequestTimeout) {
            this.httpNoRequestTimeout = (Optional)Preconditions.checkNotNull(httpNoRequestTimeout, (Object)"httpNoRequestTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpRequestParseTimeout(int httpRequestParseTimeout) {
            this.httpRequestParseTimeout = Optional.of((Object)httpRequestParseTimeout);
            return this;
        }

        @JsonProperty(value="httpRequestParseTimeout")
        @CanIgnoreReturnValue
        public final Builder httpRequestParseTimeout(Optional<Integer> httpRequestParseTimeout) {
            this.httpRequestParseTimeout = (Optional)Preconditions.checkNotNull(httpRequestParseTimeout, (Object)"httpRequestParseTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpIoIdleTimeout(int httpIoIdleTimeout) {
            this.httpIoIdleTimeout = Optional.of((Object)httpIoIdleTimeout);
            return this;
        }

        @JsonProperty(value="httpIoIdleTimeout")
        @CanIgnoreReturnValue
        public final Builder httpIoIdleTimeout(Optional<Integer> httpIoIdleTimeout) {
            this.httpIoIdleTimeout = (Optional)Preconditions.checkNotNull(httpIoIdleTimeout, (Object)"httpIoIdleTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jmxPort(int jmxPort) {
            this.jmxPort = Optional.of((Object)jmxPort);
            return this;
        }

        @JsonProperty(value="jmxPort")
        @CanIgnoreReturnValue
        public final Builder jmxPort(Optional<Integer> jmxPort) {
            this.jmxPort = (Optional)Preconditions.checkNotNull(jmxPort, (Object)"jmxPort");
            return this;
        }

        @JsonProperty(value="enableHttp2")
        @CanIgnoreReturnValue
        public final Builder enableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableServerConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServerConfig(this.serverRuntimeInfoPath, this.port, this.bind, this.adminPort, this.adminBind, this.executorEnabled, this.enableSwagger, this.headers.build(), this.systemConfig, this.environment.build(), this.authenticatorClass, this.adminSites.build(), this.accessLogPath, this.accessLogPattern, this.httpIoThreads, this.httpWorkerThreads, this.httpNoRequestTimeout, this.httpRequestParseTimeout, this.httpIoIdleTimeout, this.jmxPort, this.enableHttp2);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bind");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("executorEnabled");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("enableSwagger");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("systemConfig");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("authenticatorClass");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("accessLogPattern");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("enableHttp2");
            }
            return "Cannot build ServerConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ServerConfig {
        Optional<String> serverRuntimeInfoPath = Optional.absent();
        int port;
        boolean portIsSet;
        @Nullable
        String bind;
        Optional<Integer> adminPort = Optional.absent();
        Optional<String> adminBind = Optional.absent();
        boolean executorEnabled;
        boolean executorEnabledIsSet;
        boolean enableSwagger;
        boolean enableSwaggerIsSet;
        @Nullable
        Map<String, String> headers;
        @Nullable
        ConfigElement systemConfig;
        @Nullable
        Map<String, String> environment;
        @Nullable
        String authenticatorClass;
        Set<Integer> adminSites = ImmutableSet.of();
        Optional<String> accessLogPath = Optional.absent();
        @Nullable
        String accessLogPattern;
        Optional<Integer> httpIoThreads = Optional.absent();
        Optional<Integer> httpWorkerThreads = Optional.absent();
        Optional<Integer> httpNoRequestTimeout = Optional.absent();
        Optional<Integer> httpRequestParseTimeout = Optional.absent();
        Optional<Integer> httpIoIdleTimeout = Optional.absent();
        Optional<Integer> jmxPort = Optional.absent();
        boolean enableHttp2;
        boolean enableHttp2IsSet;

        Json() {
        }

        @JsonProperty(value="serverRuntimeInfoPath")
        public void setServerRuntimeInfoPath(Optional<String> serverRuntimeInfoPath) {
            this.serverRuntimeInfoPath = serverRuntimeInfoPath;
        }

        @JsonProperty(value="port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @JsonProperty(value="bind")
        public void setBind(String bind) {
            this.bind = bind;
        }

        @JsonProperty(value="adminPort")
        public void setAdminPort(Optional<Integer> adminPort) {
            this.adminPort = adminPort;
        }

        @JsonProperty(value="adminBind")
        public void setAdminBind(Optional<String> adminBind) {
            this.adminBind = adminBind;
        }

        @JsonProperty(value="executorEnabled")
        public void setExecutorEnabled(boolean executorEnabled) {
            this.executorEnabled = executorEnabled;
            this.executorEnabledIsSet = true;
        }

        @JsonProperty(value="enableSwagger")
        public void setEnableSwagger(boolean enableSwagger) {
            this.enableSwagger = enableSwagger;
            this.enableSwaggerIsSet = true;
        }

        @JsonProperty(value="headers")
        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        @JsonProperty(value="systemConfig")
        public void setSystemConfig(ConfigElement systemConfig) {
            this.systemConfig = systemConfig;
        }

        @JsonProperty(value="environment")
        public void setEnvironment(Map<String, String> environment) {
            this.environment = environment;
        }

        @JsonProperty(value="authenticatorClass")
        public void setAuthenticatorClass(String authenticatorClass) {
            this.authenticatorClass = authenticatorClass;
        }

        @JsonProperty(value="adminSites")
        public void setAdminSites(Set<Integer> adminSites) {
            this.adminSites = adminSites;
        }

        @JsonProperty(value="accessLogPath")
        public void setAccessLogPath(Optional<String> accessLogPath) {
            this.accessLogPath = accessLogPath;
        }

        @JsonProperty(value="accessLogPattern")
        public void setAccessLogPattern(String accessLogPattern) {
            this.accessLogPattern = accessLogPattern;
        }

        @JsonProperty(value="httpIoThreads")
        public void setHttpIoThreads(Optional<Integer> httpIoThreads) {
            this.httpIoThreads = httpIoThreads;
        }

        @JsonProperty(value="httpWorkerThreads")
        public void setHttpWorkerThreads(Optional<Integer> httpWorkerThreads) {
            this.httpWorkerThreads = httpWorkerThreads;
        }

        @JsonProperty(value="httpNoRequestTimeout")
        public void setHttpNoRequestTimeout(Optional<Integer> httpNoRequestTimeout) {
            this.httpNoRequestTimeout = httpNoRequestTimeout;
        }

        @JsonProperty(value="httpRequestParseTimeout")
        public void setHttpRequestParseTimeout(Optional<Integer> httpRequestParseTimeout) {
            this.httpRequestParseTimeout = httpRequestParseTimeout;
        }

        @JsonProperty(value="httpIoIdleTimeout")
        public void setHttpIoIdleTimeout(Optional<Integer> httpIoIdleTimeout) {
            this.httpIoIdleTimeout = httpIoIdleTimeout;
        }

        @JsonProperty(value="jmxPort")
        public void setJmxPort(Optional<Integer> jmxPort) {
            this.jmxPort = jmxPort;
        }

        @JsonProperty(value="enableHttp2")
        public void setEnableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            this.enableHttp2IsSet = true;
        }

        @Override
        public Optional<String> getServerRuntimeInfoPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBind() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getAdminPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAdminBind() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getExecutorEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getEnableSwagger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getHeaders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigElement getSystemConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getEnvironment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthenticatorClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Integer> getAdminSites() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> getAccessLogPath() {
            throw new UnsupportedOperationException();
        }

        public String getAccessLogPattern() {
            throw new UnsupportedOperationException();
        }

        public Optional<Integer> getHttpIoThreads() {
            throw new UnsupportedOperationException();
        }

        public Optional<Integer> getHttpWorkerThreads() {
            throw new UnsupportedOperationException();
        }

        public Optional<Integer> getHttpNoRequestTimeout() {
            throw new UnsupportedOperationException();
        }

        public Optional<Integer> getHttpRequestParseTimeout() {
            throw new UnsupportedOperationException();
        }

        public Optional<Integer> getHttpIoIdleTimeout() {
            throw new UnsupportedOperationException();
        }

        public Optional<Integer> getJmxPort() {
            throw new UnsupportedOperationException();
        }

        public boolean getEnableHttp2() {
            throw new UnsupportedOperationException();
        }
    }
}

