/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import io.digdag.client.Version;
import io.digdag.client.config.Config;
import io.digdag.core.DigdagEmbed;
import io.digdag.core.ErrorReporter;
import io.digdag.core.agent.ExtractArchiveWorkspaceManager;
import io.digdag.core.agent.WorkspaceManager;
import io.digdag.core.plugin.PluginSet;
import io.digdag.guice.rs.GuiceRsServerControl;
import io.digdag.guice.rs.server.undertow.UndertowServer;
import io.digdag.guice.rs.server.undertow.UndertowServerConfig;
import io.digdag.guice.rs.server.undertow.UndertowServerControl;
import io.digdag.server.ClientVersionChecker;
import io.digdag.server.JmxErrorReporter;
import io.digdag.server.ServerConfig;
import io.digdag.server.ServerModule;
import io.digdag.server.ServerRuntimeInfoWriter;
import io.digdag.server.WorkflowExecutionTimeoutEnforcer;
import io.digdag.server.WorkflowExecutorLoop;
import javax.servlet.ServletException;
import org.embulk.guice.Bootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.guice.ExportBinder;

public class ServerBootstrap
implements io.digdag.guice.rs.server.ServerBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(ServerBootstrap.class);
    protected final Version version;
    protected final ServerConfig serverConfig;
    private final PluginSet systemPlugins;

    public ServerBootstrap(Version version, ServerConfig serverConfig, PluginSet systemPlugins) {
        this.version = version;
        this.serverConfig = serverConfig;
        this.systemPlugins = systemPlugins;
    }

    public ServerBootstrap(Version version, ServerConfig serverConfig) {
        this(version, serverConfig, PluginSet.empty());
    }

    public Bootstrap bootstrap() {
        return this.digdagBootstrap().build();
    }

    protected DigdagEmbed.Bootstrap digdagBootstrap() {
        return new DigdagEmbed.Bootstrap().setEnvironment(this.serverConfig.getEnvironment()).setSystemConfig(this.serverConfig.getSystemConfig()).setSystemPlugins(this.systemPlugins).overrideModulesWith(new Module[]{binder -> {
            binder.bind(WorkspaceManager.class).to(ExtractArchiveWorkspaceManager.class).in(Scopes.SINGLETON);
            binder.bind(Version.class).toInstance((Object)this.version);
        }}).addModules(new Module[]{binder -> {
            binder.bind(ServerRuntimeInfoWriter.class).asEagerSingleton();
            binder.bind(ServerConfig.class).toInstance((Object)this.serverConfig);
            binder.bind(WorkflowExecutorLoop.class).asEagerSingleton();
            binder.bind(WorkflowExecutionTimeoutEnforcer.class).asEagerSingleton();
            binder.bind(ClientVersionChecker.class).toProvider(ClientVersionCheckerProvider.class);
            binder.bind(ErrorReporter.class).to(JmxErrorReporter.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(ErrorReporter.class).withGeneratedName();
        }}).addModules(new Module[]{new ServerModule(this.serverConfig)});
    }

    public static GuiceRsServerControl start(ServerBootstrap bootstrap) throws ServletException {
        UndertowServerControl control = UndertowServer.start((UndertowServerConfig)bootstrap.serverConfig, (io.digdag.guice.rs.server.ServerBootstrap)bootstrap);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            control.stop();
            control.destroy();
            logger.info("Shutdown completed");
        }, "shutdown"));
        return control;
    }

    private static class ClientVersionCheckerProvider
    implements Provider<ClientVersionChecker> {
        private final Config systemConfig;

        @Inject
        public ClientVersionCheckerProvider(Config systemConfig) {
            this.systemConfig = systemConfig;
        }

        public ClientVersionChecker get() {
            return ClientVersionChecker.fromSystemConfig(this.systemConfig);
        }
    }
}

