/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.digdag.core.BackgroundExecutor;
import io.digdag.core.ErrorReporter;
import io.digdag.core.workflow.WorkflowExecutor;
import io.digdag.server.ServerConfig;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecutorLoop
implements BackgroundExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowExecutorLoop.class);
    private final Supplier<Thread> threadFactory;
    private final WorkflowExecutor workflowExecutor;
    private volatile Thread thread = null;
    private volatile boolean stop = false;
    @Inject(optional=true)
    private ErrorReporter errorReporter = ErrorReporter.empty();

    @Inject
    public WorkflowExecutorLoop(ServerConfig serverConfig, WorkflowExecutor workflowExecutor) {
        this.threadFactory = serverConfig.getExecutorEnabled() ? () -> new ThreadFactoryBuilder().setDaemon(true).setNameFormat("workflow-executor-%d").build().newThread(this::run) : null;
        this.workflowExecutor = workflowExecutor;
    }

    private void run() {
        while (!this.stop) {
            try {
                this.workflowExecutor.runWhile(() -> !this.stop);
            }
            catch (Throwable t) {
                logger.error("Uncaught error during executing workflow state machine. Ignoring. Loop will be retried.", t);
                this.errorReporter.reportUncaughtError(t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @PostConstruct
    public synchronized void start() {
        if (this.threadFactory != null && this.thread == null) {
            Thread thread = this.threadFactory.get();
            thread.start();
            this.thread = thread;
        }
    }

    @PreDestroy
    public synchronized void shutdown() throws InterruptedException {
        this.startShutdown();
        if (this.thread != null) {
            this.thread.join(100L);
            if (this.thread.isAlive()) {
                logger.info("Waiting for completion of workflow executor loop...");
                do {
                    this.workflowExecutor.noticeRunWhileConditionChange();
                    this.thread.join(1000L);
                } while (this.thread.isAlive());
            }
            this.thread = null;
        }
    }

    public void eagerShutdown() throws InterruptedException {
        this.startShutdown();
    }

    private void startShutdown() {
        if (!this.stop) {
            this.stop = true;
            logger.info("Shutting down workflow executor loop");
            this.workflowExecutor.noticeRunWhileConditionChange();
        }
    }
}

