/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.client.api.RestSessionAttempt;
import io.digdag.client.api.RestSessionAttemptCollection;
import io.digdag.client.api.RestSessionAttemptRequest;
import io.digdag.client.api.RestTaskCollection;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.schedule.SchedulerManager;
import io.digdag.core.session.ArchivedTask;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.core.session.TaskRelation;
import io.digdag.core.session.TaskStateCode;
import io.digdag.core.workflow.AttemptBuilder;
import io.digdag.core.workflow.AttemptLimitExceededException;
import io.digdag.core.workflow.AttemptRequest;
import io.digdag.core.workflow.SessionAttemptConflictException;
import io.digdag.core.workflow.TaskLimitExceededException;
import io.digdag.core.workflow.TaskMatchPattern;
import io.digdag.core.workflow.TaskTree;
import io.digdag.core.workflow.WorkflowExecutor;
import io.digdag.server.rs.AuthenticatedResource;
import io.digdag.server.rs.QueryParamValidator;
import io.digdag.server.rs.RestModels;
import io.digdag.spi.ScheduleTime;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(value="Attempt")
@Path(value="/")
@Produces(value={"application/json"})
public class AttemptResource
extends AuthenticatedResource {
    private final ProjectStoreManager rm;
    private final SessionStoreManager sm;
    private final SchedulerManager srm;
    private final TransactionManager tm;
    private final AttemptBuilder attemptBuilder;
    private final WorkflowExecutor executor;
    private final ConfigFactory cf;
    private static final int DEFAULT_ATTEMPTS_PAGE_SIZE = 100;
    private static int MAX_ATTEMPTS_PAGE_SIZE;

    @Inject
    public AttemptResource(ProjectStoreManager rm, SessionStoreManager sm, SchedulerManager srm, TransactionManager tm, AttemptBuilder attemptBuilder, WorkflowExecutor executor, ConfigFactory cf, Config systemConfig) {
        this.rm = rm;
        this.sm = sm;
        this.srm = srm;
        this.tm = tm;
        this.attemptBuilder = attemptBuilder;
        this.executor = executor;
        this.cf = cf;
        MAX_ATTEMPTS_PAGE_SIZE = (Integer)systemConfig.get("api.max_attempts_page_size", Integer.class, (Object)100);
    }

    @GET
    @Path(value="/api/attempts")
    @ApiOperation(value="List attempts with filters")
    public RestSessionAttemptCollection getAttempts(@ApiParam(value="exact matching filter on project name", required=false) @QueryParam(value="project") String projName, @ApiParam(value="exact matching filter on workflow name", required=false) @QueryParam(value="workflow") String wfName, @ApiParam(value="list more than 1 attempts per session", required=false) @QueryParam(value="include_retried") boolean includeRetried, @ApiParam(value="list attempts whose id is grater than this id for pagination", required=false) @QueryParam(value="last_id") Long lastId, @ApiParam(value="number of attempts to return", required=false) @QueryParam(value="page_size") Integer pageSize) throws ResourceNotFoundException {
        int validPageSize = QueryParamValidator.validatePageSize((Optional<Integer>)Optional.fromNullable((Object)pageSize), MAX_ATTEMPTS_PAGE_SIZE, 100);
        return (RestSessionAttemptCollection)this.tm.begin(() -> {
            List attempts;
            ProjectStore rs = this.rm.getProjectStore(this.getSiteId());
            SessionStore ss = this.sm.getSessionStore(this.getSiteId());
            if (projName != null) {
                StoredProject proj = rs.getProjectByName(projName);
                attempts = wfName != null ? ss.getAttemptsOfWorkflow(includeRetried, proj.getId(), wfName, validPageSize, Optional.fromNullable((Object)lastId)) : ss.getAttemptsOfProject(includeRetried, proj.getId(), validPageSize, Optional.fromNullable((Object)lastId));
            } else {
                attempts = ss.getAttempts(includeRetried, validPageSize, Optional.fromNullable((Object)lastId));
            }
            return RestModels.attemptCollection(this.rm.getProjectStore(this.getSiteId()), attempts);
        }, ResourceNotFoundException.class);
    }

    @GET
    @Path(value="/api/attempts/{id}")
    @ApiOperation(value="Get an attempt")
    public RestSessionAttempt getAttempt(@ApiParam(value="attempt id", required=true) @PathParam(value="id") long id) throws ResourceNotFoundException {
        return (RestSessionAttempt)this.tm.begin(() -> {
            StoredSessionAttemptWithSession attempt = this.sm.getSessionStore(this.getSiteId()).getAttemptById(id);
            StoredProject proj = this.rm.getProjectStore(this.getSiteId()).getProjectById(attempt.getSession().getProjectId());
            return RestModels.attempt(attempt, proj.getName());
        }, ResourceNotFoundException.class);
    }

    @GET
    @Path(value="/api/attempts/{id}/retries")
    @ApiOperation(value="List attempts of a session of a given attempt")
    public RestSessionAttemptCollection getAttemptRetries(@ApiParam(value="attempt id", required=true) @PathParam(value="id") long id) throws ResourceNotFoundException {
        return (RestSessionAttemptCollection)this.tm.begin(() -> {
            List attempts = this.sm.getSessionStore(this.getSiteId()).getOtherAttempts(id);
            return RestModels.attemptCollection(this.rm.getProjectStore(this.getSiteId()), attempts);
        }, ResourceNotFoundException.class);
    }

    @GET
    @Path(value="/api/attempts/{id}/tasks")
    @ApiOperation(value="List tasks of an attempt")
    public RestTaskCollection getTasks(@ApiParam(value="attempt id", required=true) @PathParam(value="id") long id) {
        return (RestTaskCollection)this.tm.begin(() -> {
            List tasks = this.sm.getSessionStore(this.getSiteId()).getTasksOfAttempt(id);
            return RestModels.taskCollection(tasks);
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/api/attempts")
    @ApiOperation(value="Start a workflow execution as a new session or a new attempt of an existing session")
    public Response startAttempt(RestSessionAttemptRequest request) throws AttemptLimitExceededException, TaskLimitExceededException, ResourceNotFoundException {
        return (Response)this.tm.begin(() -> {
            ProjectStore rs = this.rm.getProjectStore(this.getSiteId());
            StoredWorkflowDefinitionWithProject def = rs.getWorkflowDefinitionById(RestModels.parseWorkflowId(request.getWorkflowId()));
            Optional resumingAttemptId = request.getResume().transform(r -> RestModels.parseAttemptId(r.getAttemptId()));
            List resumingTasks = (List)request.getResume().transform(r -> this.collectResumingTasks((RestSessionAttemptRequest.Resume)r)).or((Object)ImmutableList.of());
            AttemptRequest ar = this.attemptBuilder.buildFromStoredWorkflow(def, request.getParams(), ScheduleTime.runNow((Instant)request.getSessionTime()), request.getRetryAttemptName(), resumingAttemptId, resumingTasks, Optional.absent());
            try {
                StoredSessionAttemptWithSession attempt = this.executor.submitWorkflow(this.getSiteId(), ar, (WorkflowDefinition)def);
                RestSessionAttempt res = RestModels.attempt(attempt, def.getProject().getName());
                return Response.ok((Object)res).build();
            }
            catch (SessionAttemptConflictException ex) {
                StoredSessionAttemptWithSession conflicted = ex.getConflictedSession();
                RestSessionAttempt res = RestModels.attempt(conflicted, def.getProject().getName());
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)res).build();
            }
        }, AttemptLimitExceededException.class, ResourceNotFoundException.class, TaskLimitExceededException.class);
    }

    private List<Long> collectResumingTasks(RestSessionAttemptRequest.Resume resume) {
        switch (resume.getMode()) {
            case FAILED: {
                return this.collectResumingTasksForResumeFailedMode(RestModels.parseAttemptId(((RestSessionAttemptRequest.ResumeFailed)resume).getAttemptId()));
            }
            case FROM: {
                return this.collectResumingTasksForResumeFromMode(RestModels.parseAttemptId(((RestSessionAttemptRequest.ResumeFrom)resume).getAttemptId()), ((RestSessionAttemptRequest.ResumeFrom)resume).getFromTaskNamePattern());
            }
        }
        throw new IllegalArgumentException("Unknown resuming mode: " + resume.getMode());
    }

    private List<Long> collectResumingTasksForResumeFailedMode(long attemptId) {
        List tasks = this.sm.getSessionStore(this.getSiteId()).getTasksOfAttempt(attemptId);
        List successTasks = tasks.stream().filter(task -> task.getState() == TaskStateCode.SUCCESS).map(task -> {
            if (!task.getParentId().isPresent()) {
                throw new IllegalArgumentException("Resuming successfully completed attempts is not supported");
            }
            return task.getId();
        }).collect(Collectors.toList());
        return ImmutableList.copyOf(successTasks);
    }

    private List<Long> collectResumingTasksForResumeFromMode(long attemptId, String fromTaskPattern) {
        List tasks = this.sm.getSessionStore(this.getSiteId()).getTasksOfAttempt(attemptId);
        ArchivedTask fromTask = this.matchTaskPattern(fromTaskPattern, tasks);
        List relations = tasks.stream().map(t -> TaskRelation.of((long)t.getId(), (Optional)t.getParentId(), (List)t.getUpstreams())).collect(Collectors.toList());
        TaskTree taskTree = new TaskTree(relations);
        List before = taskTree.getRecursiveParentsUpstreamChildrenIdListFromFar(fromTask.getId());
        List parents = taskTree.getRecursiveParentIdListFromRoot(fromTask.getId());
        HashSet results = new HashSet(before);
        results.removeAll(parents);
        return ImmutableList.copyOf(results);
    }

    private ArchivedTask matchTaskPattern(String pattern, List<ArchivedTask> tasks) {
        try {
            return (ArchivedTask)TaskMatchPattern.compile((String)pattern).find(tasks.stream().collect(Collectors.toMap(t -> t.getFullName(), t -> t)));
        }
        catch (TaskMatchPattern.MultipleTaskMatchException | TaskMatchPattern.NoMatchException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/api/attempts/{id}/kill")
    @ApiOperation(value="Set a cancel-requested flag on a running attempt")
    public void killAttempt(@ApiParam(value="attempt id", required=true) @PathParam(value="id") long id) throws ResourceNotFoundException, ResourceConflictException {
        this.tm.begin(() -> {
            boolean updated = this.executor.killAttemptById(this.getSiteId(), id);
            if (!updated) {
                throw new ResourceConflictException("Session attempt already killed or finished");
            }
            return null;
        }, ResourceNotFoundException.class, ResourceConflictException.class);
    }
}

