/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import io.digdag.client.api.RestLogFileHandleCollection;
import io.digdag.client.api.RestLogFilePutResult;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.log.LogServerManager;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSessionAttemptWithSession;
import io.digdag.server.rs.AuthenticatedResource;
import io.digdag.server.rs.RestModels;
import io.digdag.spi.DirectUploadHandle;
import io.digdag.spi.LogFilePrefix;
import io.digdag.spi.LogServer;
import io.digdag.spi.StorageFileNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;

@Api(value="Log")
@Path(value="/")
@Produces(value={"application/json"})
public class LogResource
extends AuthenticatedResource {
    private final SessionStoreManager sm;
    private final TransactionManager tm;
    private final LogServer logServer;

    @Inject
    public LogResource(SessionStoreManager sm, TransactionManager tm, LogServerManager lm) {
        this.sm = sm;
        this.tm = tm;
        this.logServer = lm.getLogServer();
    }

    @PUT
    @Consumes(value={"application/gzip"})
    @Path(value="/api/logs/{attempt_id}/files")
    public RestLogFilePutResult putFile(@PathParam(value="attempt_id") long attemptId, @QueryParam(value="task") String taskName, @QueryParam(value="file_time") long unixFileTime, @QueryParam(value="node_id") String nodeId, InputStream body) throws ResourceNotFoundException, IOException {
        return (RestLogFilePutResult)this.tm.begin(() -> {
            LogFilePrefix prefix = this.getPrefix(attemptId);
            byte[] data = ByteStreams.toByteArray((InputStream)body);
            String fileName = this.logServer.putFile(prefix, taskName, Instant.ofEpochSecond(unixFileTime), nodeId, data);
            return RestLogFilePutResult.of((String)fileName);
        }, ResourceNotFoundException.class, IOException.class);
    }

    @GET
    @Path(value="/api/logs/{attempt_id}/upload_handle")
    public DirectUploadHandle getFileHandles(@PathParam(value="attempt_id") long attemptId, @QueryParam(value="task") String taskName, @QueryParam(value="file_time") long unixFileTime, @QueryParam(value="node_id") String nodeId) throws ResourceNotFoundException {
        return (DirectUploadHandle)this.tm.begin(() -> {
            LogFilePrefix prefix = this.getPrefix(attemptId);
            Optional handle = this.logServer.getDirectUploadHandle(prefix, taskName, Instant.ofEpochSecond(unixFileTime), nodeId);
            if (handle.isPresent()) {
                return (DirectUploadHandle)handle.get();
            }
            throw new ServerErrorException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).type("application/json").entity((Object)"{\"message\":\"Direct upload handle is not available for this log server implementation\",\"status\":501}").build());
        }, ResourceNotFoundException.class);
    }

    @GET
    @Path(value="/api/logs/{attempt_id}/files")
    @ApiOperation(value="List log files of an attempt with filters")
    public RestLogFileHandleCollection getFileHandles(@ApiParam(value="attempt id", required=true) @PathParam(value="attempt_id") long attemptId, @ApiParam(value="partial prefix match filter on task name", required=false) @QueryParam(value="task") String taskName) throws ResourceNotFoundException {
        return (RestLogFileHandleCollection)this.tm.begin(() -> {
            LogFilePrefix prefix = this.getPrefix(attemptId);
            List handles = this.logServer.getFileHandles(prefix, Optional.fromNullable((Object)taskName));
            return RestModels.logFileHandleCollection(handles);
        }, ResourceNotFoundException.class);
    }

    @GET
    @Produces(value={"application/gzip"})
    @Path(value="/api/logs/{attempt_id}/files/{file_name}")
    @ApiOperation(value="Download a log file")
    public byte[] getFile(@ApiParam(value="attempt id", required=true) @PathParam(value="attempt_id") long attemptId, @ApiParam(value="log file name", required=true) @PathParam(value="file_name") String fileName) throws ResourceNotFoundException, IOException, StorageFileNotFoundException {
        return (byte[])this.tm.begin(() -> {
            LogFilePrefix prefix = this.getPrefix(attemptId);
            return this.logServer.getFile(prefix, fileName);
        }, ResourceNotFoundException.class, IOException.class, StorageFileNotFoundException.class);
    }

    private LogFilePrefix getPrefix(long attemptId) throws ResourceNotFoundException {
        StoredSessionAttemptWithSession attempt = this.sm.getSessionStore(this.getSiteId()).getAttemptById(attemptId);
        return LogServerManager.logFilePrefixFromSessionAttempt((StoredSessionAttemptWithSession)attempt);
    }
}

