/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.digdag.client.api.LocalTimeOrInstant;
import io.digdag.client.api.RestSchedule;
import io.digdag.client.api.RestScheduleBackfillRequest;
import io.digdag.client.api.RestScheduleCollection;
import io.digdag.client.api.RestScheduleSkipRequest;
import io.digdag.client.api.RestScheduleSummary;
import io.digdag.client.api.RestSessionAttemptCollection;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceLimitExceededException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.schedule.ScheduleControl;
import io.digdag.core.schedule.ScheduleExecutor;
import io.digdag.core.schedule.ScheduleStoreManager;
import io.digdag.core.schedule.StoredSchedule;
import io.digdag.server.rs.AuthenticatedResource;
import io.digdag.server.rs.RestModels;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="Schedule")
@Path(value="/")
@Produces(value={"application/json"})
public class ScheduleResource
extends AuthenticatedResource {
    private final ProjectStoreManager rm;
    private final ScheduleStoreManager sm;
    private final TransactionManager tm;
    private final ScheduleExecutor exec;

    @Inject
    public ScheduleResource(ProjectStoreManager rm, ScheduleStoreManager sm, TransactionManager tm, ScheduleExecutor exec) {
        this.rm = rm;
        this.sm = sm;
        this.tm = tm;
        this.exec = exec;
    }

    @GET
    @Path(value="/api/schedules")
    @ApiOperation(value="List schedules")
    public RestScheduleCollection getSchedules(@ApiParam(value="list schedules whose id is grater than this id for pagination", required=false) @QueryParam(value="last_id") Integer lastId) {
        return (RestScheduleCollection)this.tm.begin(() -> {
            List scheds = this.sm.getScheduleStore(this.getSiteId()).getSchedules(100, Optional.fromNullable((Object)lastId));
            return RestModels.scheduleCollection(this.rm.getProjectStore(this.getSiteId()), scheds);
        });
    }

    @GET
    @Path(value="/api/schedules/{id}")
    @ApiOperation(value="Get a schedule")
    public RestSchedule getSchedules(@ApiParam(value="schedule id", required=true) @PathParam(value="id") int id) throws ResourceNotFoundException {
        return (RestSchedule)this.tm.begin(() -> {
            StoredSchedule sched = this.sm.getScheduleStore(this.getSiteId()).getScheduleById(id);
            ZoneId timeZone = this.getTimeZoneOfSchedule(sched);
            StoredProject proj = this.rm.getProjectStore(this.getSiteId()).getProjectById(sched.getProjectId());
            return RestModels.schedule(sched, proj, timeZone);
        }, ResourceNotFoundException.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/api/schedules/{id}/skip")
    @ApiOperation(value="Skip future sessions by count or time")
    public RestScheduleSummary skipSchedule(@ApiParam(value="session id", required=true) @PathParam(value="id") int id, RestScheduleSkipRequest request) throws ResourceConflictException, ResourceNotFoundException {
        return (RestScheduleSummary)this.tm.begin(() -> {
            Preconditions.checkArgument((request.getNextTime().isPresent() || request.getCount().isPresent() && request.getFromTime().isPresent() ? 1 : 0) != 0, (Object)"nextTime or (fromTime and count) are required");
            StoredSchedule sched = this.sm.getScheduleStore(this.getSiteId()).getScheduleById(id);
            ZoneId timeZone = this.getTimeZoneOfSchedule(sched);
            StoredSchedule updated = request.getNextTime().isPresent() ? this.exec.skipScheduleToTime(this.getSiteId(), id, ((LocalTimeOrInstant)request.getNextTime().get()).toInstant(timeZone), request.getNextRunTime(), request.getDryRun()) : this.exec.skipScheduleByCount(this.getSiteId(), id, (Instant)request.getFromTime().get(), ((Integer)request.getCount().get()).intValue(), request.getNextRunTime(), request.getDryRun());
            return RestModels.scheduleSummary(updated, timeZone);
        }, ResourceConflictException.class, ResourceNotFoundException.class);
    }

    private ZoneId getTimeZoneOfSchedule(StoredSchedule sched) throws ResourceNotFoundException {
        return this.rm.getProjectStore(this.getSiteId()).getWorkflowDefinitionById(sched.getWorkflowDefinitionId()).getTimeZone();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/api/schedules/{id}/backfill")
    @ApiOperation(value="Re-schedule past sessions by count or duration")
    public RestSessionAttemptCollection backfillSchedule(@ApiParam(value="session id", required=true) @PathParam(value="id") int id, RestScheduleBackfillRequest request) throws ResourceConflictException, ResourceLimitExceededException, ResourceNotFoundException {
        return (RestSessionAttemptCollection)this.tm.begin(() -> {
            List attempts = this.exec.backfill(this.getSiteId(), id, request.getFromTime(), request.getAttemptName(), request.getCount(), request.getDryRun());
            return RestModels.attemptCollection(this.rm.getProjectStore(this.getSiteId()), attempts);
        }, ResourceConflictException.class, ResourceLimitExceededException.class, ResourceNotFoundException.class);
    }

    @POST
    @Path(value="/api/schedules/{id}/disable")
    @ApiOperation(value="Disable scheduling of new sessions")
    public RestScheduleSummary disableSchedule(@ApiParam(value="session id", required=true) @PathParam(value="id") int id) throws ResourceNotFoundException, ResourceConflictException {
        return (RestScheduleSummary)this.tm.begin(() -> {
            StoredSchedule sched = this.sm.getScheduleStore(this.getSiteId()).getScheduleById(id);
            ZoneId timeZone = this.getTimeZoneOfSchedule(sched);
            StoredSchedule updated = (StoredSchedule)this.sm.getScheduleStore(this.getSiteId()).updateScheduleById(id, (store, storedSchedule) -> {
                ScheduleControl lockedSched = new ScheduleControl(store, storedSchedule);
                lockedSched.disableSchedule();
                return lockedSched.get();
            });
            return RestModels.scheduleSummary(updated, timeZone);
        }, ResourceConflictException.class, ResourceNotFoundException.class);
    }

    @POST
    @Path(value="/api/schedules/{id}/enable")
    @ApiOperation(value="Re-enable disabled scheduling")
    public RestScheduleSummary enableSchedule(@ApiParam(value="session id", required=true) @PathParam(value="id") int id) throws ResourceNotFoundException, ResourceConflictException {
        return (RestScheduleSummary)this.tm.begin(() -> {
            StoredSchedule sched = this.sm.getScheduleStore(this.getSiteId()).getScheduleById(id);
            ZoneId timeZone = this.getTimeZoneOfSchedule(sched);
            StoredSchedule updated = (StoredSchedule)this.sm.getScheduleStore(this.getSiteId()).updateScheduleById(id, (store, storedSchedule) -> {
                ScheduleControl lockedSched = new ScheduleControl(store, storedSchedule);
                lockedSched.enableSchedule();
                return lockedSched.get();
            });
            return RestModels.scheduleSummary(updated, timeZone);
        }, ResourceConflictException.class, ResourceNotFoundException.class);
    }
}

