/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.oauth;

import com.google.common.base.Optional;
import io.dropwizard.auth.AuthFactory;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.DefaultUnauthorizedHandler;
import io.dropwizard.auth.UnauthorizedHandler;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuthFactory<T>
extends AuthFactory<String, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthFactory.class);
    private final boolean required;
    private final Class<T> generatedClass;
    private final String realm;
    private String prefix = "Bearer";
    private UnauthorizedHandler unauthorizedHandler = new DefaultUnauthorizedHandler();
    @Context
    private HttpServletRequest request;

    public OAuthFactory(Authenticator<String, T> authenticator, String realm, Class<T> generatedClass) {
        super(authenticator);
        this.required = false;
        this.realm = realm;
        this.generatedClass = generatedClass;
    }

    private OAuthFactory(boolean required, Authenticator<String, T> authenticator, String realm, Class<T> generatedClass) {
        super(authenticator);
        this.required = required;
        this.realm = realm;
        this.generatedClass = generatedClass;
    }

    public OAuthFactory<T> prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public OAuthFactory<T> responseBuilder(UnauthorizedHandler unauthorizedHandler) {
        this.unauthorizedHandler = unauthorizedHandler;
        return this;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public AuthFactory<String, T> clone(boolean required) {
        return new OAuthFactory(required, this.authenticator(), this.realm, this.generatedClass).prefix(this.prefix).responseBuilder(this.unauthorizedHandler);
    }

    public T provide() {
        try {
            String method;
            int space;
            String header = this.request.getHeader("Authorization");
            if (header != null && (space = header.indexOf(32)) > 0 && this.prefix.equalsIgnoreCase(method = header.substring(0, space))) {
                String credentials = header.substring(space + 1);
                Optional result = this.authenticator().authenticate(credentials);
                if (result.isPresent()) {
                    return (T)result.get();
                }
            }
        }
        catch (AuthenticationException e) {
            LOGGER.warn("Error authenticating credentials", (Throwable)e);
            throw new InternalServerErrorException();
        }
        if (this.required) {
            throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
        }
        return null;
    }

    @Override
    public Class<T> getGeneratedClass() {
        return this.generatedClass;
    }
}

