/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Sets;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.security.Principal;

public class CachingAuthenticator<C, P extends Principal>
implements Authenticator<C, P> {
    private final Authenticator<C, P> underlying;
    private final Cache<C, Optional<P>> cache;
    private final Meter cacheMisses;
    private final Timer gets;

    public CachingAuthenticator(MetricRegistry metricRegistry, Authenticator<C, P> authenticator, CacheBuilderSpec cacheSpec) {
        this(metricRegistry, authenticator, (CacheBuilder<Object, Object>)CacheBuilder.from((CacheBuilderSpec)cacheSpec));
    }

    public CachingAuthenticator(MetricRegistry metricRegistry, Authenticator<C, P> authenticator, CacheBuilder<Object, Object> builder) {
        this.underlying = authenticator;
        this.cacheMisses = metricRegistry.meter(MetricRegistry.name(authenticator.getClass(), (String[])new String[]{"cache-misses"}));
        this.gets = metricRegistry.timer(MetricRegistry.name(authenticator.getClass(), (String[])new String[]{"gets"}));
        this.cache = builder.recordStats().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<P> authenticate(C credentials) throws AuthenticationException {
        Timer.Context context = this.gets.time();
        try {
            Optional<P> optionalPrincipal = (Optional<P>)this.cache.getIfPresent(credentials);
            if (optionalPrincipal == null) {
                this.cacheMisses.mark();
                optionalPrincipal = this.underlying.authenticate(credentials);
                if (optionalPrincipal.isPresent()) {
                    this.cache.put(credentials, optionalPrincipal);
                }
            }
            Optional<P> optional = optionalPrincipal;
            return optional;
        }
        finally {
            context.stop();
        }
    }

    public void invalidate(C credentials) {
        this.cache.invalidate(credentials);
    }

    public void invalidateAll(Iterable<C> credentials) {
        this.cache.invalidateAll(credentials);
    }

    public void invalidateAll(Predicate<? super C> predicate) {
        this.cache.invalidateAll((Iterable)Sets.filter(this.cache.asMap().keySet(), predicate));
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

