/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.OptionalPrincipalContainerRequestValueFactory;
import io.dropwizard.auth.PrincipalContainerRequestValueFactory;
import java.lang.reflect.ParameterizedType;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
public class AuthValueFactoryProvider<T extends Principal>
extends AbstractValueFactoryProvider {
    private final Class<T> principalClass;

    @Inject
    public AuthValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector, PrincipalClassProvider<T> principalClassProvider) {
        super(mpep, injector, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        this.principalClass = ((PrincipalClassProvider)principalClassProvider).clazz;
    }

    @Nullable
    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        if (!parameter.isAnnotationPresent(Auth.class)) {
            return null;
        }
        if (this.principalClass.equals(parameter.getRawType())) {
            return new PrincipalContainerRequestValueFactory();
        }
        boolean isOptionalPrincipal = parameter.getRawType() == Optional.class && ParameterizedType.class.isAssignableFrom(parameter.getType().getClass()) && this.principalClass == ((ParameterizedType)parameter.getType()).getActualTypeArguments()[0];
        return isOptionalPrincipal ? new OptionalPrincipalContainerRequestValueFactory() : null;
    }

    public static class Binder<T extends Principal>
    extends AbstractBinder {
        private final Class<T> principalClass;

        public Binder(Class<T> principalClass) {
            this.principalClass = principalClass;
        }

        protected void configure() {
            this.bind(new PrincipalClassProvider<T>(this.principalClass)).to(PrincipalClassProvider.class);
            this.bind(AuthValueFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(AuthInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Auth>>(){}).in(Singleton.class);
        }
    }

    @Singleton
    static class PrincipalClassProvider<T extends Principal> {
        private final Class<T> clazz;

        PrincipalClassProvider(Class<T> clazz) {
            this.clazz = clazz;
        }
    }

    @Singleton
    static class AuthInjectionResolver
    extends ParamInjectionResolver<Auth> {
        AuthInjectionResolver() {
            super(AuthValueFactoryProvider.class);
        }
    }
}

