/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.AbstractBuilder;
import io.fabric8.api.AttributableBuilder;
import io.fabric8.api.Builder;
import io.fabric8.api.OptionsProvider;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.internal.ProfileUtils;
import io.fabric8.utils.FabricValidations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultProfileBuilder
extends AbstractBuilder<ProfileBuilder>
implements AttributableBuilder<ProfileBuilder>,
ProfileBuilder {
    private static final String PARENTS_ATTRIBUTE_KEY = "attribute.parents";
    private static final String LOCKED_ATTRIBUTE_KEY = "attribute.locked";
    private String versionId;
    private String profileId;
    private Map<String, byte[]> fileMapping = new HashMap<String, byte[]>();
    private String lastModified;
    private boolean isOverlay;

    public ProfileBuilder from(Profile profile) {
        this.versionId = profile.getVersion();
        this.profileId = profile.getId();
        this.setFileConfigurations(profile.getFileConfigurations());
        return this;
    }

    public ProfileBuilder addOptions(OptionsProvider<ProfileBuilder> optionsProvider) {
        return (ProfileBuilder)optionsProvider.addOptions((Builder)this);
    }

    public ProfileBuilder identity(String profileId) {
        this.profileId = profileId;
        return this;
    }

    public ProfileBuilder version(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public List<String> getParents() {
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        String pspec = config.get(PARENTS_ATTRIBUTE_KEY);
        String[] parentIds = pspec != null ? pspec.split(" ") : new String[]{};
        return Arrays.asList(parentIds);
    }

    public ProfileBuilder addParent(String parentId) {
        return this.addParentsInternal(Collections.singletonList(parentId), false);
    }

    public ProfileBuilder addParents(List<String> parentIds) {
        return this.addParentsInternal(parentIds, false);
    }

    public ProfileBuilder setParents(List<String> parentIds) {
        return this.addParentsInternal(parentIds, true);
    }

    private ProfileBuilder addParentsInternal(List<String> parentIds, boolean clear) {
        LinkedHashSet<String> currentIds = new LinkedHashSet<String>(this.getParents());
        if (clear) {
            currentIds.clear();
        }
        currentIds.addAll(parentIds);
        this.updateParentsAttribute(currentIds);
        return this;
    }

    public ProfileBuilder removeParent(String profileId) {
        LinkedHashSet<String> currentIds = new LinkedHashSet<String>(this.getParents());
        currentIds.remove(profileId);
        this.updateParentsAttribute(currentIds);
        return this;
    }

    private void updateParentsAttribute(Collection<String> parentIds) {
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        config.remove(PARENTS_ATTRIBUTE_KEY);
        if (parentIds.size() > 0) {
            config.put(PARENTS_ATTRIBUTE_KEY, this.parentsAttributeValue(parentIds));
        }
        this.addConfiguration("io.fabric8.agent", config);
    }

    private String parentsAttributeValue(Collection<String> parentIds) {
        String pspec = "";
        if (parentIds.size() > 0) {
            for (String parentId : parentIds) {
                pspec = pspec + " " + parentId;
            }
            pspec = pspec.substring(1);
        }
        return pspec;
    }

    public ProfileBuilder setLocked(boolean flag) {
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        if (flag) {
            config.put(LOCKED_ATTRIBUTE_KEY, "true");
        } else {
            config.remove(LOCKED_ATTRIBUTE_KEY);
        }
        this.addConfiguration("io.fabric8.agent", config);
        return this;
    }

    public Set<String> getFileConfigurationKeys() {
        return this.fileMapping.keySet();
    }

    public byte[] getFileConfiguration(String key) {
        return this.fileMapping.get(key);
    }

    public ProfileBuilder setFileConfigurations(Map<String, byte[]> configurations) {
        this.fileMapping = new HashMap<String, byte[]>(configurations);
        return this;
    }

    public ProfileBuilder addFileConfiguration(String fileName, byte[] data) {
        this.fileMapping.put(fileName, data);
        return this;
    }

    public ProfileBuilder deleteFileConfiguration(String fileName) {
        this.fileMapping.remove(fileName);
        return this;
    }

    public ProfileBuilder setConfigurations(Map<String, Map<String, String>> configs) {
        for (String string : this.getConfigurationKeys()) {
            this.deleteConfiguration(string);
        }
        for (Map.Entry entry : configs.entrySet()) {
            this.addConfiguration((String)entry.getKey(), new HashMap<String, String>((Map)entry.getValue()));
        }
        return this;
    }

    public ProfileBuilder addConfiguration(String pid, Map<String, String> config) {
        this.fileMapping.put(pid + ".properties", ProfileUtils.toBytes(config));
        return this;
    }

    public ProfileBuilder addConfiguration(String pid, String key, String value) {
        Map<String, String> config = this.getConfigurationInternal(pid);
        config.put(key, value);
        return this.addConfiguration(pid, config);
    }

    public Set<String> getConfigurationKeys() {
        HashSet<String> result = new HashSet<String>();
        for (String fileKey : this.fileMapping.keySet()) {
            if (!fileKey.endsWith(".properties")) continue;
            String configKey = fileKey.substring(0, fileKey.indexOf(".properties"));
            result.add(configKey);
        }
        return Collections.unmodifiableSet(result);
    }

    public Map<String, String> getConfiguration(String pid) {
        return this.getConfigurationInternal(pid);
    }

    private Map<String, String> getConfigurationInternal(String pid) {
        byte[] bytes = this.fileMapping.get(pid + ".properties");
        return ProfileUtils.toProperties(bytes);
    }

    public ProfileBuilder deleteConfiguration(String pid) {
        this.fileMapping.remove(pid + ".properties");
        return this;
    }

    public ProfileBuilder setBundles(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.BUNDLES, values);
        return this;
    }

    public ProfileBuilder setFabs(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.FABS, values);
        return this;
    }

    public ProfileBuilder setFeatures(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.FEATURES, values);
        return this;
    }

    public ProfileBuilder setRepositories(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.REPOSITORIES, values);
        return this;
    }

    public ProfileBuilder setOverrides(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.OVERRIDES, values);
        return this;
    }

    public ProfileBuilder setOptionals(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.OPTIONALS, values);
        return this;
    }

    public ProfileBuilder setTags(List<String> values) {
        this.addAgentConfiguration(ProfileImpl.ConfigListType.TAGS, values);
        return this;
    }

    public ProfileBuilder setOverlay(boolean overlay) {
        this.isOverlay = overlay;
        return this;
    }

    public ProfileBuilder setLastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public ProfileBuilder addAttribute(String key, String value) {
        this.addConfiguration("io.fabric8.agent", "attribute." + key, value);
        return this;
    }

    public ProfileBuilder setAttributes(Map<String, String> attributes) {
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        for (String string : new ArrayList<String>(config.keySet())) {
            if (!string.startsWith("attribute.")) continue;
            config.remove(string);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            config.put("attribute." + (String)entry.getKey(), (String)entry.getValue());
        }
        this.addConfiguration("io.fabric8.agent", config);
        return null;
    }

    private void addAgentConfiguration(ProfileImpl.ConfigListType type, List<String> values) {
        String prefix = (Object)((Object)type) + ".";
        Map<String, String> config = this.getConfigurationInternal("io.fabric8.agent");
        for (String key : new ArrayList<String>(config.keySet())) {
            if (!key.startsWith(prefix)) continue;
            config.remove(key);
        }
        for (String value : values) {
            config.put(prefix + value, value);
        }
        this.addConfiguration("io.fabric8.agent", config);
    }

    protected void validate() {
        super.validate();
        IllegalStateAssertion.assertNotNull((Object)this.profileId, (String)"Profile must have an identity");
        IllegalStateAssertion.assertNotNull((Object)this.versionId, (String)"Version must be specified");
        FabricValidations.validateProfileName(this.versionId);
    }

    public Profile getProfile() {
        this.validate();
        return new ProfileImpl(this.versionId, this.profileId, this.getParents(), this.fileMapping, this.lastModified, this.isOverlay);
    }
}

