/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.OptionsProvider;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.api.permit.PermitManager;
import io.fabric8.api.scr.AbstractProtectedComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.visibility.VisibleForExternal;
import io.fabric8.internal.ProfileUtils;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.FabricValidations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.utils.properties.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.IGNORE, immediate=true)
@References(value={@Reference(referenceInterface=PermitManager.class)})
@Service(value={ProfileService.class})
public final class ProfileServiceImpl
extends AbstractProtectedComponent<ProfileService>
implements ProfileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileServiceImpl.class);
    @Reference(referenceInterface=ProfileRegistry.class)
    private final ValidatingReference<ProfileRegistry> profileRegistry = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();

    @VisibleForExternal
    @Activate
    public void activate() throws Exception {
        this.getOverlayAudit();
        this.activateComponent(PERMIT, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OverlayAudit getOverlayAudit() {
        ValidatingReference<RuntimeProperties> validatingReference = this.runtimeProperties;
        synchronized (validatingReference) {
            RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
            OverlayAudit audit = (OverlayAudit)sysprops.getRuntimeAttribute(OverlayAudit.class);
            if (audit == null) {
                audit = new OverlayAudit();
                sysprops.putRuntimeAttribute(OverlayAudit.class, (Object)audit);
            }
            return audit;
        }
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent(PERMIT);
    }

    public Version createVersion(Version version) {
        this.assertValid();
        LOGGER.info("createVersion: {}", (Object)version);
        String versionId = ((ProfileRegistry)this.profileRegistry.get()).createVersion(version);
        return this.getRequiredVersion(versionId);
    }

    public Version createVersionFrom(String sourceId, String targetId, Map<String, String> attributes) {
        this.assertValid();
        LOGGER.info("createVersion: {} => {}", (Object)sourceId, (Object)targetId);
        FabricValidations.validateProfileName(targetId);
        ((ProfileRegistry)this.profileRegistry.get()).createVersion(sourceId, targetId, attributes);
        return this.getRequiredVersion(targetId);
    }

    public List<String> getVersions() {
        this.assertValid();
        return ((ProfileRegistry)this.profileRegistry.get()).getVersionIds();
    }

    public boolean hasVersion(String versionId) {
        this.assertValid();
        return ((ProfileRegistry)this.profileRegistry.get()).hasVersion(versionId);
    }

    public Version getVersion(String versionId) {
        this.assertValid();
        return ((ProfileRegistry)this.profileRegistry.get()).getVersion(versionId);
    }

    public Version getRequiredVersion(String versionId) {
        this.assertValid();
        return ((ProfileRegistry)this.profileRegistry.get()).getRequiredVersion(versionId);
    }

    public Profile createProfile(Profile profile) {
        this.assertValid();
        LOGGER.info("createProfile: {}", (Object)profile);
        String profileId = ((ProfileRegistry)this.profileRegistry.get()).createProfile(profile);
        return this.getRequiredProfile(profile.getVersion(), profileId);
    }

    public Profile updateProfile(Profile profile) {
        return this.updateProfile(profile, false);
    }

    public Profile updateProfile(Profile profile, boolean force) {
        this.assertValid();
        LOGGER.info("updateProfile: {}", (Object)profile);
        String profileId = ((ProfileRegistry)this.profileRegistry.get()).updateProfile(profile, force);
        return this.getRequiredProfile(profile.getVersion(), profileId);
    }

    public boolean hasProfile(String versionId, String profileId) {
        this.assertValid();
        return ((ProfileRegistry)this.profileRegistry.get()).hasProfile(versionId, profileId);
    }

    public Profile getProfile(String versionId, String profileId) {
        this.assertValid();
        return ((ProfileRegistry)this.profileRegistry.get()).getProfile(versionId, profileId);
    }

    public Profile getRequiredProfile(String versionId, String profileId) {
        this.assertValid();
        return ((ProfileRegistry)this.profileRegistry.get()).getRequiredProfile(versionId, profileId);
    }

    public void deleteVersion(String versionId) {
        this.assertValid();
        LOGGER.info("deleteVersion: {}", (Object)versionId);
        ((ProfileRegistry)this.profileRegistry.get()).deleteVersion(versionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getOverlayProfile(Profile profile) {
        Profile overlayProfile;
        this.assertValid();
        ProfileServiceImpl profileServiceImpl = this;
        synchronized (profileServiceImpl) {
            if (profile.isOverlay()) {
                LOGGER.debug("getOverlayProfile, given profile is already an overlay: " + profile);
                overlayProfile = profile;
            } else {
                String profileId = profile.getId();
                String environment = ((RuntimeProperties)this.runtimeProperties.get()).getProperty("fabric.environment");
                if (environment == null) {
                    environment = System.getProperty("fabric.profile.environment");
                }
                Version version = this.getRequiredVersion(profile.getVersion());
                ProfileBuilder builder = ProfileBuilder.Factory.create((String)profile.getVersion(), (String)profileId);
                builder.addOptions((OptionsProvider)new OverlayOptionsProvider(version, profile, environment));
                overlayProfile = builder.getProfile();
                if (LOGGER.isDebugEnabled()) {
                    OverlayAudit audit;
                    OverlayAudit overlayAudit = audit = this.getOverlayAudit();
                    synchronized (overlayAudit) {
                        Profile lastOverlay = audit.overlayProfiles.get(profileId);
                        if (lastOverlay == null) {
                            LOGGER.debug("Overlay" + Profiles.getProfileInfo((Profile)overlayProfile));
                            audit.overlayProfiles.put(profileId, overlayProfile);
                        } else if (!lastOverlay.equals(overlayProfile)) {
                            LOGGER.debug("Overlay" + Profiles.getProfileDifference((Profile)lastOverlay, (Profile)overlayProfile));
                            audit.overlayProfiles.put(profileId, overlayProfile);
                        }
                    }
                }
            }
        }
        return overlayProfile;
    }

    public void deleteProfile(String versionId, String profileId, boolean force) {
        this.deleteProfile(null, versionId, profileId, force);
    }

    public void deleteProfile(FabricService fabricService, String versionId, String profileId, boolean force) {
        FabricRequirements requirements;
        Container[] containers;
        this.assertValid();
        Profile profile = this.getRequiredProfile(versionId, profileId);
        LOGGER.info("deleteProfile: {}", (Object)profile);
        Container[] containerArray = containers = fabricService != null ? fabricService.getAssociatedContainers(versionId, profileId) : new Container[]{};
        if (containers.length == 0) {
            ((ProfileRegistry)this.profileRegistry.get()).deleteProfile(versionId, profileId);
        } else if (force) {
            for (Container container : containers) {
                container.removeProfiles(new String[]{profileId});
            }
            ((ProfileRegistry)this.profileRegistry.get()).deleteProfile(versionId, profileId);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot delete profile:").append(profileId).append(".");
            sb.append("Profile has assigned ").append(containers.length).append(" container(s):");
            for (Container c : containers) {
                sb.append(" ").append(c.getId());
            }
            sb.append(". Use force option to also remove the profile from the containers.");
            throw new FabricException(sb.toString());
        }
        FabricRequirements fabricRequirements = requirements = fabricService != null ? fabricService.getRequirements() : null;
        if (requirements != null && requirements.removeProfileRequirements(profileId)) {
            try {
                fabricService.setRequirements(requirements);
            }
            catch (IOException e) {
                throw new FabricException("Failed to update requirements after deleting profile " + profileId + ". " + e, (Throwable)e);
            }
        }
    }

    @VisibleForExternal
    public void bindProfileRegistry(ProfileRegistry service) {
        this.profileRegistry.bind((Object)service);
    }

    void unbindProfileRegistry(ProfileRegistry service) {
        this.profileRegistry.unbind((Object)service);
    }

    @VisibleForExternal
    public void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    static class OverlayOptionsProvider
    implements OptionsProvider<ProfileBuilder> {
        private final Version version;
        private final Profile self;
        private final String environment;

        OverlayOptionsProvider(Version version, Profile self, String environment) {
            this.version = version;
            this.self = self;
            this.environment = environment;
        }

        public ProfileBuilder addOptions(ProfileBuilder builder) {
            builder.setAttributes(this.self.getAttributes());
            builder.setFileConfigurations(this.getFileConfigurations());
            builder.setConfigurations(this.getConfigurations());
            builder.setLastModified(this.getLastModified());
            builder.setOverlay(true);
            return builder;
        }

        private Map<String, byte[]> getFileConfigurations() {
            try {
                HashMap<String, SupplementControl> aggregate = new HashMap<String, SupplementControl>();
                for (Profile profile : this.getInheritedProfiles()) {
                    this.supplement(profile, aggregate);
                }
                HashMap<String, byte[]> rc = new HashMap<String, byte[]>();
                for (Map.Entry entry : aggregate.entrySet()) {
                    SupplementControl ctrl = (SupplementControl)entry.getValue();
                    if (ctrl.props != null) {
                        ctrl.data = DataStoreUtils.toBytes(ctrl.props);
                    }
                    rc.put((String)entry.getKey(), ctrl.data);
                }
                return rc;
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }

        private Map<String, Map<String, String>> getConfigurations() {
            try {
                HashMap<String, SupplementControl> aggregate = new HashMap<String, SupplementControl>();
                for (Profile profile : this.getInheritedProfiles()) {
                    this.supplement(profile, aggregate);
                }
                HashMap<String, Map<String, String>> rc = new HashMap<String, Map<String, String>>();
                for (Map.Entry entry : aggregate.entrySet()) {
                    SupplementControl ctrl = (SupplementControl)entry.getValue();
                    if (ctrl.props == null) continue;
                    rc.put(DataStoreUtils.stripSuffix((String)entry.getKey(), ".properties"), ctrl.props);
                }
                return rc;
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }

        private List<Profile> getInheritedProfiles() {
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            this.fillParentProfiles(this.self, profiles);
            return profiles;
        }

        private void fillParentProfiles(Profile profile, List<Profile> profiles) {
            if (!profiles.contains(profile)) {
                for (String parentId : profile.getParentIds()) {
                    Profile parent = this.version.getRequiredProfile(parentId);
                    this.fillParentProfiles(parent, profiles);
                }
                profiles.add(profile);
            }
        }

        private void supplement(Profile profile, Map<String, SupplementControl> aggregate) throws Exception {
            Map configs = profile.getFileConfigurations();
            for (String key : configs.keySet()) {
                SupplementControl ctrl;
                String fileName;
                if (key.contains("#")) continue;
                byte[] value = (byte[])configs.get(key);
                if (this.environment != null && configs.containsKey(key + "#" + this.environment)) {
                    value = (byte[])configs.get(key + "#" + this.environment);
                }
                if ((fileName = key).endsWith(".properties")) {
                    ctrl = aggregate.get(fileName);
                    if (ctrl != null) {
                        Properties childMap = ProfileUtils.toProperties(value);
                        if (childMap.remove("#deleted#") != null) {
                            ctrl.props.clear();
                        }
                        for (Map.Entry<String, String> p : childMap.entrySet()) {
                            if ("#deleted#".equals(p.getValue())) {
                                ctrl.props.remove(p.getKey());
                                continue;
                            }
                            ctrl.props.put(p.getKey(), p.getValue());
                        }
                        continue;
                    }
                    ctrl = new SupplementControl();
                    ctrl.props = ProfileUtils.toProperties(value);
                    aggregate.put(fileName, ctrl);
                    continue;
                }
                ctrl = new SupplementControl();
                ctrl.data = value;
                aggregate.put(fileName, ctrl);
            }
        }

        private String getLastModified() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.self.getProfileHash());
            for (String parentId : this.self.getParentIds()) {
                Profile parent = this.version.getRequiredProfile(parentId);
                sb.append("-").append(parent.getProfileHash());
            }
            return sb.toString();
        }

        private static class SupplementControl {
            byte[] data;
            Properties props;

            private SupplementControl() {
            }
        }
    }

    static class OverlayAudit {
        Map<String, Profile> overlayProfiles = new HashMap<String, Profile>();

        OverlayAudit() {
        }
    }
}

