/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.VersionSequence;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.api.jcip.Immutable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Immutable
final class VersionImpl
implements Version {
    private final String versionId;
    private final String revision;
    private final Map<String, String> attributes;
    private final Map<String, Profile> profiles = new LinkedHashMap<String, Profile>();

    VersionImpl(String versionId, String revision, Map<String, String> attributes, List<Profile> prflist) {
        this.versionId = versionId;
        this.revision = revision;
        this.attributes = new HashMap<String, String>(attributes);
        for (Profile prf : prflist) {
            this.profiles.put(prf.getId(), prf);
        }
    }

    public String getId() {
        return this.versionId;
    }

    public String getRevision() {
        return this.revision;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<String> getProfileIds() {
        ArrayList<String> result = new ArrayList<String>(this.profiles.keySet());
        return Collections.unmodifiableList(result);
    }

    public List<Profile> getProfiles() {
        ArrayList<Profile> prflist = new ArrayList<Profile>(this.profiles.values());
        return Collections.unmodifiableList(prflist);
    }

    public Profile getProfile(String profileId) {
        return this.profiles.get(profileId);
    }

    public Profile getRequiredProfile(String profileId) {
        Profile profile = this.profiles.get(profileId);
        IllegalStateAssertion.assertNotNull((Object)profile, (String)("Profile '" + profileId + "' does not exist in version: " + this.versionId));
        return profile;
    }

    public boolean hasProfile(String profileId) {
        return this.profiles.get(profileId) != null;
    }

    public int compareTo(Version other) {
        return new VersionSequence(this.versionId).compareTo(new VersionSequence(other.getId()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionImpl)) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        return this.versionId.equals(other.versionId);
    }

    public int hashCode() {
        return this.versionId.hashCode();
    }

    public String toString() {
        return "Version[id=" + this.versionId + "]";
    }
}

