/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.ContainerAutoScalerFactory;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateContainerBasicMetadata;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.FabricStatus;
import io.fabric8.api.NameValidator;
import io.fabric8.api.NullCreationStateListener;
import io.fabric8.api.PatchService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.PortService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileDependencyException;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.visibility.VisibleForTesting;
import io.fabric8.internal.ContainerImpl;
import io.fabric8.internal.PlaceholderResolverHelpers;
import io.fabric8.internal.ProfileDependencyConfig;
import io.fabric8.internal.ProfileDependencyKind;
import io.fabric8.service.ChecksumPlaceholderResolver;
import io.fabric8.service.ContainerPlaceholderResolver;
import io.fabric8.service.EncryptedPropertyResolver;
import io.fabric8.service.EnvPlaceholderResolver;
import io.fabric8.service.PatchServiceImpl;
import io.fabric8.service.PortPlaceholderResolver;
import io.fabric8.service.ProfilePropertyPointerResolver;
import io.fabric8.service.VersionPropertyPointerResolver;
import io.fabric8.service.ZookeeperPlaceholderResolver;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import io.fabric8.zookeeper.utils.InterpolationHelper;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.service", label="Fabric8 Service", metatype=false)
@Service(value={FabricService.class})
public final class FabricServiceImpl
extends AbstractComponent
implements FabricService {
    public static final String REQUIREMENTS_JSON_PATH = "/fabric/configs/io.fabric8.requirements.json";
    public static final String JVM_OPTIONS_PATH = "/fabric/configs/io.fabric8.containers.jvmOptions";
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricServiceImpl.class);
    @Reference
    private ChecksumPlaceholderResolver checksumPlaceholderResolver;
    @Reference
    private ContainerPlaceholderResolver containerPlaceholderResolver;
    @Reference
    private EncryptedPropertyResolver encryptedPropertyResolver;
    @Reference
    private EnvPlaceholderResolver envPlaceholderResolver;
    @Reference
    private PortPlaceholderResolver portPlaceholderResolver;
    @Reference
    private ProfilePropertyPointerResolver profilePropertyPointerResolver;
    @Reference
    private VersionPropertyPointerResolver versionPropertyPointerResolver;
    @Reference
    private ZookeeperPlaceholderResolver zookeeperPlaceholderResolver;
    @Reference
    private ContainerRegistration containerRegistration;
    @Reference
    private BootstrapConfiguration bootstrapConfig;
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=DataStore.class)
    private final ValidatingReference<DataStore> dataStore = new ValidatingReference();
    @Reference(referenceInterface=PortService.class)
    private final ValidatingReference<PortService> portService = new ValidatingReference();
    @Reference(referenceInterface=ProfileService.class)
    private final ValidatingReference<ProfileService> profileService = new ValidatingReference();
    @Reference(referenceInterface=ProfileRegistry.class)
    private final ValidatingReference<ProfileRegistry> profileRegistry = new ValidatingReference();
    @Reference(referenceInterface=ContainerProvider.class, bind="bindProvider", unbind="unbindProvider", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<String, ContainerProvider> providers = new ConcurrentHashMap<String, ContainerProvider>();
    @Reference(referenceInterface=PlaceholderResolver.class, bind="bindPlaceholderResolver", unbind="unbindPlaceholderResolver", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<String, PlaceholderResolver> placeholderResolvers = new ConcurrentHashMap<String, PlaceholderResolver>();
    @Reference
    private Configurer configurer;
    private String defaultRepo = "https://repo.fusesource.com/nexus/content/groups/public/";
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public <T> T adapt(Class<T> type) {
        this.assertValid();
        if (type.isAssignableFrom(CuratorFramework.class)) {
            return (T)this.curator.get();
        }
        if (type.isAssignableFrom(DataStore.class)) {
            return (T)this.dataStore.get();
        }
        if (type.isAssignableFrom(ProfileService.class)) {
            return (T)this.profileService.get();
        }
        if (type.isAssignableFrom(ProfileRegistry.class)) {
            return (T)this.profileRegistry.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultRepo() {
        FabricServiceImpl fabricServiceImpl = this;
        synchronized (fabricServiceImpl) {
            return this.defaultRepo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRepo(String defaultRepo) {
        FabricServiceImpl fabricServiceImpl = this;
        synchronized (fabricServiceImpl) {
            this.defaultRepo = defaultRepo;
        }
    }

    public PortService getPortService() {
        this.assertValid();
        return (PortService)this.portService.get();
    }

    public Container getCurrentContainer() {
        this.assertValid();
        String name = this.getCurrentContainerName();
        return this.getContainer(name);
    }

    public String getEnvironment() {
        this.assertValid();
        String answer = ((RuntimeProperties)this.runtimeProperties.get()).getProperty("fabric.environment");
        if (answer == null) {
            Container currentContainer = this.getCurrentContainer();
            if (currentContainer != null) {
                Map systemProperties = currentContainer.getOverlayProfile().getConfiguration("io.fabric8.system");
                answer = (String)systemProperties.get("fabric.environment");
            }
            if (answer != null) {
                System.setProperty("fabric.profile.environment", answer);
            }
        }
        return answer;
    }

    public String getCurrentContainerName() {
        this.assertValid();
        return ((RuntimeProperties)this.runtimeProperties.get()).getRuntimeIdentity();
    }

    public void trackConfiguration(Runnable callback) {
        this.assertValid();
        ((DataStore)this.dataStore.get()).trackConfiguration(callback);
    }

    public void untrackConfiguration(Runnable callback) {
        this.assertValid();
        ((DataStore)this.dataStore.get()).untrackConfiguration(callback);
    }

    public Container[] getContainers() {
        this.assertValid();
        HashMap<String, Container> containers = new HashMap<String, Container>();
        List containerIds = ((DataStore)this.dataStore.get()).getContainers();
        for (String containerId : containerIds) {
            String parentId = ((DataStore)this.dataStore.get()).getContainerParent(containerId);
            if (parentId.isEmpty()) {
                if (containers.containsKey(containerId)) continue;
                ContainerImpl container = new ContainerImpl(null, containerId, this);
                containers.put(containerId, container);
                continue;
            }
            Container parent = (Container)containers.get(parentId);
            if (parent == null) {
                parent = new ContainerImpl(null, parentId, this);
                containers.put(parentId, parent);
            }
            ContainerImpl container = new ContainerImpl(parent, containerId, this);
            containers.put(containerId, container);
        }
        return containers.values().toArray(new Container[containers.size()]);
    }

    public Container[] getAssociatedContainers(String versionId, String profileId) {
        this.assertValid();
        ArrayList<Container> containers = new ArrayList<Container>();
        for (Container container : this.getContainers()) {
            for (Profile profile : Arrays.asList(container.getProfiles())) {
                if (!profile.getId().equals(profileId)) continue;
                containers.add(container);
            }
        }
        return containers.toArray(new Container[containers.size()]);
    }

    public Container getContainer(String name) {
        this.assertValid();
        if (((DataStore)this.dataStore.get()).hasContainer(name)) {
            Container parent = null;
            String parentId = ((DataStore)this.dataStore.get()).getContainerParent(name);
            if (parentId != null && !parentId.isEmpty()) {
                parent = this.getContainer(parentId);
            }
            return new ContainerImpl(parent, name, this);
        }
        throw new FabricException("Container '" + name + "' does not exist");
    }

    public void startContainer(String containerId) {
        this.startContainer(containerId, false);
    }

    public void startContainer(String containerId, boolean force) {
        this.assertValid();
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.startContainer(container, force);
        }
    }

    public void startContainer(Container container) {
        this.startContainer(container, true);
    }

    public void startContainer(Container container, boolean force) {
        this.assertValid();
        LOGGER.info("Starting container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        provider.start(container);
    }

    public void stopContainer(String containerId) {
        this.stopContainer(containerId, false);
    }

    public void stopContainer(String containerId, boolean force) {
        this.assertValid();
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.stopContainer(container, force);
        }
    }

    public void stopContainer(Container container) {
        this.stopContainer(container, false);
    }

    public void stopContainer(Container container, boolean force) {
        block2: {
            this.assertValid();
            LOGGER.info("Stopping container {}", (Object)container.getId());
            ContainerProvider provider = this.getProvider(container);
            try {
                provider.stop(container);
            }
            catch (RuntimeException ex) {
                boolean stopped = "Instance already stopped".equals(ex.getMessage());
                if (stopped) break block2;
                throw ex;
            }
        }
    }

    public void destroyContainer(String containerId) {
        this.destroyContainer(containerId, false);
    }

    public void destroyContainer(String containerId, boolean force) {
        this.assertValid();
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.destroyContainer(container, force);
        }
    }

    public void destroyContainer(Container container) {
        this.destroyContainer(container, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyContainer(Container container, boolean force) {
        Exception providerException;
        block17: {
            this.assertValid();
            String containerId = container.getId();
            providerException = null;
            LOGGER.info("Destroying container {}", (Object)containerId);
            boolean destroyed = false;
            try {
                ContainerProvider provider;
                block16: {
                    provider = this.getProvider(container, true);
                    if (provider != null) {
                        try {
                            provider.stop(container);
                            break block16;
                        }
                        catch (Exception ex) {
                            boolean stopped = "Instance already stopped".equals(ex.getMessage());
                            if (!stopped) {
                                providerException = ex;
                            }
                            break block16;
                        }
                    }
                    throw new FabricException("Container's lifecycle not managed by Fabric8 (the container was not created by Fabric8).");
                }
                provider.destroy(container);
                destroyed = true;
            }
            catch (Throwable throwable) {
                block18: {
                    try {
                        if (!destroyed && !force) break block18;
                        try {
                            ((PortService)this.portService.get()).unregisterPort(container);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to cleanup container {} entries due to: {}. This will be ignored.", (Object)containerId, (Object)e.getMessage());
                        }
                        ((DataStore)this.dataStore.get()).deleteContainer((FabricService)this, container.getId());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to cleanup container {} entries due to: {}. This will be ignored.", (Object)containerId, (Object)e.getMessage());
                    }
                }
                if (providerException != null) {
                    throw FabricException.launderThrowable(providerException);
                }
                throw throwable;
            }
            try {
                if (!destroyed && !force) break block17;
                try {
                    ((PortService)this.portService.get()).unregisterPort(container);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to cleanup container {} entries due to: {}. This will be ignored.", (Object)containerId, (Object)e.getMessage());
                }
                ((DataStore)this.dataStore.get()).deleteContainer((FabricService)this, container.getId());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to cleanup container {} entries due to: {}. This will be ignored.", (Object)containerId, (Object)e.getMessage());
            }
        }
        if (providerException != null) {
            throw FabricException.launderThrowable((Throwable)providerException);
        }
    }

    private ContainerProvider getProvider(Container container) {
        return this.getProvider(container, false);
    }

    private ContainerProvider getProvider(Container container, boolean returnNull) {
        String type;
        CreateContainerMetadata metadata = container.getMetadata();
        String string = type = metadata != null ? metadata.getCreateOptions().getProviderType() : null;
        if (type == null) {
            if (returnNull) {
                return null;
            }
            throw new UnsupportedOperationException("Container " + container.getId() + " has not been created using Fabric");
        }
        ContainerProvider provider = this.getProvider(type);
        if (provider == null) {
            if (returnNull) {
                return null;
            }
            throw new UnsupportedOperationException("Container provider " + type + " not supported");
        }
        return provider;
    }

    public CreateContainerMetadata[] createContainers(CreateContainerOptions options) {
        return this.createContainers(options, null);
    }

    public CreateContainerMetadata[] createContainers(CreateContainerOptions options, CreationStateListener listener) {
        this.assertValid();
        try {
            Container[] containers;
            String configuredGlobalResolver;
            ContainerProvider provider = this.getProvider(options.getProviderType());
            if (provider == null) {
                throw new FabricException("Unable to find a container provider supporting '" + options.getProviderType() + "'");
            }
            if (!provider.isValidProvider()) {
                throw new FabricException("The provider '" + options.getProviderType() + "' is not valid in current environment");
            }
            String originalName = options.getName();
            if (originalName == null || originalName.length() == 0) {
                throw new FabricException("A name must be specified when creating containers");
            }
            if (listener == null) {
                listener = new NullCreationStateListener();
            }
            this.validateProfileDependencies(options);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Map optionsMap = (Map)mapper.readValue(mapper.writeValueAsString((Object)options), Map.class);
            String versionId = options.getVersion() != null ? options.getVersion() : ((DataStore)this.dataStore.get()).getDefaultVersion();
            LinkedHashSet<String> profileIds = options.getProfiles();
            if (profileIds == null || profileIds.isEmpty()) {
                profileIds = new LinkedHashSet<String>();
                profileIds.add("default");
            }
            optionsMap.put("version", versionId);
            optionsMap.put("profiles", profileIds);
            optionsMap.put("number", 0);
            if (this.bootstrapConfig != null && !Strings.isNullOrEmpty((String)(configuredGlobalResolver = this.bootstrapConfig.getGlobalResolver()))) {
                optionsMap.put("globalResolver", configuredGlobalResolver);
                if (optionsMap.get("resolver") == null) {
                    optionsMap.put("resolver", configuredGlobalResolver);
                }
            }
            CopyOnWriteArrayList metadatas = new CopyOnWriteArrayList();
            int orgNumber = options.getNumber();
            int number = Math.max(orgNumber, 1);
            CountDownLatch latch = new CountDownLatch(number);
            HashSet<String> ignoreContainerNames = new HashSet<String>();
            for (Container container : containers = this.getContainers()) {
                if (!container.getId().equals(options.getName())) continue;
                throw new IllegalArgumentException("A container with name " + options.getName() + " already exists.");
            }
            for (int i = 1; i <= number; ++i) {
                NameValidator validator = Containers.createNameValidator((Container[])containers, ignoreContainerNames);
                final String containerName = Containers.createUniqueContainerName((Container[])containers, (String)originalName, (NameValidator)validator);
                ignoreContainerNames.add(containerName);
                optionsMap.put("name", containerName);
                if (!FabricServiceImpl.hasValidDataStoreProperties(optionsMap)) {
                    optionsMap.put("dataStoreProperties", ((ProfileRegistry)this.profileRegistry.get()).getDataStoreProperties());
                }
                Class<?> cl = options.getClass().getClassLoader().loadClass(options.getClass().getName() + "$Builder");
                CreateContainerBasicOptions.Builder builder = (CreateContainerBasicOptions.Builder)mapper.readValue(mapper.writeValueAsString((Object)optionsMap), cl);
                builder = (CreateContainerBasicOptions.Builder)builder.zookeeperPassword(PasswordEncoder.encode(this.getZookeeperPassword()));
                CreateContainerBasicOptions containerOptions = builder.build();
                CreationStateListener containerListener = listener;
                FabricServiceImpl fabricService = this;
                new Thread("Creating container " + containerName, (CreateContainerOptions)containerOptions, metadatas, provider, containerListener, fabricService, latch){
                    final /* synthetic */ CreateContainerOptions val$containerOptions;
                    final /* synthetic */ List val$metadatas;
                    final /* synthetic */ ContainerProvider val$provider;
                    final /* synthetic */ CreationStateListener val$containerListener;
                    final /* synthetic */ FabricService val$fabricService;
                    final /* synthetic */ CountDownLatch val$latch;
                    {
                        this.val$containerOptions = createContainerOptions;
                        this.val$metadatas = list;
                        this.val$provider = containerProvider;
                        this.val$containerListener = creationStateListener;
                        this.val$fabricService = fabricService;
                        this.val$latch = countDownLatch;
                        super(x0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (((DataStore)FabricServiceImpl.this.dataStore.get()).hasContainer(containerName)) {
                                CreateContainerBasicMetadata metadata = new CreateContainerBasicMetadata();
                                metadata.setContainerName(containerName);
                                metadata.setCreateOptions(this.val$containerOptions);
                                metadata.setFailure((Throwable)new IllegalArgumentException("A container with name " + containerName + " already exists."));
                                this.val$metadatas.add(metadata);
                                return;
                            }
                            ((DataStore)FabricServiceImpl.this.dataStore.get()).createContainerConfig(this.val$containerOptions);
                            CreateContainerMetadata metadata = this.val$provider.create(this.val$containerOptions, this.val$containerListener);
                            if (metadata.isSuccess()) {
                                Container parent;
                                Container container = parent = this.val$containerOptions.getParent() != null ? FabricServiceImpl.this.getContainer(this.val$containerOptions.getParent()) : null;
                                if (!this.val$containerOptions.isEnsembleServer()) {
                                    ((DataStore)FabricServiceImpl.this.dataStore.get()).createContainerConfig(metadata);
                                }
                                ContainerImpl container2 = new ContainerImpl(parent, metadata.getContainerName(), FabricServiceImpl.this);
                                metadata.setContainer((Container)container2);
                                LOGGER.info("The container " + metadata.getContainerName() + " has been successfully created");
                            } else {
                                LOGGER.warn("The creation of the container " + metadata.getContainerName() + " has failed", metadata.getFailure());
                                ((DataStore)FabricServiceImpl.this.dataStore.get()).deleteContainer(this.val$fabricService, this.val$containerOptions.getName());
                            }
                            this.val$metadatas.add(metadata);
                        }
                        catch (Throwable t) {
                            CreateContainerBasicMetadata metadata = new CreateContainerBasicMetadata();
                            metadata.setContainerName(containerName);
                            metadata.setCreateOptions(this.val$containerOptions);
                            metadata.setFailure(t);
                            this.val$metadatas.add(metadata);
                            ((DataStore)FabricServiceImpl.this.dataStore.get()).deleteContainer(this.val$fabricService, this.val$containerOptions.getName());
                        }
                        finally {
                            this.val$latch.countDown();
                        }
                    }
                }.start();
            }
            if (!latch.await(30L, TimeUnit.MINUTES)) {
                throw new FabricException("Timeout waiting for container creation");
            }
            return metadatas.toArray(new CreateContainerMetadata[metadatas.size()]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create containers " + e, (Throwable)e);
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    protected void validateProfileDependencies(CreateContainerOptions options) {
        Map profileDependencies = Profiles.getOverlayFactoryConfigurations((FabricService)this, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.profile.dependency");
        Set entries = profileDependencies.entrySet();
        for (Map.Entry entry : entries) {
            String configName = (String)entry.getKey();
            Map exportConfig = (Map)entry.getValue();
            if (exportConfig == null || exportConfig.isEmpty()) continue;
            ProfileDependencyConfig config = new ProfileDependencyConfig();
            try {
                this.configurer.configure(exportConfig, (Object)config, new String[0]);
            }
            catch (Exception e) {
                throw new FabricException("Failed to load configuration for " + configName + " of " + config + " due to: " + e, (Throwable)e);
            }
            if (!ProfileDependencyKind.ZOOKEEPER_SERVICE.equals((Object)config.getKind())) continue;
            try {
                List children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)config.getZookeeperPath());
                if (children == null || children.isEmpty()) {
                    throw new ProfileDependencyException(options.getProfiles(), config.getProfileWildcards(), config.getProfileTags(), config.getSummary());
                }
                boolean dependencyFound = false;
                Iterator childIterator = children.iterator();
                while (!dependencyFound && childIterator.hasNext()) {
                    String containerName = (String)childIterator.next();
                    Container container = this.getContainer(containerName);
                    Profile[] profiles = container.getProfiles();
                    int profileCount = 0;
                    while (!dependencyFound && profileCount < profiles.length) {
                        Profile profile = profiles[profileCount];
                        if (config.getProfileWildcards() != null) {
                            for (String profileWildcard : config.getProfileWildcards()) {
                                if (!profile.getId().contains(profileWildcard)) continue;
                                dependencyFound = true;
                                break;
                            }
                        }
                        if (dependencyFound || config.getProfileTags() == null) continue;
                        List profileTags = profile.getTags();
                        int foundTags = 0;
                        for (String configProfileTag : config.getProfileTags()) {
                            if (!profileTags.contains(configProfileTag)) continue;
                            ++foundTags;
                        }
                        if (foundTags != config.getProfileTags().length) continue;
                        dependencyFound = true;
                    }
                }
                if (dependencyFound) continue;
                throw new ProfileDependencyException(options.getProfiles(), config.getProfileWildcards(), config.getProfileTags(), config.getSummary());
            }
            catch (Exception e) {
                throw new ProfileDependencyException(options.getProfiles(), config.getProfileWildcards(), config.getProfileTags(), config.getSummary(), (Throwable)e);
            }
        }
    }

    public Set<Class<? extends CreateContainerBasicOptions>> getSupportedCreateContainerOptionTypes() {
        this.assertValid();
        HashSet<Class<? extends CreateContainerBasicOptions>> optionTypes = new HashSet<Class<? extends CreateContainerBasicOptions>>();
        for (Map.Entry<String, ContainerProvider> entry : this.providers.entrySet()) {
            optionTypes.add(entry.getValue().getOptionsType());
        }
        return optionTypes;
    }

    public Set<Class<? extends CreateContainerBasicMetadata>> getSupportedCreateContainerMetadataTypes() {
        this.assertValid();
        HashSet<Class<? extends CreateContainerBasicMetadata>> metadataTypes = new HashSet<Class<? extends CreateContainerBasicMetadata>>();
        for (Map.Entry<String, ContainerProvider> entry : this.providers.entrySet()) {
            metadataTypes.add(entry.getValue().getMetadataType());
        }
        return metadataTypes;
    }

    public ContainerProvider getProvider(String scheme) {
        return this.providers.get(scheme);
    }

    public Map<String, ContainerProvider> getValidProviders() {
        this.assertValid();
        HashMap<String, ContainerProvider> validProviders = new HashMap<String, ContainerProvider>();
        for (ContainerProvider cp : this.getProviders().values()) {
            if (!cp.isValidProvider()) continue;
            validProviders.put(cp.getScheme(), cp);
        }
        return Collections.unmodifiableMap(validProviders);
    }

    public Map<String, ContainerProvider> getProviders() {
        this.assertValid();
        return Collections.unmodifiableMap(this.providers);
    }

    public String getRestAPI() {
        this.assertValid();
        String restApiFolder = ZkPath.REST_API_CLUSTERS.getPath(new String[]{"FabricResource/fabric8"});
        try {
            CuratorFramework curatorFramework = (CuratorFramework)this.curator.get();
            if (curatorFramework != null) {
                List versions = ZooKeeperUtils.getChildrenSafe((CuratorFramework)curatorFramework, (String)restApiFolder);
                for (String version : versions) {
                    String versionPath = restApiFolder + "/" + version;
                    List containers = ZooKeeperUtils.getChildrenSafe((CuratorFramework)curatorFramework, (String)versionPath);
                    for (String container : containers) {
                        String containerPath = versionPath + "/" + container;
                        String answer = this.getFirstService(containerPath);
                        if (Strings.isNullOrEmpty((String)answer)) continue;
                        return answer;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to find API " + restApiFolder + ". " + e, (Throwable)e);
        }
        return null;
    }

    protected String getFirstService(String containerPath) throws Exception {
        List services;
        ObjectMapper mapper;
        Map map;
        Object serviceValue;
        String text;
        byte[] data;
        CuratorFramework curatorFramework = (CuratorFramework)this.curator.get();
        if (curatorFramework != null && (data = (byte[])curatorFramework.getData().forPath(containerPath)) != null && data.length > 0 && !(text = new String(data).trim()).isEmpty() && (serviceValue = (map = (Map)(mapper = new ObjectMapper()).readValue(data, HashMap.class)).get("services")) instanceof List && (services = (List)serviceValue) != null && !services.isEmpty()) {
            ArrayList serviceTexts = new ArrayList();
            for (Object service : services) {
                String serviceText = ZooKeeperUtils.getSubstitutedData((CuratorFramework)curatorFramework, (String)service.toString());
                if (!io.fabric8.common.util.Strings.isNotBlank((String)serviceText)) continue;
                return serviceText;
            }
        }
        return null;
    }

    public String getGitUrl() {
        this.assertValid();
        String restApiFolder = ZkPath.GIT.getPath(new String[0]);
        try {
            CuratorFramework curatorFramework = (CuratorFramework)this.curator.get();
            if (curatorFramework != null) {
                List versions = ZooKeeperUtils.getChildrenSafe((CuratorFramework)curatorFramework, (String)restApiFolder);
                for (String version : versions) {
                    String versionPath = restApiFolder + "/" + version;
                    String answer = this.getFirstService(versionPath);
                    if (Strings.isNullOrEmpty((String)answer)) continue;
                    return answer;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to find API " + restApiFolder + ". " + e, (Throwable)e);
        }
        return null;
    }

    public String getWebConsoleUrl() {
        Container[] containers = null;
        try {
            containers = this.getContainers();
        }
        catch (Exception e) {
            LOGGER.debug("Ignored exception trying to find containers: " + e, (Throwable)e);
            return null;
        }
        for (Container aContainer : containers) {
            Profile[] profiles;
            for (Profile aProfile : profiles = aContainer.getProfiles()) {
                String id = aProfile.getId();
                if (!id.equals("fabric")) continue;
                return this.profileWebAppURL("io.hawt.hawtio-web", id, aProfile.getVersion());
            }
        }
        return null;
    }

    public URI getMavenRepoURI() {
        this.assertValid();
        URI uri = URI.create(this.getDefaultRepo());
        try {
            List children;
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"})) != null && (children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}))) != null && !children.isEmpty()) {
                Collections.sort(children);
                String mavenRepo = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}) + "/" + (String)children.get(0)));
                if (mavenRepo != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public List<URI> getMavenRepoURIs() {
        this.assertValid();
        try {
            ArrayList<URI> uris = new ArrayList<URI>();
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"})) != null) {
                List children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}));
                if (children != null && !children.isEmpty()) {
                    Collections.sort(children);
                }
                if (children != null) {
                    for (String child : children) {
                        String mavenRepo = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}) + "/" + child));
                        if (mavenRepo != null && !mavenRepo.endsWith("/")) {
                            mavenRepo = mavenRepo + "/";
                        }
                        uris.add(new URI(mavenRepo));
                    }
                }
            }
            return uris;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public URI getMavenRepoUploadURI() {
        this.assertValid();
        URI uri = URI.create(this.getDefaultRepo());
        try {
            List children;
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"})) != null && (children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}))) != null && !children.isEmpty()) {
                Collections.sort(children);
                String mavenRepo = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}) + "/" + (String)children.get(0)));
                if (mavenRepo != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public String profileWebAppURL(String webAppId, String profileId, String versionId) {
        Version version;
        if ((versionId == null || versionId.length() == 0) && (version = this.getDefaultVersion()) != null) {
            versionId = version.getId();
        }
        List containers = Containers.containersForProfile((Container[])this.getContainers(), (String)profileId, (String)versionId);
        for (Container container : containers) {
            String url = this.containerWebAppURL(webAppId, container.getId());
            if (url == null || url.length() <= 0) continue;
            return url;
        }
        return null;
    }

    public String containerWebAppURL(String webAppId, String name) {
        this.assertValid();
        String answer = this.containerWebAppUrl(ZkPath.WEBAPPS_CLUSTER.getPath(new String[]{webAppId}), name);
        if (answer == null) {
            answer = this.containerWebAppUrl(ZkPath.SERVLETS_CLUSTER.getPath(new String[]{webAppId}), name);
        }
        return answer;
    }

    private String containerWebAppUrl(String versionsPath, String name) {
        try {
            List children;
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)versionsPath) != null && (children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)versionsPath)) != null && !children.isEmpty()) {
                for (String child : children) {
                    if (Strings.isNullOrEmpty((String)name)) {
                        String containerPath;
                        String answer;
                        String parentPath = versionsPath + "/" + child;
                        List grandChildren = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)parentPath);
                        if (grandChildren.isEmpty() || Strings.isNullOrEmpty((String)(answer = this.getWebUrl(containerPath = parentPath + "/" + (String)grandChildren.get(0))))) continue;
                        return answer;
                    }
                    String childPath = versionsPath + "/" + child;
                    String containerPath = childPath + "/" + name;
                    String answer = this.getWebUrl(containerPath);
                    if (Strings.isNullOrEmpty((String)answer)) {
                        answer = this.containerWebAppUrl(childPath, name);
                    }
                    if (Strings.isNullOrEmpty((String)answer)) continue;
                    return answer;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to find container Jolokia URL " + e, (Throwable)e);
        }
        return null;
    }

    private String getWebUrl(String containerPath) throws Exception {
        if (((CuratorFramework)this.curator.get()).checkExists().forPath(containerPath) != null) {
            int startIndex;
            int endIdx;
            byte[] bytes = ZkPath.loadURL((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPath);
            String text = new String(bytes);
            String prefix = "\"services\":[\"";
            int idx = text.indexOf(prefix);
            String answer = text;
            if (idx > 0 && (endIdx = text.indexOf("\"]", startIndex = idx + prefix.length())) > 0 && (answer = text.substring(startIndex, endIdx)).length() > 0) {
                answer = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)answer);
                return answer;
            }
        }
        return null;
    }

    private static boolean hasValidDataStoreProperties(Map options) {
        if (!options.containsKey("dataStoreProperties")) {
            return false;
        }
        Object props = options.get("dataStoreProperties");
        if (props instanceof Map) {
            return !((Map)props).isEmpty();
        }
        return false;
    }

    public void registerProvider(String scheme, ContainerProvider provider) {
        this.assertValid();
        this.providers.put(scheme, provider);
    }

    public void registerProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.assertValid();
        String scheme = (String)properties.get("fabric.container.protocol");
        this.registerProvider(scheme, provider);
    }

    public void unregisterProvider(String scheme) {
        this.assertValid();
        this.providers.remove(scheme);
    }

    public void unregisterProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.assertValid();
        String scheme = (String)properties.get("fabric.container.protocol");
        this.unregisterProvider(scheme);
    }

    public String getZookeeperUrl() {
        this.assertValid();
        return this.getZookeeperInfo("zookeeper.url");
    }

    public String getZooKeeperUser() {
        this.assertValid();
        String answer = null;
        try {
            answer = this.getZookeeperInfo("zookeeper.user");
        }
        catch (Exception e) {
            LOGGER.warn("could not find zookeeper.user: " + e, (Throwable)e);
        }
        if (Strings.isNullOrEmpty((String)answer)) {
            answer = "admin";
        }
        return answer;
    }

    public String getZookeeperPassword() {
        this.assertValid();
        String rawZookeeperPassword = this.getZookeeperInfo("zookeeper.password");
        if (rawZookeeperPassword != null) {
            return PasswordEncoder.decode(rawZookeeperPassword);
        }
        return null;
    }

    public String getZookeeperInfo(String name) {
        this.assertValid();
        String zooKeeperUrl = null;
        try {
            Map zookeeperConfig;
            Profile profile;
            Version defaultVersion;
            if (((CuratorFramework)this.curator.get()).getZookeeperClient().isConnected() && (defaultVersion = this.getDefaultVersion()) != null && (profile = defaultVersion.getRequiredProfile("default")) != null && (zookeeperConfig = profile.getConfiguration("io.fabric8.zookeeper")) != null) {
                zooKeeperUrl = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)((String)zookeeperConfig.get(name)));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (zooKeeperUrl == null) {
            try {
                Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.zookeeper", null);
                zooKeeperUrl = (String)config.getProperties().get(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zooKeeperUrl;
    }

    public String getDefaultVersionId() {
        this.assertValid();
        return ((DataStore)this.dataStore.get()).getDefaultVersion();
    }

    public Version getDefaultVersion() {
        this.assertValid();
        String versionId = ((DataStore)this.dataStore.get()).getDefaultVersion();
        return ((ProfileService)this.profileService.get()).getVersion(versionId);
    }

    public Version getRequiredDefaultVersion() {
        this.assertValid();
        String versionId = ((DataStore)this.dataStore.get()).getDefaultVersion();
        return ((ProfileService)this.profileService.get()).getRequiredVersion(versionId);
    }

    public void setDefaultVersionId(String versionId) {
        this.assertValid();
        ((DataStore)this.dataStore.get()).setDefaultVersion(versionId);
    }

    public void setRequirements(FabricRequirements requirements) throws IOException {
        this.assertValid();
        FabricServiceImpl.validateRequirements(this, requirements);
        ((DataStore)this.dataStore.get()).setRequirements(requirements);
    }

    public static void validateRequirements(FabricService fabricService, FabricRequirements requirements) {
        ProfileService profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        String versionId = requirements.getVersion();
        Version version = !Strings.isNullOrEmpty((String)versionId) ? profileService.getRequiredVersion(versionId) : fabricService.getDefaultVersion();
        HashSet<String> profileIds = new HashSet<String>(Profiles.profileIds((Iterable)version.getProfiles()));
        List profileRequirements = requirements.getProfileRequirements();
        for (ProfileRequirements profileRequirement : profileRequirements) {
            FabricServiceImpl.validateProfileRequirements(fabricService, requirements, profileRequirement, profileIds);
        }
    }

    protected static void validateProfileRequirements(FabricService fabricService, FabricRequirements requirements, ProfileRequirements profileRequirement, Set<String> profileIds) {
        profileRequirement.validate();
        Profiles.assertValidProfileId(profileIds, (String)profileRequirement.getProfile());
        List dependentProfiles = profileRequirement.getDependentProfiles();
        if (dependentProfiles != null) {
            for (String dependentProfile : dependentProfiles) {
                Profiles.assertValidProfileId(profileIds, (String)dependentProfile);
            }
        }
    }

    public FabricRequirements getRequirements() {
        this.assertValid();
        FabricRequirements requirements = ((DataStore)this.dataStore.get()).getRequirements();
        requirements.setVersion(this.getDefaultVersionId());
        return requirements;
    }

    public AutoScaleStatus getAutoScaleStatus() {
        this.assertValid();
        return ((DataStore)this.dataStore.get()).getAutoScaleStatus();
    }

    public FabricStatus getFabricStatus() {
        this.assertValid();
        return new FabricStatus((FabricService)this);
    }

    public PatchService getPatchService() {
        this.assertValid();
        return new PatchServiceImpl(this);
    }

    public String getDefaultJvmOptions() {
        this.assertValid();
        return ((DataStore)this.dataStore.get()).getDefaultJvmOptions();
    }

    public void setDefaultJvmOptions(String jvmOptions) {
        this.assertValid();
        ((DataStore)this.dataStore.get()).setDefaultJvmOptions(jvmOptions);
    }

    public String getConfigurationValue(String versionId, String profileId, String pid, String key) {
        this.assertValid();
        Profile pr = ((ProfileService)this.profileService.get()).getRequiredProfile(versionId, profileId);
        Map configs = pr.getFileConfigurations();
        byte[] b = (byte[])configs.get(pid);
        Properties p = null;
        try {
            p = b != null ? DataStoreUtils.toProperties(b) : new Properties();
        }
        catch (Throwable t) {
            throw new FabricException(t);
        }
        return p.getProperty(key);
    }

    public void setConfigurationValue(String versionId, String profileId, String pid, String key, String value) {
        this.assertValid();
        Version version = ((ProfileService)this.profileService.get()).getRequiredVersion(versionId);
        Profile profile = version.getRequiredProfile(profileId);
        Map configs = profile.getFileConfigurations();
        byte[] bytes = (byte[])configs.get(pid);
        Properties properties = bytes != null ? DataStoreUtils.toProperties(bytes) : new Properties();
        properties.setProperty(key, value);
        bytes = DataStoreUtils.toBytes(properties);
        configs.put(pid, bytes);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.setFileConfigurations(configs);
        ((ProfileService)this.profileService.get()).updateProfile(builder.getProfile());
    }

    public boolean scaleProfile(String profile, int numberOfInstances) throws IOException {
        boolean update;
        if (numberOfInstances == 0) {
            throw new IllegalArgumentException("numberOfInstances should be greater or less than zero");
        }
        FabricRequirements requirements = this.getRequirements();
        ProfileRequirements profileRequirements = requirements.getOrCreateProfileRequirement(profile);
        Integer minimumInstances = profileRequirements.getMinimumInstances();
        List containers = Containers.containersForProfile((Container[])this.getContainers(), (String)profile);
        int containerCount = containers.size();
        int newCount = containerCount + numberOfInstances;
        if (newCount < 0) {
            newCount = 0;
        }
        boolean bl = update = minimumInstances == null || newCount != minimumInstances;
        if (update) {
            profileRequirements.setMinimumInstances(Integer.valueOf(newCount));
            this.setRequirements(requirements);
        }
        return update;
    }

    public ContainerAutoScaler createContainerAutoScaler(FabricRequirements requirements, ProfileRequirements profileRequirements) {
        Collection<ContainerProvider> providerCollection = this.getProviders().values();
        for (ContainerProvider containerProvider : providerCollection) {
            Integer key;
            ContainerAutoScalerFactory provider;
            ContainerAutoScaler autoScaler;
            TreeMap<Integer, ContainerAutoScaler> sortedAutoScalers = new TreeMap<Integer, ContainerAutoScaler>();
            if (containerProvider instanceof ContainerAutoScalerFactory && (autoScaler = (provider = (ContainerAutoScalerFactory)containerProvider).createAutoScaler(requirements, profileRequirements)) != null) {
                int weight = autoScaler.getWeight();
                sortedAutoScalers.put(weight, autoScaler);
            }
            if (sortedAutoScalers.isEmpty() || (key = (Integer)sortedAutoScalers.lastKey()) == null) continue;
            return (ContainerAutoScaler)sortedAutoScalers.get(key);
        }
        return null;
    }

    public Map<String, Map<String, String>> substituteConfigurations(Map<String, Map<String, String>> configurations) {
        final HashMap<String, PlaceholderResolver> resolversSnapshot = new HashMap<String, PlaceholderResolver>(this.placeholderResolvers);
        Set<String> requiredSchemes = PlaceholderResolverHelpers.getSchemesForProfileConfigurations(configurations);
        Set availableSchemes = resolversSnapshot.keySet();
        if (!availableSchemes.containsAll(requiredSchemes)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Missing Placeholder Resolvers:");
            for (String scheme : requiredSchemes) {
                if (availableSchemes.contains(scheme)) continue;
                sb.append(" ").append(scheme);
            }
            throw new FabricException(sb.toString());
        }
        final HashMap<String, Map<String, String>> mutableConfigurations = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : configurations.entrySet()) {
            String key = entry.getKey();
            HashMap<String, String> value = new HashMap<String, String>(entry.getValue());
            mutableConfigurations.put(key, value);
        }
        final FabricServiceImpl fabricService = this;
        for (Map.Entry entry : mutableConfigurations.entrySet()) {
            final String pid = (String)entry.getKey();
            Map props = (Map)entry.getValue();
            for (Map.Entry e : props.entrySet()) {
                final String key = (String)e.getKey();
                String value = (String)e.getValue();
                props.put(key, InterpolationHelper.substVars((String)value, (String)key, null, (Map)props, (InterpolationHelper.SubstitutionCallback)new InterpolationHelper.SubstitutionCallback(){

                    public String getValue(String toSubstitute) {
                        if (toSubstitute != null && toSubstitute.contains(":")) {
                            String scheme = toSubstitute.substring(0, toSubstitute.indexOf(":"));
                            return ((PlaceholderResolver)resolversSnapshot.get(scheme)).resolve(fabricService, mutableConfigurations, pid, key, toSubstitute);
                        }
                        return DataStoreUtils.substituteBundleProperty(toSubstitute, FabricServiceImpl.this.bundleContext);
                    }
                }));
            }
        }
        return mutableConfigurations;
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    @VisibleForTesting
    public void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    @VisibleForTesting
    public void bindCurator(CuratorFramework service) {
        this.curator.bind((Object)service);
    }

    void unbindCurator(CuratorFramework service) {
        this.curator.unbind((Object)service);
    }

    @VisibleForTesting
    public void bindDataStore(DataStore service) {
        this.dataStore.bind((Object)service);
    }

    void unbindDataStore(DataStore service) {
        this.dataStore.unbind((Object)service);
    }

    void bindPortService(PortService service) {
        this.portService.bind((Object)service);
    }

    void unbindPortService(PortService service) {
        this.portService.unbind((Object)service);
    }

    void bindProfileService(ProfileService service) {
        this.profileService.bind((Object)service);
    }

    void unbindProfileService(ProfileService service) {
        this.profileService.unbind((Object)service);
    }

    void bindProfileRegistry(ProfileRegistry service) {
        this.profileRegistry.bind((Object)service);
    }

    void unbindProfileRegistry(ProfileRegistry service) {
        this.profileRegistry.unbind((Object)service);
    }

    void bindProvider(ContainerProvider provider) {
        this.providers.put(provider.getScheme(), provider);
    }

    void unbindProvider(ContainerProvider provider) {
        this.providers.remove(provider.getScheme());
    }

    @VisibleForTesting
    public void bindPlaceholderResolver(PlaceholderResolver resolver) {
        String resolverScheme = resolver.getScheme();
        this.placeholderResolvers.put(resolverScheme, resolver);
    }

    void unbindPlaceholderResolver(PlaceholderResolver resolver) {
        String resolverScheme = resolver.getScheme();
        this.placeholderResolvers.remove(resolverScheme);
    }

    protected void bindChecksumPlaceholderResolver(ChecksumPlaceholderResolver checksumPlaceholderResolver) {
        this.checksumPlaceholderResolver = checksumPlaceholderResolver;
    }

    protected void unbindChecksumPlaceholderResolver(ChecksumPlaceholderResolver checksumPlaceholderResolver) {
        if (this.checksumPlaceholderResolver == checksumPlaceholderResolver) {
            this.checksumPlaceholderResolver = null;
        }
    }

    protected void bindContainerPlaceholderResolver(ContainerPlaceholderResolver containerPlaceholderResolver) {
        this.containerPlaceholderResolver = containerPlaceholderResolver;
    }

    protected void unbindContainerPlaceholderResolver(ContainerPlaceholderResolver containerPlaceholderResolver) {
        if (this.containerPlaceholderResolver == containerPlaceholderResolver) {
            this.containerPlaceholderResolver = null;
        }
    }

    protected void bindEncryptedPropertyResolver(EncryptedPropertyResolver encryptedPropertyResolver) {
        this.encryptedPropertyResolver = encryptedPropertyResolver;
    }

    protected void unbindEncryptedPropertyResolver(EncryptedPropertyResolver encryptedPropertyResolver) {
        if (this.encryptedPropertyResolver == encryptedPropertyResolver) {
            this.encryptedPropertyResolver = null;
        }
    }

    protected void bindEnvPlaceholderResolver(EnvPlaceholderResolver envPlaceholderResolver) {
        this.envPlaceholderResolver = envPlaceholderResolver;
    }

    protected void unbindEnvPlaceholderResolver(EnvPlaceholderResolver envPlaceholderResolver) {
        if (this.envPlaceholderResolver == envPlaceholderResolver) {
            this.envPlaceholderResolver = null;
        }
    }

    protected void bindPortPlaceholderResolver(PortPlaceholderResolver portPlaceholderResolver) {
        this.portPlaceholderResolver = portPlaceholderResolver;
    }

    protected void unbindPortPlaceholderResolver(PortPlaceholderResolver portPlaceholderResolver) {
        if (this.portPlaceholderResolver == portPlaceholderResolver) {
            this.portPlaceholderResolver = null;
        }
    }

    protected void bindProfilePropertyPointerResolver(ProfilePropertyPointerResolver profilePropertyPointerResolver) {
        this.profilePropertyPointerResolver = profilePropertyPointerResolver;
    }

    protected void unbindProfilePropertyPointerResolver(ProfilePropertyPointerResolver profilePropertyPointerResolver) {
        if (this.profilePropertyPointerResolver == profilePropertyPointerResolver) {
            this.profilePropertyPointerResolver = null;
        }
    }

    protected void bindVersionPropertyPointerResolver(VersionPropertyPointerResolver versionPropertyPointerResolver) {
        this.versionPropertyPointerResolver = versionPropertyPointerResolver;
    }

    protected void unbindVersionPropertyPointerResolver(VersionPropertyPointerResolver versionPropertyPointerResolver) {
        if (this.versionPropertyPointerResolver == versionPropertyPointerResolver) {
            this.versionPropertyPointerResolver = null;
        }
    }

    protected void bindZookeeperPlaceholderResolver(ZookeeperPlaceholderResolver zookeeperPlaceholderResolver) {
        this.zookeeperPlaceholderResolver = zookeeperPlaceholderResolver;
    }

    protected void unbindZookeeperPlaceholderResolver(ZookeeperPlaceholderResolver zookeeperPlaceholderResolver) {
        if (this.zookeeperPlaceholderResolver == zookeeperPlaceholderResolver) {
            this.zookeeperPlaceholderResolver = null;
        }
    }

    protected void bindContainerRegistration(ContainerRegistration containerRegistration) {
        this.containerRegistration = containerRegistration;
    }

    protected void unbindContainerRegistration(ContainerRegistration containerRegistration) {
        if (this.containerRegistration == containerRegistration) {
            this.containerRegistration = null;
        }
    }

    protected void bindBootstrapConfig(BootstrapConfiguration bootstrapConfiguration) {
        this.bootstrapConfig = bootstrapConfiguration;
    }

    protected void unbindBootstrapConfig(BootstrapConfiguration bootstrapConfiguration) {
        if (this.bootstrapConfig == bootstrapConfiguration) {
            this.bootstrapConfig = null;
        }
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

