/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.PortService;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.support.Strings;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.portservice.zookeeper", label="Fabric8 ZooKeeper Port Service", metatype=false)
@Service(value={PortService.class})
public final class ZookeeperPortService
extends AbstractComponent
implements PortService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperPortService.class);
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private InterProcessSemaphoreV2 interProcessLock;

    @Activate
    void activate() {
        this.interProcessLock = new InterProcessSemaphoreV2((CuratorFramework)this.curator.get(), ZkPath.PORTS_LOCK.getPath(new String[0]), 1);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int registerPort(Container container, String pid, String key, int fromPort, int toPort, Set<Integer> excludes) {
        this.assertValid();
        Lease lease = null;
        try {
            Set<Integer> boundPorts;
            int port;
            lease = this.interProcessLock.acquire(60L, TimeUnit.SECONDS);
            if (lease != null) {
                port = this.lookupPort(container, pid, key);
                if (port > 0) {
                    int n = port;
                    this.releaseLock(lease);
                    return n;
                }
                boundPorts = this.findUsedPortByHost(container, lease);
                boundPorts.addAll(excludes);
            } else {
                throw new FabricException("Could not acquire port lock for pid " + pid);
            }
            for (port = fromPort; port <= toPort; ++port) {
                if (boundPorts.contains(port)) continue;
                this.registerPort(container, pid, key, port, lease);
                int n = port;
                this.releaseLock(lease);
                return n;
            }
            throw new FabricException("Could not find port within range [" + fromPort + "," + toPort + "] for pid " + pid);
            catch (InterruptedException ex) {
                this.cleanUpDirtyZKNodes(this.interProcessLock);
                throw FabricException.launderThrowable((Throwable)ex);
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            this.releaseLock(lease);
            throw throwable;
        }
    }

    private void registerPort(Container container, String pid, String key, int port, Lease existingLease) {
        block9: {
            this.assertValid();
            String portAsString = String.valueOf(port);
            String containerPortsPath = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key});
            String ip = container.getIp();
            ZookeeperPortService.assertValidIp(container, ip);
            String ipPortsPath = ZkPath.PORTS_IP.getPath(new String[]{ip});
            Lease lease = null;
            try {
                lease = existingLease != null ? existingLease : this.interProcessLock.acquire(60L, TimeUnit.SECONDS);
                if (lease != null) {
                    ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath, (String)portAsString);
                    ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath, (String)portAsString);
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath, (String)portAsString);
                    String existingPorts = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath);
                    if (!existingPorts.contains(portAsString)) {
                        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath, (String)(existingPorts + " " + portAsString));
                    }
                    break block9;
                }
                throw new FabricException("Could not acquire port lock for pid " + pid);
            }
            catch (InterruptedException ex) {
                this.cleanUpDirtyZKNodes(this.interProcessLock);
                throw FabricException.launderThrowable((Throwable)ex);
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                if (existingLease == null) {
                    this.releaseLock(lease);
                }
            }
        }
    }

    protected static void assertValidIp(Container container, String ip) {
        if (Strings.isNullOrBlank((String)ip)) {
            throw new IllegalArgumentException("No IP defined for container " + container.getId());
        }
    }

    public void registerPort(Container container, String pid, String key, int port) {
        this.registerPort(container, pid, key, port, (PortService.Lock)null);
    }

    public void registerPort(Container container, String pid, String key, int port, PortService.Lock lock) {
        Lease lease = null;
        if (lock != null && lock instanceof LeaseLock) {
            lease = ((LeaseLock)lock).getLease();
        }
        this.registerPort(container, pid, key, port, lease);
    }

    private void unregisterPort(Container container, String pid, String key, Lease existingLease) {
        block11: {
            this.assertValid();
            String containerPortsPidKeyPath = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key});
            String ip = container.getIp();
            ZookeeperPortService.assertValidIp(container, ip);
            String ipPortsPath = ZkPath.PORTS_IP.getPath(new String[]{ip});
            Lease lease = null;
            try {
                lease = existingLease != null ? existingLease : this.interProcessLock.acquire(60L, TimeUnit.SECONDS);
                if (lease != null) {
                    if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidKeyPath) != null) {
                        int port = this.lookupPort(container, pid, key);
                        ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidKeyPath);
                        Set<Integer> allPorts = this.findUsedPortByHost(container, lease);
                        allPorts.remove(port);
                        StringBuilder sb = new StringBuilder();
                        boolean first = true;
                        for (Integer p : allPorts) {
                            if (first) {
                                sb.append(p);
                                first = false;
                                continue;
                            }
                            sb.append(" ").append(p);
                        }
                        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath, (String)sb.toString());
                    }
                    break block11;
                }
                throw new FabricException("Could not acquire port lock for pid " + pid);
            }
            catch (InterruptedException ex) {
                this.cleanUpDirtyZKNodes(this.interProcessLock);
                throw FabricException.launderThrowable((Throwable)ex);
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                if (existingLease == null) {
                    this.releaseLock(lease);
                }
            }
        }
    }

    public void unregisterPort(Container container, String pid, String key) {
        this.unregisterPort(container, pid, key, null);
    }

    private void unregisterPort(Container container, String pid, Lease existingLease) {
        block10: {
            this.assertValid();
            String containerPortsPidPath = ZkPath.PORTS_CONTAINER_PID.getPath(new String[]{container.getId(), pid});
            Lease lease = null;
            try {
                lease = existingLease != null ? existingLease : this.interProcessLock.acquire(60L, TimeUnit.SECONDS);
                if (lease != null) {
                    if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidPath) != null) {
                        for (String key : ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidPath)) {
                            this.unregisterPort(container, pid, key, lease);
                        }
                        ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidPath);
                    }
                    break block10;
                }
                throw new FabricException("Could not acquire port lock for pid " + pid);
            }
            catch (InterruptedException ex) {
                this.cleanUpDirtyZKNodes(this.interProcessLock);
                throw FabricException.launderThrowable((Throwable)ex);
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                if (existingLease == null) {
                    this.releaseLock(lease);
                }
            }
        }
    }

    public void unregisterPort(Container container, String pid) {
        this.unregisterPort(container, pid, (Lease)null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterPort(Container container) {
        this.assertValid();
        String containerPortsPath = ZkPath.PORTS_CONTAINER.getPath(new String[]{container.getId()});
        Lease lease = null;
        try {
            lease = this.interProcessLock.acquire(60L, TimeUnit.SECONDS);
            if (lease == null) throw new FabricException("Could not acquire port lock");
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath) != null) {
                for (String pid : ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath)) {
                    this.unregisterPort(container, pid, lease);
                }
                ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath);
            }
            this.releaseLock(lease);
            return;
        }
        catch (InterruptedException ex) {
            try {
                this.cleanUpDirtyZKNodes(this.interProcessLock);
                throw FabricException.launderThrowable((Throwable)ex);
                catch (Exception ex2) {
                    throw FabricException.launderThrowable((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                this.releaseLock(lease);
                throw throwable;
            }
        }
    }

    public int lookupPort(Container container, String pid, String key) {
        this.assertValid();
        int port = 0;
        String path = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key});
        try {
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path) != null) {
                port = Integer.parseInt(ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path));
            }
        }
        catch (InterruptedException ex) {
            this.cleanUpDirtyZKNodes(this.interProcessLock);
            throw FabricException.launderThrowable((Throwable)ex);
        }
        catch (Exception ex) {
            throw FabricException.launderThrowable((Throwable)ex);
        }
        return port;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Integer> findUsedPortByContainer(Container container) {
        this.assertValid();
        ports = new HashSet<Integer>();
        path = ZkPath.PORTS_CONTAINER.getPath(new String[]{container.getId()});
        lease = null;
        try {
            lease = this.interProcessLock.acquire(60L, TimeUnit.SECONDS);
            if (lease == null) throw new FabricException("Could not acquire port lock");
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path) == null) ** GOTO lbl12
            i$ = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path).iterator();
            while (true) {
                block11: {
                    if (i$.hasNext()) break block11;
lbl12:
                    // 2 sources

                    this.releaseLock(lease);
                    return ports;
                }
                pid = (String)i$.next();
                i$ = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.PORTS_CONTAINER_PID.getPath(new String[]{container.getId(), pid})).iterator();
                break;
            }
        }
        catch (InterruptedException ex) {
            try {
                this.cleanUpDirtyZKNodes(this.interProcessLock);
                throw FabricException.launderThrowable((Throwable)ex);
                catch (Exception ex) {
                    throw FabricException.launderThrowable((Throwable)ex);
                }
            }
            catch (Throwable var11_13) {
                this.releaseLock(lease);
                throw var11_13;
            }
        }
        while (true) {
            if (!i$.hasNext()) ** continue;
            key = (String)i$.next();
            port = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key}));
            try {
                ports.add(Integer.parseInt(port));
            }
            catch (Exception ex) {
            }
        }
    }

    public PortService.Lock acquirePortLock() throws Exception {
        return new LeaseLock(this.interProcessLock.acquire(60L, TimeUnit.SECONDS));
    }

    public void releasePortLock(PortService.Lock lock) {
        if (lock instanceof LeaseLock) {
            this.interProcessLock.returnLease(((LeaseLock)lock).getLease());
        }
    }

    private Set<Integer> findUsedPortByHost(Container container, Lease existingLease) {
        HashSet<Integer> ports;
        block12: {
            this.assertValid();
            String ip = container.getIp();
            ZookeeperPortService.assertValidIp(container, ip);
            ports = new HashSet<Integer>();
            String path = ZkPath.PORTS_IP.getPath(new String[]{ip});
            Lease lease = null;
            try {
                lease = existingLease != null ? existingLease : this.interProcessLock.acquire(60L, TimeUnit.SECONDS);
                if (lease != null) {
                    ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)"");
                    String boundPorts = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                    if (boundPorts != null && !boundPorts.isEmpty()) {
                        for (String port : boundPorts.split(" ")) {
                            try {
                                ports.add(Integer.parseInt(port.trim()));
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                    }
                    break block12;
                }
                throw new FabricException("Could not acquire port lock");
            }
            catch (InterruptedException ex) {
                this.cleanUpDirtyZKNodes(this.interProcessLock);
                throw FabricException.launderThrowable((Throwable)ex);
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                if (existingLease == null) {
                    this.releaseLock(lease);
                }
            }
        }
        return ports;
    }

    public Set<Integer> findUsedPortByHost(Container container) {
        return this.findUsedPortByHost(container, (PortService.Lock)null);
    }

    public Set<Integer> findUsedPortByHost(Container container, PortService.Lock lock) {
        Lease lease = null;
        if (lock != null && lock instanceof LeaseLock) {
            lease = ((LeaseLock)lock).getLease();
        }
        return this.findUsedPortByHost(container, lease);
    }

    private void releaseLock(Lease lease) {
        try {
            if (this.interProcessLock != null) {
                this.interProcessLock.returnLease(lease);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Couldn't realease lock for " + ZkPath.PORTS_LOCK.getPath(new String[0]), (Throwable)e);
        }
    }

    private void cleanUpDirtyZKNodes(InterProcessSemaphoreV2 interProcessLock) {
        if (interProcessLock != null) {
            try {
                LOGGER.info("Cleaning eventual partial nodes");
                Collection participantNodes = interProcessLock.getParticipantNodes();
                for (String nodePath : participantNodes) {
                    String path = "/fabric/registry/ports/lock/leases/" + nodePath;
                    LOGGER.debug("Remove dirty zk lock node: {}", (Object)path);
                    ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while cleaning zk partial nodes", (Throwable)e);
            }
        } else {
            LOGGER.info("No registerPort leftovers nodes found");
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    private class LeaseLock
    implements PortService.Lock {
        private Lease lease;

        public LeaseLock(Lease lease) {
            this.lease = lease;
        }

        public Lease getLease() {
            return this.lease;
        }
    }
}

