/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jolokia;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.jolokia.JolokiaSecureHttpContext;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.jolokia.osgi.servlet.JolokiaServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.jolokia", label="Fabric8 Jolokia", policy=ConfigurationPolicy.OPTIONAL, metatype=true, immediate=true)
public class FabricJolokia
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricJolokia.class);
    @Property(name="alias", label="Servlet Alias", description="Servlet Alias", value={"/jolokia"})
    private String alias;
    @Property(name="realm", label="Jaas Realm", description="Jaas Realm", value={"karaf"})
    private String realm;
    @Property(name="role", label="Jaas Role", description="Jaas Role", value={"admin"})
    private String role;
    private HttpContext context;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=HttpService.class)
    private final ValidatingReference<HttpService> httpService = new ValidatingReference();

    @Activate
    void activate(BundleContext bundleContext, Map<String, String> properties) throws Exception {
        this.configurer.configure(properties, (Object)this);
        this.context = new JolokiaSecureHttpContext(this.realm, this.role);
        ((HttpService)this.httpService.get()).registerServlet(this.getServletAlias(), (Servlet)new JolokiaServlet(bundleContext), new Hashtable(), this.context);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        try {
            ((HttpService)this.httpService.get()).unregister(this.getServletAlias());
        }
        catch (Throwable t) {
            LOGGER.warn("Error while unregistering jolokia.");
        }
    }

    public String getServletAlias() {
        return this.alias;
    }

    void bindHttpService(HttpService service) {
        this.httpService.bind((Object)service);
    }

    void unbindHttpService(HttpService service) {
        this.httpService.unbind((Object)service);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

