/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations.gracefulDisconnect;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.extended.operations.gracefulDisconnect.GracefulDisconnect;
import org.apache.directory.shared.ldap.codec.extended.operations.gracefulDisconnect.GracefulDisconnectContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.gracefulDisconnect.GracefulDisconnectStatesEnum;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulDisconnectGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(GracefulDisconnectGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new GracefulDisconnectGrammar();
    GrammarAction storeDelay = new GrammarAction("Set Graceful Disconnect Delay"){

        public void action(IAsn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                int delay = IntegerDecoder.parse(value, 0, 86400);
                if (IS_DEBUG) {
                    log.debug("Delay = " + delay);
                }
                gracefulDisconnectContainer.getGracefulDisconnect().setDelay(delay);
                gracefulDisconnectContainer.grammarEndAllowed(true);
            }
            catch (IntegerDecoderException e) {
                String msg = I18n.err("ERR_04036", StringTools.dumpBytes(value.getData()));
                log.error(msg);
                throw new DecoderException(msg);
            }
        }
    };
    GrammarAction storeReferral = new GrammarAction("Stores a referral"){

        public void action(IAsn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                LdapURL url = new LdapURL(value.getData());
                gracefulDisconnectContainer.getGracefulDisconnect().addReplicatedContexts(url);
                gracefulDisconnectContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Stores a referral : {}", (Object)url);
                }
            }
            catch (LdapURLEncodingException e) {
                String msg = "failed to decode the URL '" + StringTools.dumpBytes(value.getData()) + "'";
                log.error(msg);
                throw new DecoderException(msg);
            }
        }
    };
    GrammarAction storeTimeOffline = new GrammarAction("Set Graceful Disconnect time offline"){

        public void action(IAsn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                int timeOffline = IntegerDecoder.parse(value, 0, 720);
                if (IS_DEBUG) {
                    log.debug("Time Offline = " + timeOffline);
                }
                gracefulDisconnectContainer.getGracefulDisconnect().setTimeOffline(timeOffline);
                gracefulDisconnectContainer.grammarEndAllowed(true);
            }
            catch (IntegerDecoderException e) {
                String msg = I18n.err("ERR_04037", StringTools.dumpBytes(value.getData()));
                log.error(msg);
                throw new DecoderException(msg);
            }
        }
    };

    private GracefulDisconnectGrammar() {
        this.name = GracefulDisconnectGrammar.class.getName();
        this.statesEnum = GracefulDisconnectStatesEnum.getInstance();
        this.transitions = new GrammarTransition[6][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, new GrammarAction("Init Graceful Disconnect"){

            public void action(IAsn1Container container) {
                GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
                GracefulDisconnect gracefulDisconnect = new GracefulDisconnect();
                gracefulDisconnectContainer.setGracefulDisconnect(gracefulDisconnect);
                gracefulDisconnectContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[1][2] = new GrammarTransition(1, 2, 2, this.storeTimeOffline);
        this.transitions[1][128] = new GrammarTransition(1, 3, 128, this.storeDelay);
        this.transitions[1][48] = new GrammarTransition(1, 4, 48, null);
        this.transitions[2][128] = new GrammarTransition(2, 3, 128, this.storeDelay);
        this.transitions[2][48] = new GrammarTransition(2, 4, 48, null);
        this.transitions[3][48] = new GrammarTransition(3, 4, 48, null);
        this.transitions[4][4] = new GrammarTransition(4, 5, 4, this.storeReferral);
        this.transitions[5][4] = new GrammarTransition(5, 5, 4, this.storeReferral);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

