/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.entryChange;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.asn1.util.LongDecoder;
import org.apache.directory.shared.asn1.util.LongDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.search.controls.entryChange.EntryChangeControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.entryChange.EntryChangeControlStatesEnum;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryChangeControlGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(EntryChangeControlGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new EntryChangeControlGrammar();

    private EntryChangeControlGrammar() {
        this.name = EntryChangeControlGrammar.class.getName();
        this.statesEnum = EntryChangeControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[5][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, null);
        this.transitions[1][10] = new GrammarTransition(1, 2, 10, new GrammarAction("Set EntryChangeControl changeType"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                try {
                    int change = IntegerDecoder.parse(value, 1, 8);
                    switch (change) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            ChangeType changeType = ChangeType.getChangeType(change);
                            if (IS_DEBUG) {
                                log.debug("changeType = " + changeType);
                            }
                            entryChangeContainer.getEntryChangeControl().setChangeType(changeType);
                            break;
                        }
                        default: {
                            String msg = I18n.err("ERR_04044", new Object[0]);
                            log.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                    entryChangeContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err("ERR_04044", new Object[0]);
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[2][4] = new GrammarTransition(2, 3, 4, new GrammarAction("Set EntryChangeControl previousDN"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                ChangeType changeType = entryChangeContainer.getEntryChangeControl().getChangeType();
                if (changeType != ChangeType.MODDN) {
                    log.error(I18n.err("ERR_04045", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_04046", new Object[0]));
                }
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                DN previousDn = null;
                try {
                    previousDn = new DN(StringTools.utf8ToString(value.getData()));
                }
                catch (LdapInvalidDnException ine) {
                    log.error(I18n.err("ERR_04047", StringTools.dumpBytes(value.getData())));
                    throw new DecoderException(I18n.err("ERR_04048", new Object[0]));
                }
                if (IS_DEBUG) {
                    log.debug("previousDN = " + previousDn);
                }
                entryChangeContainer.getEntryChangeControl().setPreviousDn(previousDn);
                entryChangeContainer.grammarEndAllowed(true);
            }
        });
        GrammarAction setChangeNumberAction = new GrammarAction("Set EntryChangeControl changeNumber"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                try {
                    long changeNumber = LongDecoder.parse(value);
                    if (IS_DEBUG) {
                        log.debug("changeNumber = " + changeNumber);
                    }
                    entryChangeContainer.getEntryChangeControl().setChangeNumber(changeNumber);
                    entryChangeContainer.grammarEndAllowed(true);
                }
                catch (LongDecoderException e) {
                    String msg = I18n.err("ERR_04049", new Object[0]);
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        };
        this.transitions[3][2] = new GrammarTransition(3, 4, 2, setChangeNumberAction);
        this.transitions[2][2] = new GrammarTransition(2, 4, 2, setChangeNumberAction);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

