/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal;

import io.fabric8.api.FabricException;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.partition.BalancingPolicy;
import io.fabric8.partition.TaskContext;
import io.fabric8.partition.WorkItemListener;
import io.fabric8.partition.WorkItemRepository;
import io.fabric8.partition.WorkerNode;
import io.fabric8.zookeeper.ZkPath;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCoordinator
implements GroupListener<WorkerNode>,
WorkItemListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCoordinator.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final TaskContext context;
    private final WorkItemRepository repository;
    private final BalancingPolicy balancingPolicy;
    private final Group<WorkerNode> group;
    private final CuratorFramework curator;

    public TaskCoordinator(TaskContext context, WorkItemRepository repository, BalancingPolicy balancingPolicy, CuratorFramework curator) {
        this.context = context;
        this.repository = repository;
        this.balancingPolicy = balancingPolicy;
        this.curator = curator;
        this.group = new ZooKeeperGroup(curator, ZkPath.TASK.getPath(new String[]{context.getId()}), WorkerNode.class);
    }

    public void start() {
        this.group.add((GroupListener)this);
        this.repository.addListener(this);
        this.group.start();
    }

    public void stop() {
        this.repository.removeListener(this);
        try {
            this.group.close();
        }
        catch (IOException e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    WorkerNode createNode() {
        WorkerNode state = new WorkerNode(this.context.getId());
        return state;
    }

    public void groupEvent(Group<WorkerNode> group, GroupListener.GroupEvent event) {
        switch (event) {
            case CONNECTED: 
            case CHANGED: {
                WorkerNode state = this.createNode();
                if (group.isMaster()) {
                    this.repository.start();
                    state.setServices(new String[]{this.context.getId()});
                    group.update((NodeState)state);
                    this.partitionUpdated();
                    break;
                }
                group.update((NodeState)state);
                this.repository.stop();
                break;
            }
            case DISCONNECTED: {
                this.repository.stop();
            }
        }
    }

    @Override
    public void partitionUpdated() {
        LOGGER.info("Rebalancing work for {}.", (Object)this.context.getId());
        this.executorService.submit(new RebalanceTask());
    }

    public void rebalance() {
        List<String> workItems = this.repository.listWorkItemLocations();
        Set<String> members = this.group.members().keySet();
        this.balancingPolicy.rebalance(this.context, workItems, members);
    }

    private class RebalanceTask
    implements Runnable {
        private RebalanceTask() {
        }

        @Override
        public void run() {
            TaskCoordinator.this.rebalance();
        }
    }
}

