/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TablePrinter {
    private List<Column> columns = new ArrayList<Column>();
    private Map<String, Column> columnMap = new HashMap<String, Column>();
    private String columnSeparator = "  ";
    private List<String[]> rows = new ArrayList<String[]>();

    public void columns(String ... headers) {
        for (String header : headers) {
            this.column(header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column column(String header) {
        List<Column> list = this.columns;
        synchronized (list) {
            Column answer = this.columnMap.get(header);
            if (answer == null) {
                answer = new Column(header);
                this.columns.add(answer);
                this.columnMap.put(header, answer);
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column column(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index must be >= 0");
        }
        List<Column> list = this.columns;
        synchronized (list) {
            Column answer = null;
            if (index < this.columns.size()) {
                answer = this.columns.get(index);
            }
            if (answer == null) {
                answer = new Column("");
                this.columns.add(answer);
            }
            return answer;
        }
    }

    public void row(String ... values) {
        int columnIndex = 0;
        for (String value : values) {
            Column column = this.column(columnIndex++);
            if (value == null) continue;
            int length = value.length();
            column.ensureWidth(length);
        }
        this.rows.add(values);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        boolean first = true;
        for (Column column : this.columns) {
            if (first) {
                first = false;
            } else {
                out.print(this.columnSeparator);
            }
            column.printHeader(out);
        }
        out.println();
        for (String[] row : this.rows) {
            first = true;
            int i = 0;
            for (Column column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    out.print(this.columnSeparator);
                }
                String value = null;
                if (i < row.length) {
                    value = row[i];
                }
                if (value == null) {
                    value = "";
                }
                ++i;
                column.printValue(out, value);
            }
            out.println();
        }
    }

    public static class Column {
        private final String headerText;
        private String header;
        private String headerFlags = "-";
        private String rowFlags = "-";
        private int width = 1;

        public Column(String header) {
            this.header = header;
            this.headerText = "[" + header + "]";
            this.ensureWidth(this.headerText.length());
        }

        public String getHeader() {
            return this.header;
        }

        public String getHeaderFlags() {
            return this.headerFlags;
        }

        public void setHeaderFlags(String headerFlags) {
            this.headerFlags = headerFlags;
        }

        public String getRowFlags() {
            return this.rowFlags;
        }

        public void setRowFlags(String rowFlags) {
            this.rowFlags = rowFlags;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void ensureWidth(int length) {
            if (length > this.width) {
                this.width = length;
            }
        }

        public void printHeader(PrintStream out) {
            String formatText = "%" + this.headerFlags + this.width + "s";
            out.printf(formatText, this.headerText);
        }

        public void printValue(PrintStream out, String value) {
            String formatText = "%" + this.rowFlags + this.width + "s";
            out.printf(formatText, value);
        }
    }
}

