/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.project.support;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import io.fabric8.project.support.IniFileUtils;
import io.fabric8.project.support.UserDetails;
import io.fabric8.utils.Files;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.ssl.TrustEverythingSSLTrustManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitUtils.class);
    private static final int DEFAULT_RETRIES = 5;
    private static final String GITSSH_REGEX = "^(?<gitssh>git\\@)(?<domain>github\\.com)\\:?(?<repo>.*)$";
    static final Pattern GITHUB_GIT_URL_PATTERN = Pattern.compile("^(?<gitssh>git\\@)(?<domain>github\\.com)\\:?(?<repo>.*)$");
    static final Pattern GITHUB_HTTPS_URL_PATTERN = Pattern.compile("^(?<proto>http[s]?://)(?<domain>github\\.com.*)$");

    public static File getRootGitDirectory(Git git) {
        return git.getRepository().getDirectory().getParentFile();
    }

    public static String toString(Collection<RemoteRefUpdate> updates) {
        StringBuilder builder = new StringBuilder();
        for (RemoteRefUpdate update : updates) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(update.getMessage() + " " + update.getRemoteName() + " " + update.getNewObjectId());
        }
        return builder.toString();
    }

    public static void disableSslCertificateChecks() {
        LOG.info("Trusting all SSL certificates");
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new TrustEverythingSSLTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Failed to bypass certificate check", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOG.warn("Failed to bypass certificate check", (Throwable)e);
        }
    }

    public static String getRemoteURL(Git git, String branch) {
        Repository repository = git.getRepository();
        return GitUtils.getRemoteURL(repository, branch);
    }

    public static String getRemoteURL(Repository repository) throws IOException {
        if (repository != null) {
            return GitUtils.getRemoteURL(repository, "origin");
        }
        return null;
    }

    public static String getRemoteAsHttpsURL(Repository repository) throws IOException {
        String remoteURL;
        if (repository != null && (remoteURL = GitUtils.getRemoteURL(repository, "origin")) != null) {
            return GitUtils.buildHttpsFromSSHURL(remoteURL);
        }
        return null;
    }

    public static String getRemoteAsHttpsURL(Repository repository, String remoteName) {
        StoredConfig config;
        if (repository != null && (config = repository.getConfig()) != null) {
            String remoteURL = config.getString("remote", remoteName, "url");
            return GitUtils.buildHttpsFromSSHURL(remoteURL);
        }
        return null;
    }

    public static String getRemoteURL(Repository repository, String remoteName) {
        StoredConfig config;
        if (repository != null && (config = repository.getConfig()) != null) {
            String remoteURL = "";
            return config.getString("remote", remoteName, "url");
        }
        return null;
    }

    private static String buildHttpsFromSSHURL(String remoteURL) {
        Matcher matcher = GITHUB_GIT_URL_PATTERN.matcher(remoteURL);
        if (matcher.find()) {
            return remoteURL.replaceAll(GITSSH_REGEX, "https://$2/$3");
        }
        return remoteURL;
    }

    public static void configureBranch(Git git, String branch, String origin, String remoteRepository) {
        if (!Strings.isNullOrBlank((String)branch)) {
            StoredConfig config = git.getRepository().getConfig();
            config.setString("branch", branch, "remote", origin);
            config.setString("branch", branch, "merge", "refs/heads/" + branch);
            config.setString("remote", origin, "url", remoteRepository);
            config.setString("remote", origin, "fetch", "+refs/heads/*:refs/remotes/" + origin + "/*");
            try {
                config.save();
            }
            catch (IOException e) {
                LOG.error("Failed to save the git configuration to " + git.getRepository().getDirectory() + " with branch " + branch + " on " + origin + " remote repo: " + remoteRepository + " due: " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
            }
        }
    }

    public static void addFiles(Git git, File ... files) throws GitAPIException, IOException {
        File rootDir = GitUtils.getRootGitDirectory(git);
        for (File file : files) {
            String relativePath = GitUtils.getFilePattern(rootDir, file);
            git.add().addFilepattern(relativePath).call();
        }
    }

    public static String getFilePattern(File rootDir, File file) throws IOException {
        String relativePath = Files.getRelativePath((File)rootDir, (File)file);
        if (relativePath.startsWith(File.separator)) {
            relativePath = relativePath.substring(1);
        }
        return relativePath.replace(File.separatorChar, '/');
    }

    public static RevCommit doCommitAndPush(Git git, String message, UserDetails userDetails, PersonIdent author, String branch, String origin, boolean pushOnCommit, int pushRetries) throws GitAPIException {
        CommitCommand commit = git.commit().setAll(true).setMessage(message);
        if (author != null) {
            commit = commit.setAuthor(author);
        }
        RevCommit answer = commit.call();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committed " + answer.getId() + " " + answer.getFullMessage());
        }
        if (pushOnCommit) {
            GitAPIException exception = null;
            for (int i = 1; i <= pushRetries; ++i) {
                try {
                    if (i > 1) {
                        try {
                            Thread.sleep(700L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        LOG.info("Retrying git push attempt " + i);
                    }
                    PushCommand push = git.push();
                    GitUtils.configureCommand(push, userDetails);
                    Iterable results = push.setRemote(origin).call();
                    for (PushResult result : results) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Pushed " + result.getMessages() + " " + result.getURI() + " branch: " + branch + " updates: " + GitUtils.toString(result.getRemoteUpdates()));
                    }
                    return answer;
                }
                catch (GitAPIException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    LOG.error("Failed to git push attempt " + i + " with " + (Object)((Object)e), (Throwable)e);
                    continue;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        return answer;
    }

    public static void doAddCommitAndPushFiles(Git git, UserDetails userDetails, PersonIdent personIdent, String branch, String origin, String message, boolean pushOnCommit) throws GitAPIException {
        git.add().addFilepattern(".").call();
        GitUtils.doCommitAndPush(git, message, userDetails, personIdent, branch, origin, pushOnCommit, 5);
    }

    public static void doAddCommitAndPushFiles(Git git, UserDetails userDetails, PersonIdent personIdent, String branch, String origin, String message, boolean pushOnCommit, int pushRetries) throws GitAPIException {
        git.add().addFilepattern(".").call();
        GitUtils.doCommitAndPush(git, message, userDetails, personIdent, branch, origin, pushOnCommit, pushRetries);
    }

    public static Date getCommitDate(RevCommit commit) {
        if (commit == null) {
            return new Date(0L);
        }
        return new Date((long)commit.getCommitTime() * 1000L);
    }

    public static <C extends GitCommand> void configureCommand(TransportCommand<C, ?> command, UserDetails userDetails) {
        GitUtils.configureCommand(command, userDetails.createCredentialsProvider(), userDetails.getSshPrivateKey(), userDetails.getSshPublicKey());
        command.setCredentialsProvider(userDetails.createCredentialsProvider());
    }

    public static <C extends GitCommand> void configureCommand(TransportCommand<C, ?> command, CredentialsProvider credentialsProvider, final File sshPrivateKey, final File sshPublicKey) {
        LOG.info("Using " + credentialsProvider);
        if (sshPrivateKey != null) {
            final CredentialsProvider provider = credentialsProvider;
            command.setTransportConfigCallback(new TransportConfigCallback(){

                public void configure(Transport transport) {
                    if (transport instanceof SshTransport) {
                        SshTransport sshTransport = (SshTransport)transport;
                        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                            protected void configure(OpenSshConfig.Host host, Session session) {
                                session.setConfig("StrictHostKeyChecking", "no");
                                CredentialsProviderUserInfo userInfo = new CredentialsProviderUserInfo(session, provider);
                                session.setUserInfo((UserInfo)userInfo);
                            }

                            protected JSch createDefaultJSch(FS fs) throws JSchException {
                                JSch jsch = super.createDefaultJSch(fs);
                                jsch.removeAllIdentity();
                                String absolutePath = sshPrivateKey.getAbsolutePath();
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Adding identity privateKey: " + sshPrivateKey + " publicKey: " + sshPublicKey);
                                }
                                if (sshPublicKey != null) {
                                    jsch.addIdentity(absolutePath, sshPublicKey.getAbsolutePath(), null);
                                } else {
                                    jsch.addIdentity(absolutePath);
                                }
                                return jsch;
                            }
                        };
                        sshTransport.setSshSessionFactory((SshSessionFactory)sshSessionFactory);
                    }
                }
            });
        }
    }

    public static void addDummyFileToEmptyFolders(File dir) {
        if (dir != null && dir.isDirectory()) {
            File[] children = dir.listFiles();
            if (children == null || children.length == 0) {
                File dummyFile = new File(dir, ".gitkeep");
                try {
                    IOHelpers.writeFully((File)dummyFile, (String)"This file is only here to avoid git removing empty folders\nOnce there are files in this folder feel free to delete this file!");
                }
                catch (IOException e) {
                    LOG.warn("Failed to write file " + dummyFile + ". " + e, (Throwable)e);
                }
            } else {
                for (File child : children) {
                    if (!child.isDirectory()) continue;
                    GitUtils.addDummyFileToEmptyFolders(child);
                }
            }
        }
    }

    public static Repository findRepository(File baseDir) throws IOException {
        File gitFolder = GitHelpers.findGitFolder((File)baseDir);
        if (gitFolder == null) {
            return null;
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).setGitDir(gitFolder)).build();
        return repository;
    }

    public static Map<String, Properties> parseGitConfig() throws IOException {
        String homeDir = System.getProperty("user.home", ".");
        File file = new File(homeDir, ".gitconfig");
        if (file.exists() && file.isFile()) {
            return IniFileUtils.parseIniFile(file);
        }
        return new HashMap<String, Properties>();
    }

    public static String getGitHostName(String gitUrl) {
        try {
            URI uri = new URI(gitUrl);
            return uri.getHost();
        }
        catch (URISyntaxException uri) {
            String[] split = gitUrl.split(":");
            if (split.length > 1) {
                String prefix = split[0];
                int idx = prefix.indexOf(64);
                if (idx >= 0) {
                    return prefix.substring(idx + 1);
                }
                return prefix;
            }
            return null;
        }
    }

    public static String getGitProtocol(String gitUrl) {
        try {
            URI uri = new URI(gitUrl);
            return uri.getScheme();
        }
        catch (URISyntaxException uri) {
            String prefix;
            int idx;
            String[] split = gitUrl.split(":");
            if (split.length > 1 && (idx = (prefix = split[0]).indexOf(64)) >= 0) {
                return "ssh";
            }
            return null;
        }
    }
}

