/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.metrics.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.common.util.IOHelpers;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.TrackingZooKeeperGroup;
import io.fabric8.insight.metrics.model.MBeanAttrs;
import io.fabric8.insight.metrics.model.MBeanOpers;
import io.fabric8.insight.metrics.model.MetricsJSON;
import io.fabric8.insight.metrics.model.MetricsStorageService;
import io.fabric8.insight.metrics.model.Query;
import io.fabric8.insight.metrics.model.QueryResult;
import io.fabric8.insight.metrics.model.Server;
import io.fabric8.insight.metrics.service.MetricsCollectorMBean;
import io.fabric8.insight.metrics.service.support.JmxUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollector
implements MetricsCollectorMBean {
    public static final String GRAPH_JSON = "io.fabric8.insight.metrics.json";
    public static final String QUERIES = "queries";
    public static final String NAME = "name";
    public static final String TEMPLATE = "template";
    public static final String METADATA = "metadata";
    public static final String LOCK = "lock";
    public static final String PERIOD = "period";
    public static final String MIN_PERIOD = "minPeriod";
    public static final String REQUESTS = "requests";
    public static final String OBJ = "obj";
    public static final String ATTRS = "attrs";
    public static final String OPER = "oper";
    public static final String ARGS = "args";
    public static final String SIG = "sig";
    public static final String DEFAULT = "default";
    public static final String LOCK_GLOBAL = "global";
    public static final String LOCK_HOST = "host";
    private static final transient Logger LOG = LoggerFactory.getLogger(MetricsCollector.class);
    private ObjectName objectName;
    private BundleContext bundleContext;
    private FabricService fabricService;
    private ScheduledThreadPoolExecutor executor;
    private Map<Query, QueryState> queries = new ConcurrentHashMap<Query, QueryState>();
    private ServiceTracker<MBeanServer, MBeanServer> mbeanServer;
    private ServiceTracker<MetricsStorageService, MetricsStorageService> storage;
    private int defaultDelay = 60;
    private int threadPoolSize = 5;
    private String type;

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setDefaultDelay(int defaultDelay) {
        this.defaultDelay = defaultDelay;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    @Override
    public String getMetrics() {
        HashMap<String, Map> meta = new HashMap<String, Map>();
        for (Map.Entry<Query, QueryState> e : this.queries.entrySet()) {
            meta.put(e.getKey().getName(), e.getValue().metadata);
        }
        return MetricsJSON.toJson(meta);
    }

    public void start() throws IOException {
        this.executor = new ScheduledThreadPoolExecutor(this.threadPoolSize);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.mbeanServer = new ServiceTracker(this.bundleContext, MBeanServer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<MBeanServer, MBeanServer>(){

            public MBeanServer addingService(ServiceReference<MBeanServer> reference) {
                MBeanServer service = (MBeanServer)MetricsCollector.this.bundleContext.getService(reference);
                try {
                    service.registerMBean(MetricsCollector.this, MetricsCollector.this.objectName);
                }
                catch (Exception e) {
                    LOG.info("Unable to register metrics collector mbean", (Throwable)e);
                }
                return service;
            }

            public void modifiedService(ServiceReference<MBeanServer> reference, MBeanServer service) {
            }

            public void removedService(ServiceReference<MBeanServer> reference, MBeanServer service) {
                try {
                    service.unregisterMBean(MetricsCollector.this.objectName);
                }
                catch (Exception e) {
                    LOG.info("Unable to unregister metrics collector mbean", (Throwable)e);
                }
                MetricsCollector.this.bundleContext.ungetService(reference);
            }
        });
        this.storage = new ServiceTracker(this.bundleContext, MetricsStorageService.class, null);
        this.mbeanServer.open();
        this.storage.open();
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MetricsCollector.this.process();
            }
        }, 1L, this.defaultDelay, TimeUnit.SECONDS);
    }

    public void stop() throws Exception {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.mbeanServer.close();
        this.storage.close();
        for (QueryState q : this.queries.values()) {
            q.close();
        }
    }

    public void process() {
        try {
            Container container = this.fabricService.getCurrentContainer();
            if (container != null) {
                HashSet<Query> newQueries = new HashSet<Query>();
                Profile[] profiles = container.getProfiles();
                if (profiles != null) {
                    for (Profile profile : profiles) {
                        this.loadProfile(profile, newQueries);
                    }
                }
                for (Query q : this.queries.keySet()) {
                    if (newQueries.remove(q)) continue;
                    this.queries.remove(q).close();
                }
                Server server = new Server(container.getId());
                for (Query q : newQueries) {
                    final String queryName = q.getName();
                    final String containerName = container.getId();
                    final QueryState state = new QueryState();
                    state.server = server;
                    state.query = q;
                    if (q.getMetadata() != null) {
                        state.metadata = MetricsJSON.parseJson((String)IOHelpers.loadFully((URL)new URL(q.getMetadata())));
                    }
                    if (q.getLock() != null) {
                        state.lock = new TrackingZooKeeperGroup(this.bundleContext, this.getGroupPath(q), QueryNodeState.class);
                        state.lock.add((GroupListener)new GroupListener<QueryNodeState>(){

                            public void groupEvent(Group<QueryNodeState> group, GroupListener.GroupEvent event) {
                                try {
                                    String[] stringArray;
                                    Group<QueryNodeState> group2 = state.lock;
                                    if (state.lock.isMaster()) {
                                        String[] stringArray2 = new String[1];
                                        stringArray = stringArray2;
                                        stringArray2[0] = "stat";
                                    } else {
                                        stringArray = null;
                                    }
                                    group2.update((NodeState)new QueryNodeState(queryName, containerName, stringArray));
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                            }
                        });
                        state.lock.update((NodeState)new QueryNodeState(queryName, containerName, null));
                        state.lock.start();
                    }
                    long delay = q.getPeriod() > 0 ? (long)q.getPeriod() : (long)this.defaultDelay;
                    state.future = this.executor.scheduleAtFixedRate(new Task(state), Math.round(Math.random() * 1000.0) + 1L, delay * 1000L, TimeUnit.MILLISECONDS);
                    this.queries.put(q, state);
                }
            }
        }
        catch (RejectedExecutionException t) {
        }
        catch (Throwable t) {
            LOG.warn("Error while starting metrics", t);
        }
    }

    protected synchronized String getGroupPath(Query q) {
        if (LOCK_GLOBAL.equals(q.getLock())) {
            return "/fabric/registry/clusters/insight-metrics/global/" + q.getName();
        }
        if (LOCK_HOST.equals(q.getLock())) {
            String host;
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to retrieve host name", e);
            }
            return "/fabric/registry/clusters/insight-metrics/host-" + host + "/" + q.getName();
        }
        throw new IllegalArgumentException("Unknown lock type: " + q.getLock());
    }

    protected void loadProfile(Profile profile, Set<Query> queries) {
        Map fileConfigurations = profile.getFileConfigurations();
        byte[] bytes = (byte[])fileConfigurations.get(GRAPH_JSON);
        if (bytes != null && bytes.length > 0) {
            try {
                Map object = (Map)new ObjectMapper().readValue(bytes, Map.class);
                for (Map q : (List)object.get(QUERIES)) {
                    int period;
                    String name = (String)q.get(NAME);
                    String template = (String)q.get(TEMPLATE);
                    String metadata = (String)q.get(METADATA);
                    String lock = (String)q.get(LOCK);
                    int n = DEFAULT.equals(q.get(PERIOD)) ? this.defaultDelay : (period = q.get(PERIOD) != null ? ((Number)q.get(PERIOD)).intValue() : this.defaultDelay);
                    int minPeriod = DEFAULT.equals(q.get(MIN_PERIOD)) ? this.defaultDelay : (q.get(MIN_PERIOD) != null ? ((Number)q.get(MIN_PERIOD)).intValue() : period);
                    HashSet<Object> requests = new HashSet<Object>();
                    for (Map mb : (List)q.get(REQUESTS)) {
                        String mobj;
                        String mname;
                        if (mb.containsKey(ATTRS)) {
                            mname = (String)mb.get(NAME);
                            mobj = (String)mb.get(OBJ);
                            List mattrs = (List)mb.get(ATTRS);
                            requests.add(new MBeanAttrs(mname, mobj, mattrs));
                            continue;
                        }
                        if (mb.containsKey(OPER)) {
                            mname = (String)mb.get(NAME);
                            mobj = (String)mb.get(OBJ);
                            String moper = (String)mb.get(OPER);
                            List margs = (List)mb.get(ARGS);
                            List msig = (List)mb.get(SIG);
                            requests.add(new MBeanOpers(mname, mobj, moper, margs, msig));
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown request " + MetricsJSON.toJson((Object)mb));
                    }
                    queries.add(new Query(name, requests, template, metadata, lock, period, minPeriod));
                }
            }
            catch (Throwable t) {
                LOG.warn("Unable to load queries from profile " + profile.getId(), t);
            }
        }
        for (Profile p : profile.getParents()) {
            this.loadProfile(p, queries);
        }
    }

    class Task
    implements Runnable {
        private final QueryState query;

        public Task(QueryState query) {
            this.query = query;
        }

        @Override
        public void run() {
            try {
                boolean forceSend;
                MBeanServer mbs = (MBeanServer)MetricsCollector.this.mbeanServer.getService();
                MetricsStorageService svc = (MetricsStorageService)MetricsCollector.this.storage.getService();
                if (mbs == null || svc == null) {
                    return;
                }
                if (this.query.lock != null && !this.query.lock.isMaster()) {
                    return;
                }
                QueryResult qrs = JmxUtils.execute(this.query.server, this.query.query, mbs);
                boolean bl = forceSend = this.query.query.getMinPeriod() == this.query.query.getPeriod() || qrs.getTimestamp().getTime() - this.query.lastSent >= TimeUnit.SECONDS.toMillis(this.query.query.getMinPeriod());
                if (!forceSend && this.query.lastResult != null) {
                    if (qrs.getResults().equals(this.query.lastResult.getResults())) {
                        this.query.lastResult = qrs;
                        this.query.lastResultSent = false;
                        return;
                    }
                    if (!this.query.lastResultSent) {
                        this.renderAndSend(svc, this.query.lastResult);
                    }
                }
                this.query.lastResult = qrs;
                this.query.lastResultSent = true;
                this.query.lastSent = qrs.getTimestamp().getTime();
                this.renderAndSend(svc, qrs);
            }
            catch (Throwable e) {
                LOG.debug("Error sending metrics", e);
            }
        }

        private void renderAndSend(MetricsStorageService svc, QueryResult qrs) throws Exception {
            long timestamp = qrs.getTimestamp().getTime();
            svc.store(MetricsCollector.this.type, timestamp, qrs);
        }
    }

    static class QueryNodeState
    extends NodeState {
        @JsonProperty
        String[] services;

        QueryNodeState() {
        }

        QueryNodeState(String id, String container, String[] services) {
            super(id, container);
            this.services = services;
        }
    }

    static class QueryState {
        ScheduledFuture<?> future;
        Server server;
        Query query;
        QueryResult lastResult;
        boolean lastResultSent;
        long lastSent;
        Map metadata;
        Group<QueryNodeState> lock;

        QueryState() {
        }

        public void close() {
            this.future.cancel(false);
            if (this.lock != null) {
                try {
                    this.lock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

