/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.metrics.service.support;

import io.fabric8.insight.metrics.model.MBeanAttrResult;
import io.fabric8.insight.metrics.model.MBeanAttrs;
import io.fabric8.insight.metrics.model.MBeanAttrsResult;
import io.fabric8.insight.metrics.model.MBeanOperResult;
import io.fabric8.insight.metrics.model.MBeanOpers;
import io.fabric8.insight.metrics.model.MBeanOpersResult;
import io.fabric8.insight.metrics.model.Query;
import io.fabric8.insight.metrics.model.QueryResult;
import io.fabric8.insight.metrics.model.Request;
import io.fabric8.insight.metrics.model.Result;
import io.fabric8.insight.metrics.model.Server;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public class JmxUtils {
    public static QueryResult execute(Server server, Query query, MBeanServer mbs) throws JMException {
        HashMap<String, Result> queryResults = new HashMap<String, Result>();
        for (Request request : query.getRequests()) {
            queryResults.put(request.getName(), JmxUtils.execute(server, request, mbs));
        }
        return new QueryResult(server, query, new Date(), queryResults);
    }

    private static Result execute(Server server, Request request, MBeanServer mbs) throws JMException {
        if (request instanceof MBeanAttrs) {
            return JmxUtils.execute(server, (MBeanAttrs)request, mbs);
        }
        if (request instanceof MBeanOpers) {
            return JmxUtils.execute(server, (MBeanOpers)request, mbs);
        }
        throw new IllegalArgumentException("Unsupported request " + request);
    }

    public static MBeanOpersResult execute(Server server, MBeanOpers request, MBeanServer mbs) throws JMException {
        ArrayList<MBeanOperResult> results = new ArrayList<MBeanOperResult>();
        Set<ObjectName> mbeans = mbs.queryNames(new ObjectName(request.getObj()), null);
        for (ObjectName mbean : mbeans) {
            List args = request.getArgs();
            List sig = request.getSig();
            Object value = mbs.invoke(mbean, request.getOper(), args.toArray(new Object[args.size()]), sig.toArray(new String[sig.size()]));
            results.add(new MBeanOperResult(mbean, JmxUtils.getJmxValue(value)));
        }
        return new MBeanOpersResult(request, results);
    }

    public static MBeanAttrsResult execute(Server server, MBeanAttrs request, MBeanServer mbs) throws JMException {
        ArrayList<MBeanAttrResult> results = new ArrayList<MBeanAttrResult>();
        Set<ObjectName> mbeans = mbs.queryNames(new ObjectName(request.getObj()), null);
        for (ObjectName mbean : mbeans) {
            List attrs = request.getAttrs();
            AttributeList al = mbs.getAttributes(mbean, attrs.toArray(new String[attrs.size()]));
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Attribute attribute : al.asList()) {
                values.put(attribute.getName(), JmxUtils.getJmxValue(attribute.getValue()));
            }
            results.add(new MBeanAttrResult(mbean, values));
        }
        return new MBeanAttrsResult(request, results);
    }

    private static Object getJmxValue(Object value) {
        if (value instanceof CompositeDataSupport) {
            CompositeDataSupport cds = (CompositeDataSupport)((Object)value);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : cds.getCompositeType().keySet()) {
                map.put(key, JmxUtils.getJmxValue(cds.get(key)));
            }
            value = map;
        }
        return value;
    }
}

