/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.assertions.Conditions;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.util.Lists;

public class PodsAssert
extends ListAssert<Pod> {
    public PodsAssert(List<Pod> actual) {
        super(actual);
    }

    public PodsAssert filter(Condition<Pod> condition) {
        return PodsAssert.assertThat(Filters.filter((Iterable)((Iterable)this.actual)).having(condition).get());
    }

    public IntegerAssert assertSize() {
        return (IntegerAssert)Assertions.assertThat((int)this.get().size()).as("size", new Object[0]);
    }

    public List<Pod> get() {
        return (List)this.actual;
    }

    public PodsAssert filterLabel(String key, String value) {
        return this.filter(Conditions.podLabel(key, value));
    }

    public PodsAssert runningStatus() {
        return this.filter(Conditions.runningStatus());
    }

    public PodsAssert waitingStatus() {
        return this.filter(Conditions.waitingStatus());
    }

    public PodsAssert errorStatus() {
        return this.filter(Conditions.errorStatus());
    }

    protected static PodsAssert assertThat(Iterable<Pod> result) {
        ArrayList list = Lists.newArrayList(result);
        return new PodsAssert(list);
    }
}

