/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatusType;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Condition;

public class Conditions {
    public static <T extends HasMetadata> Condition<T> hasLabel(final String key, final String value) {
        return new Condition<T>(){

            public String toString() {
                return "hasLabel(" + key + " = " + value + ")";
            }

            public boolean matches(T resource) {
                return Conditions.matchesLabel(resource.getMetadata().getLabels(), key, value);
            }
        };
    }

    public static <T extends HasMetadata> Condition<T> hasName(final String name) {
        return new Condition<T>(){

            public String toString() {
                return "hasName(" + name + ")";
            }

            public boolean matches(T resource) {
                return Objects.equals(name, resource.getMetadata().getName());
            }
        };
    }

    public static <T extends HasMetadata> Condition<T> hasNamespace(final String namespace) {
        return new Condition<T>(){

            public String toString() {
                return "hasNamespace(" + namespace + ")";
            }

            public boolean matches(T resource) {
                return Objects.equals(namespace, resource.getMetadata().getNamespace());
            }
        };
    }

    public static Condition<Pod> status(final PodStatusType status) {
        return new Condition<Pod>(){

            public String toString() {
                return "podStatus(" + status + ")";
            }

            public boolean matches(Pod pod) {
                return Objects.equals(status, KubernetesHelper.getPodStatus((Pod)pod));
            }
        };
    }

    public static Condition<Pod> runningStatus() {
        return Conditions.status(PodStatusType.OK);
    }

    public static Condition<Pod> waitingStatus() {
        return Conditions.status(PodStatusType.WAIT);
    }

    public static Condition<Pod> errorStatus() {
        return Conditions.status(PodStatusType.ERROR);
    }

    public static Condition<Pod> podLabel(final String key, final String value) {
        return new Condition<Pod>(){

            public String toString() {
                return "podLabel(" + key + " = " + value + ")";
            }

            public boolean matches(Pod pod) {
                return Conditions.matchesLabel(pod.getMetadata().getLabels(), key, value);
            }
        };
    }

    public static Condition<Pod> podNamespace(final String namespace) {
        return new Condition<Pod>(){

            public String toString() {
                return "podNamespace(" + namespace + ")";
            }

            public boolean matches(Pod pod) {
                return Objects.equals(namespace, pod.getMetadata().getNamespace());
            }
        };
    }

    public static Condition<ReplicationController> replicationControllerLabel(final String key, final String value) {
        return new Condition<ReplicationController>(){

            public String toString() {
                return "replicationControllerLabel(" + key + " = " + value + ")";
            }

            public boolean matches(ReplicationController replicationControllerSchema) {
                return Conditions.matchesLabel(replicationControllerSchema.getMetadata().getLabels(), key, value);
            }
        };
    }

    public static Condition<Service> serviceLabel(final String key, final String value) {
        return new Condition<Service>(){

            public String toString() {
                return "serviceLabel(" + key + " = " + value + ")";
            }

            public boolean matches(Service service) {
                return Conditions.matchesLabel(service.getMetadata().getLabels(), key, value);
            }
        };
    }

    public static boolean matchesLabel(Map<String, String> labels, String key, String value) {
        if (labels != null) {
            String actual = labels.get(key);
            return Objects.equals(value, actual);
        }
        return false;
    }
}

